/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package eu.fispace.api;

import eu.fispace.api.wc.ProvideWeatherConditionsRequestMessage;
import eu.fispace.api.wc.ProvideWeatherConditionsResponseMessage;
import eu.limetri.ygg.api.CapabilityType;
import eu.limetri.ygg.api.CapabilityTypeRegistration;

public class DomainWeatherConditions {

    public static final String DOMAIN = "wc";
    public static final String SCHEMA = "classpath:/schema/domain/wc/WCMessages.xsd";
    public static final String CONTEXT_PATH = "eu.fispace.api.wc";

     /**
     * This capability is to be provided by a "weather conditions provider" to provide weather information to a client.
     * 
     * Expected behaviour of the system implementing this capability:
     * - if a request for weather info cannot be fulfilled at once, the answer should be HTTP 204
     * - if a request for weather info can be fulfilled at once, the answer should be HTTP 303, including a URL where the actual weather info can be fetched
     * - if the URL returned by a previous 303 answer is used to call this capability, the answer should be the actual ProvideWeatherConditionsResponseMessage
     * 
     * @since 0.10.0
     * @see ProvideWeatherConditionsRequestMessage
     * @see ProvideWeatherConditionsResponseMessage
     */
    @CapabilityTypeRegistration
    public static final CapabilityType PROVIDE_WEATHER_CONDITIONS = new CapabilityType()
            .withName("PROVIDE_WEATHER_CONDITIONS")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(ProvideWeatherConditionsRequestMessage.class.getSimpleName())
            .withResponseMessageType(ProvideWeatherConditionsResponseMessage.class.getSimpleName());

}
