/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package eu.fispace.api;

import eu.fispace.api.admin.AppRegistration;
import eu.limetri.ygg.api.CapabilityType;
import eu.limetri.ygg.api.CapabilityTypeRegistration;
import eu.limetri.ygg.api.Messages;

/**
 *
 * @author Dimitris Soukras <dsoukaras@di.uoa.gr>
 */
public class DomainAdmin {

    public static final String DOMAIN = "admin";
    public static final String SCHEMA = "classpath:/schema/domain/admin/StoreMessages.xsd";
    public static final String CONTEXT_PATH = "eu.fispace.api.admin";

    /**
     * Capability to receive a new app creation request
     *
     * Example: FIspace SDK use this capabilty so that an app developer can send
     * new app request details into FIspace platform and specifically to Store
     * component
     *
     * @since 0.10.1
     * @see CreateNewApp
     */
    @CapabilityTypeRegistration
    public static final CapabilityType RECEIVE_APP = new CapabilityType()
            .withName("receive new application")
            .withSchemaLocation(SCHEMA)
            .withContextPath(CONTEXT_PATH)
            .withRequestMessageType(AppRegistration.class.getSimpleName())
            .withResponseMessageType(Messages.Untyped.class.getSimpleName());

}
