/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.fispace.api.generic;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * @author reimer
 */
public class RoutingInfoMapAdapter extends XmlAdapter<RoutingInfoMap, Map<String, String>> {

    @Override
    public Map<String, String> unmarshal(RoutingInfoMap routingInfoMap) throws Exception {
        Map<String, String> map = new LinkedHashMap<>();
        routingInfoMap.getEntry().forEach(entry -> map.put(entry.key, entry.value));
        return map;
    }

    @Override
    public RoutingInfoMap marshal(Map<String, String> map) throws Exception {
        RoutingInfoMap routingInfoMap = new RoutingInfoMap();
        map.entrySet().forEach(entry -> routingInfoMap.getEntry().add(
                new RoutingInfoEntry()
                        .withKey(entry.getKey())
                        .withValue(entry.getValue())));
        return routingInfoMap;
    }

}
