/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package eu.fispace.api;

import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.common.NotificationMessage;
import eu.fispace.api.common.ResourceAvailableNotificationMessage;
import eu.fispace.api.common.TextNotificationMessage;
import javax.ws.rs.core.Response;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainCommon {
    public static final String DOMAIN = "domain/co";
    
    /**
     * Capability to receive text notifications
     * 
     * @since 0.7.0
     * @see TextNotificationMessage
     */
    public static final PostCapability<TextNotificationMessage, Response> RECEIVE_TEXT_NOTIFICATION = (PostCapability<TextNotificationMessage, Response>)new PostCapability<TextNotificationMessage, Response>()
            .withDomain(DOMAIN)
            .withName("receive text notification")
            .withResource("ReceiveTextNotification")
            .withRequestMessageClass(TextNotificationMessage.class)
            .withResponsetMessageClass(Response.class);   
    
    /**
     * Capability to receive resource available notifications
     * For example, when an advice is ready
     * 
     * @since 0.7.0
     * @see ResourceAvailableNotificationMessage
     */
    public static final PostCapability<ResourceAvailableNotificationMessage, Response> RECEIVE_RESOURCE_AVAILABLE_NOTIFICATION = (PostCapability<ResourceAvailableNotificationMessage, Response>)new PostCapability<ResourceAvailableNotificationMessage, Response>()
            .withDomain(DOMAIN)
            .withName("receive resource available notification")
            .withResource("ReceiveResourceAvailableNotification")
            .withRequestMessageClass(ResourceAvailableNotificationMessage.class)
            .withResponsetMessageClass(Response.class);      
}
