/**
 * Copyright (C) 2008-2013 LimeTri. All rights reserved.
 *
 * AgroSense is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it
 * is applied to this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * AgroSense. If not, see <http://www.gnu.org/licenses/>.
 */

package eu.fispace.api;

import eu.agrosense.api.platform.GetCapability;
import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.ag.CropFieldAdviceRequestMessage;
import eu.fispace.api.ag.CropFieldDetailMessage;
import eu.fispace.api.ag.GreenhouseAdvice;
import eu.fispace.api.ag.GreenhouseSensorInformation;
import eu.fispace.api.ag.PhythophthoraAdviceMessage;
import javax.ws.rs.core.Response;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainAgriculture {
    public static final String DOMAIN = "ag";
    
    /**
     * Capability to produce phytophthora advice
     * @since 0.5.0
     * @see PhythophthoraAdviceMessage
     */
    public static final GetCapability<PhythophthoraAdviceMessage> PRODUCE_PHYTOPHTHORA_ADVICE = (GetCapability<PhythophthoraAdviceMessage>)new GetCapability<PhythophthoraAdviceMessage>()
            .withDomain(DOMAIN)
            .withName("phytophthora advice")
            .withResource("phytophthoraAdvice")
            .withResponsetMessageClass(PhythophthoraAdviceMessage.class);        
    
    
    /**
     * Capability to produce cropfield details
     * @since 0.5.0
     * @see CropFieldDetailMessage
     */
    public static final GetCapability<CropFieldDetailMessage> PRODUCE_CROPFIELD_DETAILS = (GetCapability<CropFieldDetailMessage>)new GetCapability<CropFieldDetailMessage>()
            .withDomain(DOMAIN)
            .withName("cropfield details")
            .withResource("cropfield")
            .withResponsetMessageClass(CropFieldDetailMessage.class);    

    /**
     * 
     * @since 0.5.0
     * @see GreenhouseSensorInformation
     */
    public static final PostCapability<GreenhouseSensorInformation, Response> RECEIVE_SENSOR_VALUES = (PostCapability<GreenhouseSensorInformation, Response>)new PostCapability<GreenhouseSensorInformation, Response>()
            .withDomain(DOMAIN)
            .withName("receive sensor values")
            .withResource("GreenhouseSensorInformation")
            .withRequestMessageClass(GreenhouseSensorInformation.class)
            .withResponsetMessageClass(Response.class);   
    
    
    /**
     * 
     * @since 0.5.0
     * @see GreenhouseAdvice
     */    
    public static final PostCapability<GreenhouseAdvice, Response> RECEIVE_GREENHOUSE_ADVICE = (PostCapability<GreenhouseAdvice, Response>)new PostCapability<GreenhouseAdvice, Response>()
            .withDomain(DOMAIN)
            .withName("greenhouse advice")
            .withResource("GreenHouseAdvice")
            .withRequestMessageClass(GreenhouseAdvice.class)
            .withResponsetMessageClass(Response.class);   
    
    /**
     * 
     * @since 0.7.2
     * @see CropFieldAdviceRequestMessage
     */    
    public static final PostCapability<CropFieldAdviceRequestMessage, Response> RECEIVE_ADVICE_REQUEST = (PostCapability<CropFieldAdviceRequestMessage, Response>)new PostCapability<CropFieldAdviceRequestMessage, Response>()
            .withDomain(DOMAIN)
            .withName("greenhouse advice")
            .withResource("GreenHouseAdvice")
            .withRequestMessageClass(CropFieldAdviceRequestMessage.class)
            .withResponsetMessageClass(Response.class);       
}
