/**
 * Copyright (C) 2008-2013 LimeTri. All rights reserved.
 *
 * AgroSense is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * There are special exceptions to the terms and conditions of the GPLv3 as it
 * is applied to this software, see the FLOSS License Exception
 * <http://www.agrosense.eu/foss-exception.html>.
 *
 * AgroSense is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * AgroSense. If not, see <http://www.gnu.org/licenses/>.
 */
package eu.fispace.api;

import eu.agrosense.api.platform.GetCapability;
import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.lg.LegDeadlineExceeded;
import eu.fispace.api.lg.LegFinished;
import eu.fispace.api.lg.Notification;
import eu.fispace.api.lg.NotifyDelay;
import eu.fispace.api.lg.TransportPlan;
import javax.ws.rs.core.Response;

/**
 *
 * @author Timon Veenstra <timon@agrosense.eu>
 */
public class DomainLogistics {

    public static final String DOMAIN = "lg";
    /**
     * message Logistics planning app -> FIspace, notification of logistis plan,
     * can be used for either new logistics plan as well as updates
     *
     * @since 0.7.2
     * @see TransportPlan
     */
    public static final PostCapability<TransportPlan, Response> RECEIVE_TRANSPORT_PLAN = (PostCapability<TransportPlan, Response>) new PostCapability<TransportPlan, Response>()
            .withDomain(DOMAIN)
            .withName("receive transport plan")
            .withResource("ReceiveTransportPlan")
            .withRequestMessageClass(TransportPlan.class)
            .withResponsetMessageClass(Response.class);
    /**
     * message Logistics planning app -> FIspace, notification that the deadline
     * of a leg has exceeded
     *
     * @since 0.7.2
     * @see LegDeadlineExceeded
     */
    public static final PostCapability<LegDeadlineExceeded, Response> RECEIVE_LEG_DEADLINE_EXCEEDED = (PostCapability<LegDeadlineExceeded, Response>) new PostCapability<LegDeadlineExceeded, Response>()
            .withDomain(DOMAIN)
            .withName("receive leg deadline exceeded")
            .withResource("ReceiveLegDeadlineExceeded")
            .withRequestMessageClass(LegDeadlineExceeded.class)
            .withResponsetMessageClass(Response.class);

    /**
     * message FIspace ->Logistics planning app, notification of delay
     *
     * @since 0.7.2
     * @see NotifyDelay
     */
    public static final PostCapability<NotifyDelay, Response> RECEIVE_NOTIFY_DELAY = (PostCapability<NotifyDelay, Response>) new PostCapability<NotifyDelay, Response>()
            .withDomain(DOMAIN)
            .withName("receive notification of delay")
            .withResource("ReceiveNotifyDelay")
            .withRequestMessageClass(NotifyDelay.class)
            .withResponsetMessageClass(Response.class);
    
    /**
     *  message FIspace -> Logistics planning app, notification about a leg that was finished
     *
     * @since 0.7.2
     * @see LegFinished
     */
    public static final PostCapability<LegFinished, Response> RECEIVE_LEG_FINISHED = (PostCapability<LegFinished, Response>) new PostCapability<LegFinished, Response>()
            .withDomain(DOMAIN)
            .withName("receive leg finished")
            .withResource("ReceiveLegFinished")
            .withRequestMessageClass(LegFinished.class)
            .withResponsetMessageClass(Response.class);
    
    /**
     * Capability to produce shipment notifications
     * @since 0.7.2
     * @see Notification
     */
    public static final GetCapability<Notification> PRODUCE_NOTIFICATION = (GetCapability<Notification>)new GetCapability<Notification>()
            .withDomain(DOMAIN)
            .withName("cropfield details")
            .withResource("cropfield")
            .withResponsetMessageClass(Notification.class);        
}
