/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package eu.fispace.api;

import eu.agrosense.api.platform.GetCapability;
import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.ag.CropFieldAdviceRequestMessage;
import eu.fispace.api.ag.CropFieldDetailMessage;
import eu.fispace.api.ag.GreenhouseAdvice;
import eu.fispace.api.ag.GreenhouseSensorInformation;
import eu.fispace.api.ag.PhythophthoraAdviceMessage;
import eu.fispace.api.ag.RequestForGreenhouseAdvice;
import javax.ws.rs.core.Response;

/**
 *
 * @author Timon Veenstra <timon@limetri.eu>
 */
public class DomainAgriculture {

    public static final String DOMAIN = "ag";

    /**
     * Capability to produce phytophthora advice
     *
     * @since 0.5.0
     * @see PhythophthoraAdviceMessage
     */
    public static final GetCapability<PhythophthoraAdviceMessage> PRODUCE_PHYTOPHTHORA_ADVICE = (GetCapability<PhythophthoraAdviceMessage>) new GetCapability<PhythophthoraAdviceMessage>()
            .withDomain(DOMAIN)
            .withName("phytophthora advice")
            .withResource("phytophthoraAdvice")
            .withResponsetMessageClass(PhythophthoraAdviceMessage.class);

    /**
     * Capability to produce cropfield details
     *
     * @since 0.5.0
     * @see CropFieldDetailMessage
     */
    public static final GetCapability<CropFieldDetailMessage> PRODUCE_CROPFIELD_DETAILS = (GetCapability<CropFieldDetailMessage>) new GetCapability<CropFieldDetailMessage>()
            .withDomain(DOMAIN)
            .withName("cropfield details")
            .withResource("cropfield")
            .withResponsetMessageClass(CropFieldDetailMessage.class);

    /**
     *
     * @since 0.5.0
     * @see GreenhouseSensorInformation
     */
    public static final PostCapability<GreenhouseSensorInformation, Response> RECEIVE_SENSOR_VALUES = (PostCapability<GreenhouseSensorInformation, Response>) new PostCapability<GreenhouseSensorInformation, Response>()
            .withDomain(DOMAIN)
            .withName("receive sensor values")
            .withResource("GreenhouseSensorInformation")
            .withRequestMessageClass(GreenhouseSensorInformation.class)
            .withResponsetMessageClass(Response.class);

    /**
     *
     * @since 0.5.0
     * @see GreenhouseAdvice
     */
    public static final PostCapability<GreenhouseAdvice, Response> RECEIVE_GREENHOUSE_ADVICE = (PostCapability<GreenhouseAdvice, Response>) new PostCapability<GreenhouseAdvice, Response>()
            .withDomain(DOMAIN)
            .withName("greenhouse advice")
            .withResource("GreenHouseAdvice")
            .withRequestMessageClass(GreenhouseAdvice.class)
            .withResponsetMessageClass(Response.class);

    /**
     *
     * @since 0.7.2
     * @see CropFieldAdviceRequestMessage
     */
    public static final PostCapability<CropFieldAdviceRequestMessage, Response> RECEIVE_ADVICE_REQUEST = (PostCapability<CropFieldAdviceRequestMessage, Response>) new PostCapability<CropFieldAdviceRequestMessage, Response>()
            .withDomain(DOMAIN)
            .withName("greenhouse advice")
            .withResource("GreenHouseAdvice")
            .withRequestMessageClass(CropFieldAdviceRequestMessage.class)
            .withResponsetMessageClass(Response.class);
    
    /**
     * 
     * @since 0.8.1
     * @see RequestForGreenhouseAdvice
     */
     public static final PostCapability<RequestForGreenhouseAdvice, Response> RECEIVE_REQUEST_FOR_GREENHOUSE_ADVICE = (PostCapability<RequestForGreenhouseAdvice, Response>) new PostCapability<RequestForGreenhouseAdvice, Response>()
            .withDomain(DOMAIN)
            .withName("receive request for greenhouse advice")
            .withResource("RequestForGreenhouseAdvice")
            .withRequestMessageClass(RequestForGreenhouseAdvice.class)
            .withResponsetMessageClass(Response.class);
}
