/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.fispace.api;

import javax.ws.rs.core.Response;

import eu.agrosense.api.platform.GetCapability;
import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.lg.LegDeadlineExceeded;
import eu.fispace.api.lg.LegFinished;
import eu.fispace.api.lg.Notification;
import eu.fispace.api.lg.NotifyDelay;
import eu.fispace.api.lg.PIAShipmentStatusMessage;
import eu.fispace.api.lg.TICPushMessage;
import eu.fispace.api.lg.TransportPlan;

/**
 *
 * @author Timon Veenstra <timon@agrosense.eu>
 */
public class DomainLogistics {

    public static final String DOMAIN = "lg";
    /**
     * message Logistics planning app -> FIspace, notification of logistis plan,
     * can be used for either new logistics plan as well as updates
     *
     * @since 0.7.2
     * @see TransportPlan
     */
    public static final PostCapability<TransportPlan, Response> RECEIVE_TRANSPORT_PLAN = (PostCapability<TransportPlan, Response>) new PostCapability<TransportPlan, Response>()
            .withDomain(DOMAIN)
            .withName("receive transport plan")
            .withResource("ReceiveTransportPlan")
            .withRequestMessageClass(TransportPlan.class)
            .withResponsetMessageClass(Response.class);
    /**
     * message Logistics planning app -> FIspace, notification that the deadline
     * of a leg has exceeded
     *
     * @since 0.7.2
     * @see LegDeadlineExceeded
     */
    public static final PostCapability<LegDeadlineExceeded, Response> RECEIVE_LEG_DEADLINE_EXCEEDED = (PostCapability<LegDeadlineExceeded, Response>) new PostCapability<LegDeadlineExceeded, Response>()
            .withDomain(DOMAIN)
            .withName("receive leg deadline exceeded")
            .withResource("ReceiveLegDeadlineExceeded")
            .withRequestMessageClass(LegDeadlineExceeded.class)
            .withResponsetMessageClass(Response.class);

    /**
     * message FIspace ->Logistics planning app, notification of delay
     *
     * @since 0.7.2
     * @see NotifyDelay
     */
    public static final PostCapability<NotifyDelay, Response> RECEIVE_NOTIFY_DELAY = (PostCapability<NotifyDelay, Response>) new PostCapability<NotifyDelay, Response>()
            .withDomain(DOMAIN)
            .withName("receive notification of delay")
            .withResource("ReceiveNotifyDelay")
            .withRequestMessageClass(NotifyDelay.class)
            .withResponsetMessageClass(Response.class);
    
    /**
     *  message FIspace -> Logistics planning app, notification about a leg that was finished
     *
     * @since 0.7.2
     * @see LegFinished
     */
    public static final PostCapability<LegFinished, Response> RECEIVE_LEG_FINISHED = (PostCapability<LegFinished, Response>) new PostCapability<LegFinished, Response>()
            .withDomain(DOMAIN)
            .withName("receive leg finished")
            .withResource("ReceiveLegFinished")
            .withRequestMessageClass(LegFinished.class)
            .withResponsetMessageClass(Response.class);
    
    /**
     * Capability to produce shipment notifications
     * @since 0.7.2
     * @see Notification
     */
    public static final GetCapability<Notification> PRODUCE_NOTIFICATION = (GetCapability<Notification>)new GetCapability<Notification>()
            .withDomain(DOMAIN)
            .withName("cropfield details")
            .withResource("cropfield")
            .withResponsetMessageClass(Notification.class);        
    
    /**
     * Capability to receive PIA shipment status message
     * @since 0.9.0
     */
    public static final PostCapability<PIAShipmentStatusMessage, Response> RECEIVE_PIA_SHIPMENT_STATUS_MESSAGE = (PostCapability<PIAShipmentStatusMessage, Response>) new PostCapability<PIAShipmentStatusMessage, Response>()
            .withDomain(DOMAIN)
            .withName("receive PIA shipment status")
            .withResource("ReceivePIAShipmentStatus")
            .withResponsetMessageClass(Response.class);        
    
    /**
     * Capability to receive TIC push message
     * @since 0.9.0
     */
    public static final PostCapability<TICPushMessage, Response> RECEIVE_TIC_PUSH_MESSAGE = (PostCapability<TICPushMessage, Response>) new PostCapability<TICPushMessage, Response>()
            .withDomain(DOMAIN)
            .withName("receive TIC push message")
            .withResource("ReceiveTICPushMessage")
            .withResponsetMessageClass(Response.class);        
}
