/**
 * Copyright (C) 2013 FIspace (info@fispace.eu)
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package eu.fispace.api;

import javax.ws.rs.core.Response;

import eu.agrosense.api.platform.PostCapability;
import eu.fispace.api.wc.RequestWeatherCondition;
import eu.fispace.api.wc.WeatherCondition;

public class DomainWeatherConditions {

	public static final String DOMAIN = "wc";

	public static final PostCapability<WeatherCondition, Response> RECEIVE_WEATHER_CONDITIONS = (PostCapability<WeatherCondition, Response>) new PostCapability<WeatherCondition, Response>()
			.withDomain(DOMAIN).withName("weather conditions")
			.withResource("WeatherCondition")
			.withResponsetMessageClass(WeatherCondition.class);

	public static final PostCapability<RequestWeatherCondition, Response> REQUEST_WEATHER_CONDITIONS = (PostCapability<RequestWeatherCondition, Response>) new PostCapability<RequestWeatherCondition, Response>()
			.withDomain(DOMAIN).withName("receive weather conditions")
			.withResource("WeatherCondition")
			.withRequestMessageClass(RequestWeatherCondition.class);

}
