/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.base.starter;

import eu.fraho.spring.securityJwt.base.config.RefreshCookieProperties;
import eu.fraho.spring.securityJwt.base.config.RefreshProperties;
import eu.fraho.spring.securityJwt.base.config.TokenCookieProperties;
import eu.fraho.spring.securityJwt.base.config.TokenHeaderProperties;
import eu.fraho.spring.securityJwt.base.config.TokenProperties;
import eu.fraho.spring.securityJwt.base.config.TotpProperties;
import eu.fraho.spring.securityJwt.base.controller.LoginRestController;
import eu.fraho.spring.securityJwt.base.controller.LogoutRestController;
import eu.fraho.spring.securityJwt.base.dto.JwtUser;
import eu.fraho.spring.securityJwt.base.service.JwtTokenService;
import eu.fraho.spring.securityJwt.base.service.JwtTokenServiceImpl;
import eu.fraho.spring.securityJwt.base.service.LoginService;
import eu.fraho.spring.securityJwt.base.service.LoginServiceImpl;
import eu.fraho.spring.securityJwt.base.service.RefreshService;
import eu.fraho.spring.securityJwt.base.service.RefreshServiceImpl;
import eu.fraho.spring.securityJwt.base.service.TotpService;
import eu.fraho.spring.securityJwt.base.service.TotpServiceImpl;
import eu.fraho.spring.securityJwt.base.starter.EmptyUserDetailsService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@AutoConfigureBefore(value={SecurityAutoConfiguration.class})
public class SecurityJwtBaseAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityJwtBaseAutoConfiguration.class);

    @Bean
    public TotpProperties totpProperties() {
        log.debug("Register TotpProperties");
        return new TotpProperties();
    }

    @Bean
    public TotpService totpService() {
        log.debug("Register TotpService");
        TotpServiceImpl totpService = new TotpServiceImpl();
        totpService.setTotpProperties(this.totpProperties());
        return totpService;
    }

    @Bean
    public TokenProperties tokenProperties() {
        log.debug("Register TokenProperties");
        return new TokenProperties();
    }

    @Bean
    public RefreshProperties refreshProperties() {
        log.debug("Register RefreshProperties");
        return new RefreshProperties();
    }

    @Bean
    public JwtTokenService jwtTokenService() {
        log.debug("Register JwtTokenService");
        JwtTokenServiceImpl jwtTokenService = new JwtTokenServiceImpl();
        jwtTokenService.setTokenProperties(this.tokenProperties());
        jwtTokenService.setRefreshProperties(this.refreshProperties());
        jwtTokenService.setTokenCookieProperties(this.tokenCookieProperties());
        jwtTokenService.setTokenHeaderProperties(this.tokenHeaderProperties());
        jwtTokenService.setRefreshCookieProperties(this.refreshCookieProperties());
        jwtTokenService.setJwtUser(this::jwtUser);
        return jwtTokenService;
    }

    @Bean
    public TokenCookieProperties tokenCookieProperties() {
        log.debug("Register TokenCookieProperties");
        return new TokenCookieProperties();
    }

    @Bean
    public TokenHeaderProperties tokenHeaderProperties() {
        log.debug("Register TokenHeaderProperties");
        return new TokenHeaderProperties();
    }

    @Bean
    public RefreshCookieProperties refreshCookieProperties() {
        log.debug("Register RefreshCookieProperties");
        return new RefreshCookieProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        log.debug("Register BCryptPasswordEncoder");
        return new BCryptPasswordEncoder();
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public JwtUser jwtUser() {
        log.debug("Register JwtUser");
        return new JwtUser();
    }

    @Bean
    @ConditionalOnMissingBean
    public UserDetailsService defaultUserDetailsService() {
        log.debug("Register EmptyUserDetailsService");
        return new EmptyUserDetailsService();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginService loginService(AuthenticationManager authenticationManager, JwtTokenService jwtTokenService, UserDetailsService userDetailsService, TotpService totpService) {
        LoginServiceImpl service = new LoginServiceImpl();
        service.setAuthenticationManager(authenticationManager);
        service.setJwtTokenService(jwtTokenService);
        service.setUserDetailsService(userDetailsService);
        service.setTotpService(totpService);
        return service;
    }

    @Bean
    @ConditionalOnMissingBean
    public RefreshService refreshService(JwtTokenService jwtTokenService) {
        RefreshServiceImpl service = new RefreshServiceImpl();
        service.setJwtTokenService(jwtTokenService);
        return service;
    }

    @Bean
    public LoginRestController loginRestController(LoginService loginService, TokenCookieProperties tokenCookieProperties, RefreshCookieProperties refreshCookieProperties) {
        log.debug("Register LoginRestController");
        LoginRestController controller = new LoginRestController();
        controller.setLoginService(loginService);
        controller.setTokenCookieProperties(tokenCookieProperties);
        controller.setRefreshCookieProperties(refreshCookieProperties);
        return controller;
    }

    @Bean
    @ConditionalOnExpression(value="'${fraho.jwt.token.cookie.enabled}' == 'true' or '${fraho.jwt.refresh.cookie.enabled}' == 'true'")
    public LogoutRestController logoutRestController(TokenCookieProperties tokenCookieProperties, RefreshCookieProperties refreshCookieProperties) {
        log.debug("Register LogoutRestController");
        LogoutRestController controller = new LogoutRestController();
        controller.setTokenCookieProperties(tokenCookieProperties);
        controller.setRefreshCookieProperties(refreshCookieProperties);
        return controller;
    }
}

