/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.base.starter;

import eu.fraho.spring.securityJwt.base.config.RefreshCookieProperties;
import eu.fraho.spring.securityJwt.base.config.TokenCookieProperties;
import eu.fraho.spring.securityJwt.base.controller.RefreshRestController;
import eu.fraho.spring.securityJwt.base.service.JwtTokenService;
import eu.fraho.spring.securityJwt.base.service.NullTokenStore;
import eu.fraho.spring.securityJwt.base.service.RefreshTokenStore;
import eu.fraho.spring.securityJwt.base.starter.ConditionalOnRefreshEnabled;
import eu.fraho.spring.securityJwt.base.starter.SecurityJwtBaseAutoConfiguration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={SecurityJwtBaseAutoConfiguration.class})
public class SecurityJwtNoRefreshStoreAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityJwtNoRefreshStoreAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RefreshTokenStore refreshTokenStore() {
        return new NullTokenStore();
    }

    @Bean
    @Conditional(value={ConditionalOnRefreshEnabled.class})
    public RefreshRestController refreshRestController(JwtTokenService jwtTokenService, TokenCookieProperties tokenCookieProperties, RefreshCookieProperties refreshCookieProperties) {
        log.debug("Register RefreshRestController");
        RefreshRestController controller = new RefreshRestController();
        controller.setJwtTokenService(jwtTokenService);
        controller.setTokenCookieProperties(tokenCookieProperties);
        controller.setRefreshCookieProperties(refreshCookieProperties);
        return controller;
    }
}

