/*
 * Decompiled with CFR 0.152.
 */
package eu.fraho.spring.securityJwt.base.starter;

import eu.fraho.spring.securityJwt.base.config.CryptProperties;
import eu.fraho.spring.securityJwt.base.password.CryptPasswordEncoder;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@AutoConfigureBefore(value={SecurityAutoConfiguration.class})
public class SecurityJwtPasswordAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityJwtPasswordAutoConfiguration.class);

    @Bean
    public CryptProperties cryptProperties() {
        log.debug("Register CryptProperties");
        return new CryptProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public PasswordEncoder passwordEncoder() {
        log.debug("Register CryptPasswordEncoder");
        CryptPasswordEncoder encoder = new CryptPasswordEncoder();
        encoder.setCryptProperties(this.cryptProperties());
        return encoder;
    }
}

