/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr;

import eu.fthevenet.binjr.controllers.MainViewController;
import eu.fthevenet.binjr.dialogs.StageAppearanceManager;
import eu.fthevenet.util.logging.Profiler;
import java.awt.SplashScreen;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Binjr
extends Application {
    public static final Logger runtimeDebuggingFeatures = LogManager.getLogger((String)"runtimeDebuggingFeatures");
    private static final Logger logger = LogManager.getLogger(Binjr.class);

    public void start(Stage primaryStage) throws Exception {
        logger.info(() -> "Starting binjr");
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/views/MainView.fxml"));
        Parent root = (Parent)loader.load();
        MainViewController mainViewController = (MainViewController)loader.getController();
        mainViewController.setParameters(this.getParameters());
        primaryStage.setTitle("binjr");
        StageAppearanceManager.getInstance().register(primaryStage);
        try (Profiler p = Profiler.start("Set scene", arg_0 -> ((Logger)logger).trace(arg_0));){
            primaryStage.setScene(new Scene(root));
        }
        p = Profiler.start("show", arg_0 -> ((Logger)logger).trace(arg_0));
        var6_6 = null;
        try {
            primaryStage.show();
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (p != null) {
                if (var6_6 != null) {
                    try {
                        p.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    p.close();
                }
            }
        }
        SplashScreen splash = SplashScreen.getSplashScreen();
        if (splash != null) {
            splash.close();
        }
    }

    public static void main(String[] args) {
        String jaasCfgPath = System.getProperty("java.security.auth.login.config");
        if (jaasCfgPath == null || jaasCfgPath.trim().length() == 0) {
            System.setProperty("java.security.auth.login.config", Binjr.class.getResource("/jaas_login.conf").toExternalForm());
        }
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        System.setProperty("glass.accessible.force", "false");
        Binjr.launch((String[])args);
    }
}

