/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr;

import eu.fthevenet.binjr.Binjr;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Bootstrap {
    private static final Logger logger = LogManager.getLogger(Bootstrap.class);

    public static void main(String[] args) {
        boolean forceStart = false;
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("--forcestart") && !arg.equalsIgnoreCase("-f")) continue;
            forceStart = true;
        }
        if (!Bootstrap.checkForJavaVersion()) {
            logger.log(forceStart ? Level.WARN : Level.FATAL, "This version on binjr only supports Java 8 and will likely fail on the version you're currently running. Please check 'https://github.com/fthevenet/binjr' for a version that runs on more recent versions of Java.");
            if (!forceStart) {
                System.exit(1);
            }
        }
        if (!Bootstrap.checkForJavaFX()) {
            logger.log(forceStart ? Level.WARN : Level.FATAL, "The JavaFX runtime must be present in order to run binjr. Please check with your Java vendor to see is JavaFX is available on your platform and how to install it.");
            if (!forceStart) {
                System.exit(1);
            }
        }
        try {
            Binjr.main(args);
        }
        catch (Exception e) {
            logger.fatal("Failed to load binjr", (Throwable)e);
            System.exit(1);
        }
    }

    private static boolean checkForJavaVersion() {
        try {
            if (System.getProperty("java.runtime.version").startsWith("1.8")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return false;
    }

    private static boolean checkForJavaFX() {
        try {
            logger.info("Class " + Class.forName("javafx.application.Application") + " found: JavaFX runtime is available.");
            return true;
        }
        catch (ClassNotFoundException | NullPointerException e) {
            logger.info("JavaFX is not available on the current runtime environment:\njava.version=" + System.getProperty("java.version") + "\njava.vendor=" + System.getProperty("java.vendor") + "\njava.vm.name=" + System.getProperty("java.vm.name") + "\njava.vm.version=" + System.getProperty("java.vm.version") + "\njava.home=" + System.getProperty("java.home"));
            logger.debug("JavaFX not available", (Throwable)e);
            return false;
        }
    }
}

