/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.binjr.preferences.SysInfoProperty;
import eu.fthevenet.binjr.preferences.UpdateManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.effect.Bloom;
import javafx.scene.effect.Effect;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AboutBoxController
implements Initializable {
    private static final Logger logger = LogManager.getLogger(AboutBoxController.class);
    @FXML
    public WebView licenseView;
    @FXML
    public WebView acknowledgementView;
    @FXML
    private DialogPane aboutRoot;
    @FXML
    private Label versionLabel;
    @FXML
    private TextFlow versionCheckFlow;
    @FXML
    private Hyperlink binjrUrl;
    @FXML
    private Accordion detailsPane;
    @FXML
    private TableView<SysInfoProperty> sysInfoListTable;
    @FXML
    private TitledPane sysInfoPane;
    @FXML
    private TitledPane licensePane;
    @FXML
    private TitledPane acknowledgementPane;

    public void initialize(URL location, ResourceBundle resources) {
        assert (this.aboutRoot != null) : "fx:id\"aboutRoot\" was not injected!";
        assert (this.versionLabel != null) : "fx:id\"versionLabel\" was not injected!";
        assert (this.binjrUrl != null) : "fx:id\"binjrUrl\" was not injected!";
        assert (this.detailsPane != null) : "fx:id\"detailsPane\" was not injected!";
        assert (this.sysInfoPane != null) : "fx:id\"sysInfoPane\" was not injected!";
        assert (this.sysInfoListTable != null) : "fx:id\"sysInfoListTable\" was not injected!";
        assert (this.licensePane != null) : "fx:id\"licensePane\" was not injected!";
        assert (this.acknowledgementPane != null) : "fx:id\"thirdPartiesPane\" was not injected!";
        assert (this.versionCheckFlow != null) : "fx:id\"versionCheckFlow\" was not injected!";
        this.acknowledgementView.getEngine().load(this.getClass().getResource("/text/about_Acknowledgements.html").toExternalForm());
        this.licenseView.getEngine().load(this.getClass().getResource("/text/about_license.html").toExternalForm());
        this.aboutRoot.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ESCAPE) {
                Dialogs.getStage((Node)this.aboutRoot).close();
            }
        });
        this.aboutRoot.sceneProperty().addListener((observable, oldValue, scene) -> {
            if (scene != null) {
                this.licenseView.setMaxSize(scene.getWidth(), scene.getHeight());
                this.licenseView.maxWidthProperty().bind((ObservableValue)scene.widthProperty());
                this.licenseView.maxHeightProperty().bind((ObservableValue)scene.heightProperty());
            } else {
                this.licenseView.maxWidthProperty().unbind();
                this.licenseView.maxHeightProperty().unbind();
            }
        });
        Platform.runLater(() -> {
            this.overrideCss();
            Pane header = (Pane)this.sysInfoListTable.lookup("TableHeaderRow");
            if (header != null) {
                header.setMaxHeight(0.0);
                header.setMinHeight(0.0);
                header.setPrefHeight(0.0);
                header.setVisible(false);
            }
            this.licenseView.setContextMenuEnabled(false);
            this.acknowledgementView.setContextMenuEnabled(false);
        });
        this.versionCheckFlow.getChildren().clear();
        Label l = new Label("Checking for updates...");
        l.setTextFill((Paint)Color.DARKGRAY);
        l.setPadding(new Insets(3.0, 0.0, 0.0, 4.0));
        this.versionCheckFlow.getChildren().add((Object)l);
        UpdateManager.getInstance().asyncForcedCheckForUpdate(githubRelease -> {
            this.versionCheckFlow.getChildren().clear();
            Hyperlink latestReleaseLink = new Hyperlink("v" + githubRelease.getVersion().toString() + " is available");
            latestReleaseLink.setTextFill((Paint)Color.valueOf((String)"#4BACC6"));
            latestReleaseLink.setEffect((Effect)new Bloom());
            latestReleaseLink.setOnAction(event -> {
                try {
                    Dialogs.launchUrlInExternalBrowser(githubRelease.getHtmlUrl());
                }
                catch (IOException | URISyntaxException e) {
                    logger.error((Object)e);
                }
            });
            this.versionCheckFlow.getChildren().add((Object)latestReleaseLink);
        }, version -> l.setText("binjr is up to date"), () -> this.versionCheckFlow.getChildren().clear());
        this.sysInfoListTable.getItems().addAll(AppEnvironment.getInstance().getSysInfoProperties());
        this.versionLabel.setText("version " + AppEnvironment.getInstance().getVersion());
        this.detailsPane.getPanes().forEach(p -> p.expandedProperty().addListener((obs, oldValue, newValue) -> Platform.runLater(() -> {
            p.requestLayout();
            p.getScene().getWindow().sizeToScene();
        })));
        Node closeButton = this.aboutRoot.lookupButton(ButtonType.CLOSE);
        closeButton.managedProperty().bind((ObservableValue)closeButton.visibleProperty());
        closeButton.setVisible(false);
    }

    private void overrideCss() {
        Stage aboutStage = Dialogs.getStage((Node)this.aboutRoot);
        if (aboutStage == null || aboutStage.getScene() == null) {
            logger.warn("Cannot set css: About dialog scene is not ready.");
            return;
        }
        aboutStage.getScene().getStylesheets().clear();
    }

    @FXML
    private void goTobinjrDotEu(ActionEvent actionEvent) {
        try {
            Dialogs.launchUrlInExternalBrowser("http://www.binjr.eu");
        }
        catch (IOException | URISyntaxException e) {
            logger.error((Object)e);
        }
        this.binjrUrl.setVisited(false);
    }
}

