/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.binjr.data.workspace.ChartType;
import eu.fthevenet.binjr.data.workspace.Worksheet;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.animation.TranslateTransition;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.controlsfx.control.ToggleSwitch;

public class ChartPropertiesController<T extends Number>
implements Initializable {
    public static final double SETTINGS_PANE_DISTANCE = -210.0;
    private final BooleanProperty visible = new SimpleBooleanProperty(false);
    private final BooleanProperty hidden = new SimpleBooleanProperty(true);
    private final Chart<T> chart;
    private final Worksheet<T> worksheet;
    @FXML
    private AnchorPane root;
    @FXML
    private Button closeButton;
    @FXML
    private Slider graphOpacitySlider = new Slider();
    @FXML
    private Label graphOpacityLabel = new Label();
    @FXML
    private Slider strokeWidthSlider = new Slider();
    @FXML
    private Label strokeWidthText = new Label();
    @FXML
    private Label strokeWidthLabel = new Label();
    @FXML
    private Label opacityText = new Label();
    @FXML
    private ToggleSwitch showAreaOutline = new ToggleSwitch();
    @FXML
    private ChoiceBox<ChartType> chartTypeChoice;
    @FXML
    private TextField yMinRange;
    @FXML
    private TextField yMaxRange;
    @FXML
    private ToggleSwitch autoScaleYAxis;
    @FXML
    private HBox yAxisScaleSettings;

    public ChartPropertiesController(Worksheet<T> worksheet, Chart<T> chart) {
        this.worksheet = worksheet;
        this.chart = chart;
    }

    public void show() {
        if (this.hidden.getValue().booleanValue()) {
            this.slidePanel(-1, Duration.millis((double)0.0));
            this.hidden.setValue(Boolean.valueOf(false));
        }
    }

    public void hide() {
        if (!this.hidden.getValue().booleanValue()) {
            this.slidePanel(1, Duration.millis((double)0.0));
            this.hidden.setValue(Boolean.valueOf(true));
        }
    }

    private void slidePanel(int show, Duration delay) {
        this.root.toFront();
        TranslateTransition openNav = new TranslateTransition(new Duration(200.0), (Node)this.root);
        openNav.setDelay(delay);
        openNav.setToX((double)show * 210.0);
        openNav.play();
    }

    public void initialize(URL location, ResourceBundle resources) {
        assert (this.opacityText != null) : "fx:id\"opacityText\" was not injected!";
        assert (this.showAreaOutline != null) : "fx:id\"showAreaOutline\" was not injected!";
        assert (this.graphOpacitySlider != null) : "fx:id\"graphOpacitySlider\" was not injected!";
        assert (this.strokeWidthText != null) : "fx:id\"strokeWidthText\" was not injected!";
        assert (this.strokeWidthSlider != null) : "fx:id\"strokeWidthSlider\" was not injected!";
        assert (this.autoScaleYAxis != null) : "fx:id\"autoScaleYAxis\" was not injected!";
        assert (this.yAxisScaleSettings != null) : "fx:id\"yAxisScaleSettings\" was not injected!";
        NumberStringConverter numberFormatter = new NumberStringConverter(Locale.getDefault(Locale.Category.FORMAT));
        this.graphOpacitySlider.valueProperty().bindBidirectional((Property)this.chart.graphOpacityProperty());
        this.opacityText.textProperty().bind((ObservableValue)Bindings.format((String)"%.0f%%", (Object[])new Object[]{this.graphOpacitySlider.valueProperty().multiply(100)}));
        this.strokeWidthSlider.valueProperty().bindBidirectional((Property)this.chart.strokeWidthProperty());
        this.strokeWidthText.textProperty().bind((ObservableValue)Bindings.format((String)"%.1f", (Object[])new Object[]{this.strokeWidthSlider.valueProperty()}));
        this.adaptToChartType(this.chart.getChartType() == ChartType.LINE);
        this.chart.chartTypeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.adaptToChartType(newValue == ChartType.LINE);
            }
        });
        this.showAreaOutline.selectedProperty().bindBidirectional((Property)this.chart.showAreaOutlineProperty());
        this.autoScaleYAxis.selectedProperty().bindBidirectional((Property)this.chart.autoScaleYAxisProperty());
        this.setAndBindTextFormatter(this.yMinRange, (StringConverter<T>)numberFormatter, (Property<T>)this.chart.yAxisMinValueProperty());
        this.setAndBindTextFormatter(this.yMaxRange, (StringConverter<T>)numberFormatter, (Property<T>)this.chart.yAxisMaxValueProperty());
        this.chartTypeChoice.getItems().setAll((Object[])ChartType.values());
        this.chartTypeChoice.getSelectionModel().select((Object)this.chart.getChartType());
        this.chart.chartTypeProperty().bind((ObservableValue)this.chartTypeChoice.getSelectionModel().selectedItemProperty());
        this.strokeWidthControlDisabled(!this.showAreaOutline.isSelected());
        this.showAreaOutline.selectedProperty().addListener((observable, oldValue, newValue) -> this.strokeWidthControlDisabled(newValue == false));
        this.visibleProperty().addListener((observable, oldValue, newValue) -> this.setPanelVisibility());
        this.visibleProperty().bindBidirectional((Property)this.chart.showPropertiesProperty());
        this.closeButton.setOnAction(e -> this.visibleProperty().setValue(Boolean.valueOf(false)));
        this.yAxisScaleSettings.disableProperty().bind((ObservableValue)this.autoScaleYAxis.selectedProperty());
    }

    void setPanelVisibility() {
        if (this.isVisible()) {
            this.show();
        } else {
            this.hide();
        }
    }

    private <T extends Number> void setAndBindTextFormatter(TextField textField, StringConverter<T> converter, Property<T> stateProperty) {
        TextFormatter formatter = new TextFormatter(converter);
        formatter.valueProperty().bindBidirectional(stateProperty);
        textField.setTextFormatter(formatter);
    }

    private void adaptToChartType(boolean disable) {
        this.showAreaOutline.setDisable(disable);
        this.showAreaOutline.setSelected(disable);
        this.graphOpacitySlider.setDisable(disable);
        this.graphOpacityLabel.setDisable(disable);
        this.opacityText.setDisable(disable);
    }

    private void strokeWidthControlDisabled(boolean disable) {
        this.strokeWidthSlider.setDisable(disable);
        this.strokeWidthText.setDisable(disable);
        this.strokeWidthLabel.setDisable(disable);
    }

    public ReadOnlyBooleanProperty hiddenProperty() {
        return this.hidden;
    }

    public boolean isHidden() {
        return this.hidden.getValue();
    }

    public boolean isVisible() {
        return this.visible.get();
    }

    public BooleanProperty visibleProperty() {
        return this.visible;
    }
}

