/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.controllers.ChartPropertiesController;
import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.util.text.BinaryPrefixFormatter;
import eu.fthevenet.util.text.MetricPrefixFormatter;
import eu.fthevenet.util.text.PrefixFormatter;
import java.time.ZonedDateTime;
import javafx.scene.chart.XYChart;
import javafx.scene.control.TableView;

public class ChartViewPort<T extends Number> {
    private Chart<T> dataStore;
    private XYChart<ZonedDateTime, T> chart;
    private ChartPropertiesController<T> propertiesController;
    private PrefixFormatter prefixFormatter;
    private TableView<TimeSeriesInfo<Double>> seriesTable;

    public ChartViewPort(Chart<T> dataStore, XYChart<ZonedDateTime, T> chart, ChartPropertiesController<T> propertiesController) {
        this.dataStore = dataStore;
        this.chart = chart;
        this.seriesTable = new TableView();
        this.seriesTable.getStyleClass().add((Object)"skinnable-pane-border");
        this.seriesTable.setEditable(true);
        this.propertiesController = propertiesController;
        switch (dataStore.getUnitPrefixes()) {
            case BINARY: {
                this.prefixFormatter = new BinaryPrefixFormatter();
                break;
            }
            case METRIC: {
                this.prefixFormatter = new MetricPrefixFormatter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown unit prefix");
            }
        }
    }

    public ChartPropertiesController<T> getPropertiesController() {
        return this.propertiesController;
    }

    public XYChart<ZonedDateTime, T> getChart() {
        return this.chart;
    }

    public Chart<T> getDataStore() {
        return this.dataStore;
    }

    public PrefixFormatter getPrefixFormatter() {
        return this.prefixFormatter;
    }

    public TableView<TimeSeriesInfo<Double>> getSeriesTable() {
        return this.seriesTable;
    }
}

