/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.controllers.ChartViewPort;
import eu.fthevenet.binjr.controllers.WorksheetController;
import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.util.javafx.charts.XYChartSelection;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.chart.ValueAxis;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChartViewportsState
implements AutoCloseable {
    private final WorksheetController parent;
    private static final Logger logger = LogManager.getLogger(ChartViewportsState.class);
    private HashMap<Chart<Double>, AxisState> axisStates = new HashMap();
    private final SimpleObjectProperty<ZonedDateTime> startX;
    private final SimpleObjectProperty<ZonedDateTime> endX;
    private final ChangeListener<ZonedDateTime> onRefreshAllRequired;
    private ChangeListener<ZonedDateTime> onStartXChanged;
    private ChangeListener<ZonedDateTime> onEndXChanged;

    @Override
    public void close() {
        this.startX.removeListener(this.onRefreshAllRequired);
        this.endX.removeListener(this.onRefreshAllRequired);
        this.axisStates.values().forEach(AxisState::close);
    }

    public void suspendAxisListeners() {
        this.startX.removeListener(this.onRefreshAllRequired);
        this.endX.removeListener(this.onRefreshAllRequired);
        this.axisStates.values().forEach(AxisState::removeListeners);
    }

    public void resumeAxisListeners() {
        this.startX.addListener(this.onRefreshAllRequired);
        this.endX.addListener(this.onRefreshAllRequired);
        this.axisStates.values().forEach(AxisState::addListeners);
    }

    public ChartViewportsState(WorksheetController parent, ZonedDateTime startX, ZonedDateTime endX) {
        this.parent = parent;
        this.onRefreshAllRequired = (observable, oldValue, newValue) -> parent.invalidateAll(true, false, false);
        this.startX = new SimpleObjectProperty((Object)this.roundDateTime(startX));
        this.endX = new SimpleObjectProperty((Object)this.roundDateTime(endX));
        this.startX.addListener(this.onRefreshAllRequired);
        this.endX.addListener(this.onRefreshAllRequired);
        for (ChartViewPort<Double> viewPort : parent.viewPorts) {
            this.put(viewPort.getDataStore(), new AxisState(viewPort, viewPort.getDataStore().getyAxisMinValue(), viewPort.getDataStore().getyAxisMaxValue()));
            this.get(viewPort.getDataStore()).ifPresent(y -> {
                viewPort.getDataStore().yAxisMinValueProperty().bindBidirectional((Property)((AxisState)y).startY);
                ((ValueAxis)viewPort.getChart().getYAxis()).lowerBoundProperty().bindBidirectional((Property)((AxisState)y).startY);
                viewPort.getDataStore().yAxisMaxValueProperty().bindBidirectional((Property)((AxisState)y).endY);
                ((ValueAxis)viewPort.getChart().getYAxis()).upperBoundProperty().bindBidirectional((Property)((AxisState)y).endY);
            });
        }
        parent.getWorksheet().fromDateTimeProperty().bind(this.startX);
        parent.getWorksheet().toDateTimeProperty().bind(this.endX);
    }

    public ZonedDateTime getStartX() {
        return (ZonedDateTime)this.startX.get();
    }

    public SimpleObjectProperty<ZonedDateTime> startXProperty() {
        return this.startX;
    }

    public ZonedDateTime getEndX() {
        return (ZonedDateTime)this.endX.get();
    }

    public SimpleObjectProperty<ZonedDateTime> endXProperty() {
        return this.endX;
    }

    public Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> asSelection() {
        HashMap<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> selection = new HashMap<Chart<Double>, XYChartSelection<ZonedDateTime, Double>>();
        for (Map.Entry<Chart<Double>, AxisState> e : this.axisStates.entrySet()) {
            selection.put(e.getKey(), e.getValue().asSelection());
        }
        return selection;
    }

    public Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> selectTimeRange(ZonedDateTime start, ZonedDateTime end) {
        HashMap<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> selection = new HashMap<Chart<Double>, XYChartSelection<ZonedDateTime, Double>>();
        for (Map.Entry<Chart<Double>, AxisState> e : this.axisStates.entrySet()) {
            selection.put(e.getKey(), e.getValue().selectTimeRange(start, end));
        }
        return selection;
    }

    public void setSelection(Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> selectionMap, boolean toHistory) {
        this.suspendAxisListeners();
        try {
            selectionMap.forEach((chart, xyChartSelection) -> this.get((Chart<Double>)chart).ifPresent(y -> y.setSelection((XYChartSelection<ZonedDateTime, Double>)xyChartSelection, toHistory)));
            selectionMap.entrySet().stream().findFirst().ifPresent(entry -> {
                ZonedDateTime newStartX = this.roundDateTime((ZonedDateTime)((XYChartSelection)entry.getValue()).getStartX());
                ZonedDateTime newEndX = this.roundDateTime((ZonedDateTime)((XYChartSelection)entry.getValue()).getEndX());
                boolean dontPlotChart = newStartX.isEqual((ChronoZonedDateTime)this.startX.get()) && newEndX.isEqual((ChronoZonedDateTime)this.endX.get());
                this.startX.set((Object)newStartX);
                this.endX.set((Object)newEndX);
                selectionMap.forEach((chart, xyChartSelection) -> this.get((Chart<Double>)chart).ifPresent(y -> y.setSelection((XYChartSelection<ZonedDateTime, Double>)xyChartSelection, toHistory)));
                this.parent.invalidateAll(toHistory, dontPlotChart, false);
            });
        }
        finally {
            this.resumeAxisListeners();
        }
    }

    public AxisState put(Chart<Double> chart, AxisState xyChartViewState) {
        return this.axisStates.put(chart, xyChartViewState);
    }

    public Optional<AxisState> get(Chart<Double> chart) {
        AxisState yState = this.axisStates.get(chart);
        if (yState != null) {
            return Optional.of(yState);
        }
        logger.debug(() -> "Could not find a saved state for chart " + chart.getName());
        return Optional.empty();
    }

    private ZonedDateTime roundDateTime(ZonedDateTime zdt) {
        return ZonedDateTime.of(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), zdt.getSecond(), 0, zdt.getZone());
    }

    public class AxisState
    implements AutoCloseable {
        private final SimpleDoubleProperty startY;
        private final SimpleDoubleProperty endY;
        private final ChartViewPort<Double> chartViewPort;
        private final ChangeListener<Number> onRefreshViewportRequired;

        public AxisState(ChartViewPort<Double> chartViewPort, double startY, double endY) {
            this.chartViewPort = chartViewPort;
            this.onRefreshViewportRequired = (observable, oldValue, newValue) -> ChartViewportsState.this.parent.invalidate(chartViewPort, true, false);
            this.startY = new SimpleDoubleProperty(this.roundYValue(startY));
            this.endY = new SimpleDoubleProperty(this.roundYValue(endY));
            this.addListeners();
        }

        public void removeListeners() {
            this.startY.removeListener(this.onRefreshViewportRequired);
            this.endY.removeListener(this.onRefreshViewportRequired);
        }

        public void addListeners() {
            this.startY.addListener(this.onRefreshViewportRequired);
            this.endY.addListener(this.onRefreshViewportRequired);
        }

        public XYChartSelection<ZonedDateTime, Double> asSelection() {
            return new XYChartSelection<ZonedDateTime, Double>(ChartViewportsState.this.getStartX(), ChartViewportsState.this.getEndX(), this.startY.get(), this.endY.get(), this.chartViewPort.getDataStore().isAutoScaleYAxis());
        }

        public XYChartSelection<ZonedDateTime, Double> selectTimeRange(ZonedDateTime beginning, ZonedDateTime end) {
            return new XYChartSelection<ZonedDateTime, Double>(beginning, end, this.startY.get(), this.endY.get(), this.chartViewPort.getDataStore().isAutoScaleYAxis());
        }

        public void setSelection(XYChartSelection<ZonedDateTime, Double> selection, boolean toHistory) {
            if (toHistory) {
                double r = ((ValueAxis)this.chartViewPort.getChart().getYAxis()).getUpperBound() - ((ValueAxis)this.chartViewPort.getChart().getYAxis()).getLowerBound() - Math.abs(selection.getEndY() - selection.getStartY());
                logger.debug(() -> "Y selection - Y axis range = " + r);
                if (r > 1.0E-4) {
                    this.chartViewPort.getDataStore().setAutoScaleYAxis(false);
                }
            } else {
                this.chartViewPort.getDataStore().setAutoScaleYAxis(selection.isAutoRangeY());
            }
            this.startY.set(this.roundYValue(selection.getStartY()));
            this.endY.set(this.roundYValue(selection.getEndY()));
        }

        private double roundYValue(double y) {
            return y;
        }

        @Override
        public void close() {
            this.removeListeners();
        }
    }
}

