/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.Binjr;
import eu.fthevenet.binjr.controllers.WorksheetController;
import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.DataAdapterFactory;
import eu.fthevenet.binjr.data.adapters.DataAdapterInfo;
import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.async.AsyncTaskManager;
import eu.fthevenet.binjr.data.exceptions.CannotInitializeDataAdapterException;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.data.exceptions.NoAdapterFoundException;
import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.binjr.data.workspace.Source;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.binjr.data.workspace.Worksheet;
import eu.fthevenet.binjr.data.workspace.Workspace;
import eu.fthevenet.binjr.dialogs.DataAdapterDialog;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.dialogs.StageAppearanceManager;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import eu.fthevenet.binjr.preferences.UpdateManager;
import eu.fthevenet.util.diagnositic.DiagnosticCommand;
import eu.fthevenet.util.diagnositic.DiagnosticException;
import eu.fthevenet.util.github.GithubRelease;
import eu.fthevenet.util.javafx.controls.CommandBarPane;
import eu.fthevenet.util.javafx.controls.ContextMenuTreeViewCell;
import eu.fthevenet.util.javafx.controls.DelayedAction;
import eu.fthevenet.util.javafx.controls.EditableTab;
import eu.fthevenet.util.javafx.controls.TearableTabPane;
import eu.fthevenet.util.javafx.controls.TreeViewUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.MaskerPane;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.action.Action;

public class MainViewController
implements Initializable {
    public static final int SETTINGS_PANE_DISTANCE = 250;
    private static final Logger logger = LogManager.getLogger(MainViewController.class);
    static final DataFormat TIME_SERIES_BINDING_FORMAT = new DataFormat(new String[]{"TimeSeriesBindingFormat"});
    private static final String BINJR_FILE_PATTERN = "*.bjr";
    private static double searchBarPaneDistance = 40.0;
    private final Workspace workspace;
    private final Map<EditableTab, WorksheetController> seriesControllers = new WeakHashMap<EditableTab, WorksheetController>();
    private final Map<TitledPane, Source> sourcesAdapters = new HashMap<TitledPane, Source>();
    private final BooleanProperty searchBarVisible = new SimpleBooleanProperty(false);
    private final BooleanProperty searchBarHidden = new SimpleBooleanProperty(!this.searchBarVisible.get());
    public static final double TOOL_BUTTON_SIZE = 20.0;
    public MenuButton debugMenuButton;
    public MenuItem consoleMenuItem;
    public Menu debugLevelMenu;
    private Optional<String> associatedFile = Optional.empty();
    @FXML
    public CommandBarPane commandBar;
    @FXML
    public AnchorPane root;
    @FXML
    public Label addWorksheetLabel;
    @FXML
    public MaskerPane sourceMaskerPane;
    @FXML
    public MaskerPane worksheetMaskerPane;
    @FXML
    public AnchorPane searchBarRoot;
    @FXML
    public TextField searchField;
    @FXML
    public Button searchButton;
    @FXML
    public Button hideSearchBarButton;
    @FXML
    public ToggleButton searchCaseSensitiveToggle;
    @FXML
    public StackPane sourceArea;
    List<TreeItem<TimeSeriesBinding<Double>>> searchResultSet;
    int currentSearchHit = -1;
    @FXML
    private MenuItem refreshMenuItem;
    @FXML
    private Accordion sourcesPane;
    @FXML
    private TearableTabPane worksheetTabPane;
    @FXML
    private MenuItem saveMenuItem;
    @FXML
    private Menu openRecentMenu;
    @FXML
    private SplitPane contentView;
    @FXML
    private StackPane settingsPane;
    @FXML
    private StackPane worksheetArea;
    @FXML
    private Menu addSourceMenu;
    private double collapsedWidth = 48.0;
    private double expandedWidth = 200.0;
    private int animationDuration = 50;
    private Timeline showTimeline;
    private Timeline hideTimeline;
    private DoubleProperty commandBarWidth = new SimpleDoubleProperty(0.2);

    public MainViewController() {
        this.workspace = new Workspace();
    }

    private void worksheetAreaOnDragOver(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(TIME_SERIES_BINDING_FORMAT)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            event.consume();
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        assert (this.root != null) : "fx:id\"root\" was not injected!";
        assert (this.worksheetTabPane != null) : "fx:id\"worksheetTabPane\" was not injected!";
        assert (this.sourcesPane != null) : "fx:id\"sourceTabPane\" was not injected!";
        assert (this.saveMenuItem != null) : "fx:id\"saveMenuItem\" was not injected!";
        assert (this.openRecentMenu != null) : "fx:id\"openRecentMenu\" was not injected!";
        assert (this.contentView != null) : "fx:id\"contentView\" was not injected!";
        this.debugMenuButton.visibleProperty().bind((ObservableValue)AppEnvironment.getInstance().debugModeProperty());
        BooleanBinding selectWorksheetPresent = Bindings.size((ObservableList)this.worksheetTabPane.getTabs()).isEqualTo(0);
        BooleanBinding selectedSourcePresent = Bindings.size((ObservableList)this.sourcesPane.getPanes()).isEqualTo(0);
        this.refreshMenuItem.disableProperty().bind((ObservableValue)selectWorksheetPresent);
        this.sourcesPane.mouseTransparentProperty().bind((ObservableValue)selectedSourcePresent);
        this.sourcesPane.expandedPaneProperty().addListener((observable, oldPane, newPane) -> {
            Boolean expandRequiered = true;
            for (TitledPane pane : this.sourcesPane.getPanes()) {
                if (!pane.isExpanded()) continue;
                expandRequiered = false;
            }
            if (expandRequiered.booleanValue() && oldPane != null) {
                Platform.runLater(() -> this.sourcesPane.setExpandedPane(oldPane));
            }
        });
        this.addWorksheetLabel.visibleProperty().bind((ObservableValue)selectWorksheetPresent);
        this.worksheetTabPane.setNewTabFactory(this::worksheetTabFactory);
        this.worksheetTabPane.getGlobalTabs().addListener(this::onWorksheetTabChanged);
        this.worksheetTabPane.setTearable(true);
        this.worksheetTabPane.setOnOpenNewWindow((EventHandler<WindowEvent>)((EventHandler)event -> {
            Stage stage = (Stage)event.getSource();
            stage.setTitle("binjr");
            StageAppearanceManager.getInstance().register(stage);
        }));
        this.worksheetTabPane.setOnClosingWindow((EventHandler<WindowEvent>)((EventHandler)event -> StageAppearanceManager.getInstance().unregister((Stage)event.getSource())));
        this.sourcesPane.getPanes().addListener(this::onSourceTabChanged);
        this.saveMenuItem.disableProperty().bind((ObservableValue)this.workspace.dirtyProperty().not());
        AppEnvironment.getInstance().consoleVisibleProperty().addListener((observable, oldValue, newValue) -> this.consoleMenuItem.setText((newValue != false ? "Hide" : "Show") + " Console"));
        this.worksheetArea.setOnDragOver(this::worksheetAreaOnDragOver);
        this.worksheetArea.setOnDragDropped(this::handleDragDroppedOnWorksheetArea);
        this.commandBarWidth.addListener((observable, oldValue, newValue) -> this.doCommandBarResize(newValue.doubleValue()));
        this.searchField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.invalidateSearchResults();
                this.findNext();
            }
        });
        this.searchBarVisible.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.searchField.requestFocus();
                if (this.searchBarHidden.getValue().booleanValue()) {
                    this.slidePanel(1, Duration.millis((double)0.0));
                    this.searchBarHidden.setValue(Boolean.valueOf(false));
                }
            } else if (!this.searchBarHidden.getValue().booleanValue()) {
                this.slidePanel(-1, Duration.millis((double)0.0));
                this.searchBarHidden.setValue(Boolean.valueOf(true));
            }
        });
        this.searchCaseSensitiveToggle.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.invalidateSearchResults();
            this.findNext();
        });
        this.addSourceMenu.getItems().addAll(this.populateSourceMenu());
        Platform.runLater(this::runAfterInitialize);
    }

    public void setParameters(Application.Parameters parameters) {
        this.associatedFile = parameters.getUnnamed().stream().filter(s -> s.endsWith(".bjr")).filter(s -> Files.exists(Paths.get(s, new String[0]), new LinkOption[0])).findFirst();
    }

    protected void runAfterInitialize() {
        GlobalPreferences prefs = GlobalPreferences.getInstance();
        Stage stage = Dialogs.getStage((Node)this.root);
        stage.titleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> String.format("%s%s - binjr", this.workspace.isDirty() != false ? "*" : "", ((Path)this.workspace.pathProperty().getValue()).toString()), (Observable[])new Observable[]{this.workspace.pathProperty(), this.workspace.dirtyProperty()}));
        stage.setOnCloseRequest(event -> {
            if (!this.confirmAndClearWorkspace()) {
                event.consume();
            } else {
                Platform.exit();
            }
        });
        stage.addEventFilter(KeyEvent.KEY_PRESSED, e -> this.handleControlKey((KeyEvent)e, true));
        stage.addEventFilter(KeyEvent.KEY_RELEASED, e -> this.handleControlKey((KeyEvent)e, false));
        stage.focusedProperty().addListener((observable, oldValue, newValue) -> {
            prefs.setShiftPressed(false);
            prefs.setCtrlPressed(false);
        });
        if (this.associatedFile.isPresent()) {
            logger.debug(() -> "Opening associated file " + this.associatedFile.get());
            this.loadWorkspace(new File(this.associatedFile.get()));
        } else if (prefs.isLoadLastWorkspaceOnStartup()) {
            prefs.getMostRecentSavedWorkspace().ifPresent(path -> {
                File latestWorkspace = path.toFile();
                if (latestWorkspace.exists()) {
                    this.loadWorkspace(latestWorkspace);
                } else {
                    logger.warn("Cannot reopen workspace " + latestWorkspace.getPath() + ": file does not exists");
                }
            });
        }
        if (prefs.isCheckForUpdateOnStartUp()) {
            UpdateManager.getInstance().asyncCheckForUpdate(this::onAvailableUpdate, null, null);
        }
    }

    @FXML
    protected void handleAboutAction(ActionEvent event) throws IOException {
        Dialog dialog = new Dialog();
        dialog.initStyle(StageStyle.DECORATED);
        dialog.setTitle("About binjr");
        dialog.setDialogPane((DialogPane)FXMLLoader.load((URL)this.getClass().getResource("/views/AboutBoxView.fxml")));
        dialog.initOwner((Window)Dialogs.getStage((Node)this.root));
        dialog.showAndWait();
    }

    @FXML
    protected void handleQuitAction(ActionEvent event) {
        if (this.confirmAndClearWorkspace()) {
            Platform.exit();
        }
    }

    @FXML
    protected void handleRefreshAction(ActionEvent actionEvent) {
        if (this.getSelectedWorksheetController() != null) {
            this.getSelectedWorksheetController().refresh();
        }
    }

    @FXML
    protected void handlePreferencesAction(ActionEvent actionEvent) {
        try {
            TranslateTransition openNav = new TranslateTransition(new Duration(350.0), (Node)this.settingsPane);
            openNav.setToX(250.0);
            openNav.play();
            this.showCommandBar();
        }
        catch (Exception ex) {
            Dialogs.notifyException("Failed to display preference dialog", ex, (Node)this.root);
        }
    }

    @FXML
    public void handleExpandCommandBar(ActionEvent actionEvent) {
        if (!this.commandBar.isExpanded()) {
            this.showCommandBar();
        } else {
            this.hideCommandBar();
        }
    }

    @FXML
    protected void handleAddNewWorksheet(Event event) {
        this.editWorksheet(new Worksheet<Double>());
    }

    @FXML
    private void handleAddSource(Event event) {
        Node sourceNode = (Node)event.getSource();
        ContextMenu sourceMenu = new ContextMenu();
        sourceMenu.getItems().addAll(this.populateSourceMenu());
        sourceMenu.show(sourceNode, Side.BOTTOM, 0.0, 0.0);
    }

    @FXML
    protected void handleHelpAction(ActionEvent event) {
        try {
            Dialogs.launchUrlInExternalBrowser("https://github.com/fthevenet/binjr/wiki");
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Failed to launch url in browser: https://github.com/fthevenet/binjr/wiki");
            logger.debug("Exception stack", (Throwable)e);
        }
    }

    @FXML
    protected void handleViewOnGitHub(ActionEvent event) {
        try {
            Dialogs.launchUrlInExternalBrowser("https://github.com/fthevenet/binjr");
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Failed to launch url in browser: https://github.com/fthevenet/binjr");
            logger.debug("Exception stack", (Throwable)e);
        }
    }

    @FXML
    protected void handleBinjrWebsite(ActionEvent actionEvent) {
        try {
            Dialogs.launchUrlInExternalBrowser("http://www.binjr.eu");
        }
        catch (IOException | URISyntaxException e) {
            logger.error("Failed to launch url in browser: http://www.binjr.eu");
            logger.debug("Exception stack", (Throwable)e);
        }
    }

    @FXML
    protected void handleNewWorkspace(ActionEvent event) {
        this.confirmAndClearWorkspace();
    }

    @FXML
    protected void handleOpenWorkspace(ActionEvent event) {
        this.openWorkspaceFromFile();
    }

    @FXML
    protected void handleShowSearchBar(ActionEvent actionEvent) {
        this.searchBarVisible.setValue(Boolean.valueOf(true));
    }

    @FXML
    public void handleHidePanel(ActionEvent actionEvent) {
        this.searchBarVisible.setValue(Boolean.valueOf(false));
    }

    @FXML
    protected void handleFindNextInTreeView(ActionEvent actionEvent) {
        this.findNext();
    }

    @FXML
    protected void handleSaveWorkspace(ActionEvent event) {
        this.saveWorkspace();
    }

    @FXML
    protected void handleSaveAsWorkspace(ActionEvent event) {
        this.saveWorkspaceAs();
    }

    @FXML
    protected void handleDisplayChartProperties(ActionEvent actionEvent) {
        if (this.getSelectedWorksheetController() != null) {
            this.getSelectedWorksheetController().toggleShowPropertiesPane();
        }
    }

    @FXML
    protected void populateOpenRecentMenu(Event event) {
        Menu menu = (Menu)event.getSource();
        Collection<String> recentPath = GlobalPreferences.getInstance().getRecentFiles();
        if (!recentPath.isEmpty()) {
            menu.getItems().setAll((Collection)recentPath.stream().map(s -> {
                MenuItem m = new MenuItem(s);
                m.setMnemonicParsing(false);
                m.setOnAction(e -> this.loadWorkspace(new File(((MenuItem)e.getSource()).getText())));
                return m;
            }).collect(Collectors.toList()));
        } else {
            MenuItem none = new MenuItem("none");
            none.setDisable(true);
            menu.getItems().setAll((Object[])new MenuItem[]{none});
        }
    }

    private ButtonBase newToolBarButton(Supplier<ButtonBase> btnFactory, String text, String tooltipMsg, String[] styleClass, String[] iconStyleClass) {
        ButtonBase btn = btnFactory.get();
        btn.setText(text);
        btn.setPrefHeight(20.0);
        btn.setMaxHeight(20.0);
        btn.setMinHeight(20.0);
        btn.setPrefWidth(20.0);
        btn.setMaxWidth(20.0);
        btn.setMinWidth(20.0);
        btn.getStyleClass().addAll((Object[])styleClass);
        btn.setAlignment(Pos.CENTER);
        Region icon = new Region();
        icon.getStyleClass().addAll((Object[])iconStyleClass);
        btn.setGraphic((Node)icon);
        btn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        btn.setTooltip(new Tooltip(tooltipMsg));
        return btn;
    }

    private TitledPane newSourcePane(Source source) {
        TitledPane newPane = new TitledPane();
        Label label = new Label();
        source.getBindingManager().bind(label.textProperty(), source.nameProperty());
        GridPane titleRegion = new GridPane();
        titleRegion.setHgap(5.0);
        titleRegion.getColumnConstraints().add((Object)new ColumnConstraints(20.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
        titleRegion.getColumnConstraints().add((Object)new ColumnConstraints(20.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false));
        source.getBindingManager().bind(titleRegion.minWidthProperty(), newPane.widthProperty().subtract(30));
        source.getBindingManager().bind(titleRegion.maxWidthProperty(), newPane.widthProperty().subtract(30));
        HBox toolbar = new HBox();
        toolbar.getStyleClass().add((Object)"title-pane-tool-bar");
        toolbar.setAlignment(Pos.CENTER);
        Button closeButton = (Button)this.newToolBarButton(Button::new, "Close", "Close the connection to this source.", new String[]{"exit"}, new String[]{"cross-icon", "small-icon"});
        closeButton.setOnAction(event -> {
            if (Dialogs.confirmDialog((Node)this.root, "Are you sure you want to remove source \"" + source.getName() + "\"?", "WARNING: This will remove all associated series from existing worksheets.", ButtonType.YES, ButtonType.NO) == ButtonType.YES) {
                this.sourcesPane.getPanes().remove((Object)newPane);
            }
        });
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        GridPane.setConstraints((Node)label, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        GridPane.setConstraints((Node)toolbar, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER);
        newPane.setGraphic((Node)titleRegion);
        newPane.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        newPane.setAnimated(false);
        HBox editFieldsGroup = new HBox();
        DoubleBinding db = Bindings.createDoubleBinding(() -> editFieldsGroup.isVisible() ? -1.0 : 0.0, (Observable[])new Observable[]{editFieldsGroup.visibleProperty()});
        source.getBindingManager().bind(editFieldsGroup.prefHeightProperty(), db);
        source.getBindingManager().bind(editFieldsGroup.maxHeightProperty(), db);
        source.getBindingManager().bind(editFieldsGroup.minHeightProperty(), db);
        source.getBindingManager().bind(editFieldsGroup.visibleProperty(), source.editableProperty());
        editFieldsGroup.setSpacing(5.0);
        TextField sourceNameField = new TextField();
        sourceNameField.textProperty().bindBidirectional(source.nameProperty());
        editFieldsGroup.getChildren().add((Object)sourceNameField);
        sourceNameField.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                source.setEditable(false);
            }
        });
        HBox.setHgrow((Node)sourceNameField, (Priority)Priority.ALWAYS);
        toolbar.getChildren().addAll((Object[])new Node[]{closeButton});
        titleRegion.getChildren().addAll((Object[])new Node[]{label, editFieldsGroup, toolbar});
        titleRegion.setOnMouseClicked(event -> {
            if (event.getClickCount() == 2) {
                source.setEditable(true);
                sourceNameField.selectAll();
                sourceNameField.requestFocus();
            }
        });
        return newPane;
    }

    private Collection<MenuItem> populateSourceMenu() {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (DataAdapterInfo adapterInfo : DataAdapterFactory.getInstance().getActiveAdapters()) {
            MenuItem menuItem = new MenuItem(adapterInfo.getName());
            menuItem.setOnAction(eventHandler -> {
                try {
                    this.showAdapterDialog(DataAdapterFactory.getInstance().getDialog(adapterInfo.getKey(), (Node)this.root));
                }
                catch (NoAdapterFoundException e) {
                    Dialogs.notifyException("Could not find source adapter " + adapterInfo.getName(), e, (Node)this.root);
                }
                catch (CannotInitializeDataAdapterException e) {
                    Dialogs.notifyException("Could not initialize source adapter " + adapterInfo.getName(), e, (Node)this.root);
                }
            });
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    TreeView<TimeSeriesBinding<Double>> getSelectedTreeView() {
        if (this.sourcesPane == null || this.sourcesPane.getExpandedPane() == null) {
            return null;
        }
        return (TreeView)this.sourcesPane.getExpandedPane().getContent();
    }

    private void showCommandBar() {
        if (this.hideTimeline != null) {
            this.hideTimeline.stop();
        }
        if (this.showTimeline != null && this.showTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        Duration duration = Duration.millis((double)this.animationDuration);
        KeyFrame keyFrame = new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.commandBarWidth, (Object)this.expandedWidth)});
        this.showTimeline = new Timeline(new KeyFrame[]{keyFrame});
        this.showTimeline.setOnFinished(event -> new DelayedAction(() -> AnchorPane.setLeftAnchor((Node)this.contentView, (Double)this.expandedWidth), Duration.millis((double)50.0)).submit());
        this.showTimeline.play();
        this.commandBar.setExpanded(true);
    }

    private void hideCommandBar() {
        if (this.showTimeline != null) {
            this.showTimeline.stop();
        }
        if (this.hideTimeline != null && this.hideTimeline.getStatus() == Animation.Status.RUNNING) {
            return;
        }
        if (this.commandBarWidth.get() <= this.collapsedWidth) {
            return;
        }
        Duration duration = Duration.millis((double)this.animationDuration);
        this.hideTimeline = new Timeline(new KeyFrame[]{new KeyFrame(duration, new KeyValue[]{new KeyValue((WritableValue)this.commandBarWidth, (Object)this.collapsedWidth)})});
        AnchorPane.setLeftAnchor((Node)this.contentView, (Double)this.collapsedWidth);
        this.hideTimeline.play();
        this.commandBar.setExpanded(false);
    }

    private void slidePanel(int show, Duration delay) {
        TranslateTransition openNav = new TranslateTransition(new Duration(200.0), (Node)this.searchBarRoot);
        openNav.setDelay(delay);
        openNav.setToY((double)show * -searchBarPaneDistance);
        openNav.play();
        openNav.setOnFinished(event -> AnchorPane.setBottomAnchor((Node)this.sourceArea, (Double)(show > 0 ? searchBarPaneDistance : 0.0)));
    }

    private void doCommandBarResize(double v) {
        this.commandBar.setMinWidth(v);
    }

    private void expandBranch(TreeItem<TimeSeriesBinding<Double>> branch) {
        if (branch == null) {
            return;
        }
        branch.setExpanded(true);
        if (branch.getChildren() != null) {
            for (TreeItem item : branch.getChildren()) {
                this.expandBranch((TreeItem<TimeSeriesBinding<Double>>)item);
            }
        }
    }

    private boolean confirmAndClearWorkspace() {
        if (!this.workspace.isDirty().booleanValue()) {
            this.clearWorkspace();
            return true;
        }
        Dialogs.getStage((Node)this.root).setIconified(false);
        ButtonType res = Dialogs.confirmSaveDialog((Node)this.root, this.workspace.hasPath() ? this.workspace.getPath().getFileName().toString() : "Untitled");
        if (res == ButtonType.CANCEL) {
            return false;
        }
        if (res == ButtonType.YES && !this.saveWorkspace()) {
            return false;
        }
        this.clearWorkspace();
        return true;
    }

    private void clearWorkspace() {
        logger.debug(() -> "Clearing workspace");
        this.worksheetTabPane.clearAllTabs();
        this.sourcesPane.getPanes().clear();
        this.seriesControllers.clear();
        this.sourcesAdapters.values().forEach(source -> {
            try {
                source.close();
            }
            catch (Exception e) {
                Dialogs.notifyException("Error closing Source", e, (Node)this.root);
            }
        });
        this.sourcesAdapters.clear();
        this.workspace.clear();
    }

    private void openWorkspaceFromFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Workspace");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("binjr workspaces", new String[]{BINJR_FILE_PATTERN}));
        fileChooser.setInitialDirectory(GlobalPreferences.getInstance().getMostRecentSaveFolder().toFile());
        File selectedFile = fileChooser.showOpenDialog((Window)Dialogs.getStage((Node)this.root));
        if (selectedFile != null) {
            this.loadWorkspace(selectedFile);
        }
    }

    private void loadWorkspace(File file) {
        if (this.confirmAndClearWorkspace()) {
            this.sourceMaskerPane.setVisible(true);
            AsyncTaskManager.getInstance().submit(() -> {
                Workspace wsFromfile = Workspace.from(file);
                for (Source source : wsFromfile.getSources()) {
                    DataAdapter<?, ?> da = DataAdapterFactory.getInstance().newAdapter(source.getAdapterClassName());
                    da.loadParams(source.getAdapterParams());
                    da.setId(source.getAdapterId());
                    source.setAdapter(da);
                    this.loadSource(source);
                }
                return wsFromfile;
            }, (EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                this.workspace.setPath(file.toPath());
                this.sourceMaskerPane.setVisible(false);
                this.loadWorksheets((Workspace)event.getSource().getValue());
            }), (EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                this.sourceMaskerPane.setVisible(false);
                Dialogs.notifyException("An error occurred while loading workspace from file " + (file != null ? file.getName() : "null"), event.getSource().getException(), (Node)this.root);
            }));
        }
    }

    private void loadWorksheets(Workspace wsFromfile) {
        try {
            for (Worksheet worksheet : wsFromfile.getWorksheets()) {
                this.loadWorksheet(worksheet);
            }
            this.workspace.cleanUp();
            GlobalPreferences.getInstance().putToRecentFiles(this.workspace.getPath().toString());
            logger.debug(() -> "Recently loaded workspaces: " + GlobalPreferences.getInstance().getRecentFiles().stream().collect(Collectors.joining(" ")));
        }
        catch (Exception e) {
            Dialogs.notifyException("Error loading workspace", e, (Node)this.root);
        }
    }

    private boolean saveWorkspace() {
        try {
            if (this.workspace.hasPath()) {
                this.workspace.save();
                return true;
            }
            return this.saveWorkspaceAs();
        }
        catch (IOException e) {
            Dialogs.notifyException("Failed to save snapshot to disk", e, (Node)this.root);
        }
        catch (JAXBException e) {
            Dialogs.notifyException("Error while serializing workspace", e, (Node)this.root);
        }
        return false;
    }

    private boolean saveWorkspaceAs() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save Workspace");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("binjr workspaces", new String[]{BINJR_FILE_PATTERN}));
        fileChooser.setInitialDirectory(GlobalPreferences.getInstance().getMostRecentSaveFolder().toFile());
        fileChooser.setInitialFileName(BINJR_FILE_PATTERN);
        File selectedFile = fileChooser.showSaveDialog((Window)Dialogs.getStage((Node)this.root));
        if (selectedFile != null) {
            try {
                this.workspace.save(selectedFile);
                GlobalPreferences.getInstance().putToRecentFiles(this.workspace.getPath().toString());
                return true;
            }
            catch (IOException e) {
                Dialogs.notifyException("Failed to save snapshot to disk", e, (Node)this.root);
            }
            catch (JAXBException e) {
                Dialogs.notifyException("Error while serializing workspace", e, (Node)this.root);
            }
        }
        return false;
    }

    private void showAdapterDialog(DataAdapterDialog dlg) {
        dlg.showAndWait().ifPresent(da -> {
            Source newSource = Source.of(da);
            TitledPane newSourcePane = this.newSourcePane(newSource);
            this.sourceMaskerPane.setVisible(true);
            AsyncTaskManager.getInstance().submit(() -> this.buildTreeViewForTarget((DataAdapter)da), (EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                this.sourceMaskerPane.setVisible(false);
                Optional treeView = (Optional)event.getSource().getValue();
                if (treeView.isPresent()) {
                    newSourcePane.setContent((Node)treeView.get());
                    this.sourcesAdapters.put(newSourcePane, newSource);
                    this.sourcesPane.getPanes().add((Object)newSourcePane);
                    newSourcePane.setExpanded(true);
                }
            }), (EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                this.sourceMaskerPane.setVisible(false);
                Dialogs.notifyException("Unexpected error getting data adapter:", event.getSource().getException(), (Node)this.root);
            }));
        });
    }

    private void loadSource(Source source) throws DataAdapterException {
        TitledPane newSourcePane = this.newSourcePane(source);
        Optional<TreeView<TimeSeriesBinding<Double>>> treeView = this.buildTreeViewForTarget(source.getAdapter());
        if (treeView.isPresent()) {
            newSourcePane.setContent((Node)treeView.get());
            this.sourcesAdapters.put(newSourcePane, source);
        } else {
            TreeItem i = new TreeItem();
            i.setValue(new TimeSeriesBinding());
            Label l = new Label("<Failed to connect to \"" + source.getName() + "\">");
            l.setTextFill((Paint)Color.RED);
            i.setGraphic((Node)l);
            newSourcePane.setContent((Node)new TreeView(i));
        }
        Platform.runLater(() -> {
            this.sourcesPane.getPanes().add((Object)newSourcePane);
            newSourcePane.setExpanded(true);
        });
    }

    private boolean loadWorksheet(Worksheet<Double> worksheet) {
        EditableTab newTab = new EditableTab("New worksheet");
        this.loadWorksheet(worksheet, newTab, false);
        this.worksheetTabPane.getTabs().add((Object)newTab);
        this.worksheetTabPane.getSelectionModel().select((Object)newTab);
        return false;
    }

    private void reloadController(WorksheetController worksheetCtrl) {
        if (worksheetCtrl == null) {
            throw new IllegalArgumentException("Provided Worksheet controller cannot be null");
        }
        EditableTab tab = null;
        for (Map.Entry<EditableTab, WorksheetController> entry : this.seriesControllers.entrySet()) {
            if (!entry.getValue().equals(worksheetCtrl)) continue;
            tab = entry.getKey();
        }
        if (tab == null) {
            throw new IllegalStateException("cannot find associated tab or WorksheetController for " + worksheetCtrl.getName());
        }
        Worksheet<Double> worksheet = worksheetCtrl.getWorksheet();
        worksheetCtrl.close();
        this.loadWorksheet(worksheet, tab, false);
    }

    private void loadWorksheet(Worksheet<Double> worksheet, EditableTab newTab, boolean setToEditMode) {
        try {
            WorksheetController current = new WorksheetController(this, worksheet, this.sourcesAdapters.values().stream().map(Source::getAdapter).collect(Collectors.toList()));
            try {
                current.setReloadRequiredHandler(this::reloadController);
                FXMLLoader fXMLLoader = new FXMLLoader(this.getClass().getResource("/views/WorksheetView.fxml"));
                fXMLLoader.setController((Object)current);
                Parent p = (Parent)fXMLLoader.load();
                newTab.setContent((Node)p);
                p.setOnDragOver(this::handleDragOverWorksheetView);
                p.setOnDragDropped(this::handleDragDroppedOnWorksheetView);
            }
            catch (IOException ex) {
                logger.error("Error loading time series", (Throwable)ex);
            }
            this.seriesControllers.put(newTab, current);
            newTab.nameProperty().bindBidirectional(worksheet.nameProperty());
            if (setToEditMode) {
                logger.trace("Toggle edit mode for worksheet");
                current.setShowPropertiesPane(true);
            }
        }
        catch (Exception e) {
            Dialogs.notifyException("Error loading worksheet into new tab", e, (Node)this.root);
        }
    }

    private boolean editWorksheet(Worksheet<Double> worksheet) {
        TabPane targetTabPane = this.worksheetTabPane.getSelectedTabPane();
        EditableTab newTab = new EditableTab("");
        this.loadWorksheet(worksheet, newTab, true);
        targetTabPane.getTabs().add((Object)newTab);
        targetTabPane.getSelectionModel().select((Object)newTab);
        return true;
    }

    private Optional<TreeView<TimeSeriesBinding<Double>>> buildTreeViewForTarget(DataAdapter dp) {
        TreeView treeView = new TreeView();
        treeView.setShowRoot(false);
        Callback dragAndDropCellFactory = param -> {
            TreeCell cell = new TreeCell();
            cell.itemProperty().addListener((observable, oldValue, newValue) -> cell.setText(newValue == null ? null : newValue.toString()));
            cell.setOnDragDetected(event -> {
                if (cell.getItem() != null) {
                    this.expandBranch((TreeItem<TimeSeriesBinding<Double>>)cell.getTreeItem());
                    Dragboard db = cell.startDragAndDrop(TransferMode.COPY_OR_MOVE);
                    db.setDragView((Image)cell.snapshot(null, null));
                    ClipboardContent content = new ClipboardContent();
                    content.put((Object)TIME_SERIES_BINDING_FORMAT, (Object)((TimeSeriesBinding)cell.getItem()).getTreeHierarchy());
                    db.setContent((Map)content);
                } else {
                    logger.debug("No TreeItem selected: canceling drag and drop");
                }
                event.consume();
            });
            return cell;
        };
        treeView.setCellFactory(ContextMenuTreeViewCell.forTreeView(this.getTreeViewContextMenu((TreeView<TimeSeriesBinding<Double>>)treeView), dragAndDropCellFactory));
        try {
            dp.onStart();
            TreeItem bindingTree = dp.getBindingTree();
            bindingTree.setExpanded(true);
            treeView.setRoot(bindingTree);
            return Optional.of(treeView);
        }
        catch (DataAdapterException e) {
            Dialogs.notifyException("An error occurred while getting data from source " + dp.getSourceName(), e, (Node)this.root);
            return Optional.empty();
        }
    }

    <T> void getAllBindingsFromBranch(TreeItem<T> branch, List<T> bindings) {
        if (branch.getChildren().size() > 0) {
            for (TreeItem t : branch.getChildren()) {
                this.getAllBindingsFromBranch(t, bindings);
            }
        } else {
            bindings.add(branch.getValue());
        }
    }

    private void handleControlKey(KeyEvent event, boolean pressed) {
        switch (event.getCode()) {
            case SHIFT: {
                GlobalPreferences.getInstance().setShiftPressed(pressed);
                event.consume();
                break;
            }
            case CONTROL: 
            case META: 
            case SHORTCUT: {
                GlobalPreferences.getInstance().setCtrlPressed(pressed);
                event.consume();
                break;
            }
        }
    }

    private ContextMenu getChartListContextMenu(TreeView<TimeSeriesBinding<Double>> treeView) {
        ContextMenu contextMenu = new ContextMenu((MenuItem[])this.getSelectedWorksheetController().getWorksheet().getCharts().stream().map(c -> {
            MenuItem m = new MenuItem(c.getName());
            m.setOnAction(e -> this.addToCurrentWorksheet((TreeItem<TimeSeriesBinding<Double>>)((TreeItem)treeView.getSelectionModel().getSelectedItem()), (Chart<Double>)c));
            return m;
        }).toArray(MenuItem[]::new));
        MenuItem newChart = new MenuItem("Add to new chart");
        newChart.setOnAction(event -> this.addToNewChartInCurrentWorksheet((TreeItem<TimeSeriesBinding<Double>>)((TreeItem)treeView.getSelectionModel().getSelectedItem())));
        contextMenu.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), newChart});
        return contextMenu;
    }

    private ContextMenu getTreeViewContextMenu(TreeView<TimeSeriesBinding<Double>> treeView) {
        Menu addToCurrent = new Menu("Add to current worksheet", null, new MenuItem[]{new MenuItem("none")});
        addToCurrent.disableProperty().bind((ObservableValue)Bindings.size((ObservableList)this.worksheetTabPane.getTabs()).lessThanOrEqualTo(0));
        addToCurrent.setOnShowing(event -> addToCurrent.getItems().setAll((Collection)this.getChartListContextMenu(treeView).getItems()));
        MenuItem addToNew = new MenuItem("Add to new worksheet");
        addToNew.setOnAction(event -> this.addToNewWorksheet((TreeItem<TimeSeriesBinding<Double>>)((TreeItem)treeView.getSelectionModel().getSelectedItem())));
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{addToCurrent, addToNew});
        contextMenu.setOnShowing(event -> this.expandBranch((TreeItem<TimeSeriesBinding<Double>>)((TreeItem)treeView.getSelectionModel().getSelectedItem())));
        return contextMenu;
    }

    private void addToNewChartInCurrentWorksheet(TreeItem<TimeSeriesBinding<Double>> treeItem) {
        try {
            Worksheet<Double> worksheet = this.getSelectedWorksheetController().getWorksheet();
            TimeSeriesBinding binding = (TimeSeriesBinding)treeItem.getValue();
            Chart chart = new Chart(binding.getLegend(), binding.getGraphType(), binding.getUnitName(), binding.getUnitPrefix());
            ArrayList bindings = new ArrayList();
            this.getAllBindingsFromBranch(treeItem, bindings);
            for (TimeSeriesBinding b : bindings) {
                chart.addSeries(TimeSeriesInfo.fromBinding(b));
            }
            worksheet.getCharts().add(chart);
        }
        catch (Exception e) {
            Dialogs.notifyException("Error adding bindings to new chart", e, (Node)this.root);
        }
    }

    private void addToCurrentWorksheet(TreeItem<TimeSeriesBinding<Double>> treeItem, Chart<Double> targetChart) {
        try {
            if (this.getSelectedWorksheetController() != null && treeItem != null) {
                ArrayList<TimeSeriesBinding<Double>> bindings = new ArrayList<TimeSeriesBinding<Double>>();
                this.getAllBindingsFromBranch(treeItem, bindings);
                this.getSelectedWorksheetController().addBindings(bindings, targetChart);
            }
        }
        catch (Exception e) {
            Dialogs.notifyException("Error adding bindings to existing worksheet", e, (Node)this.root);
        }
    }

    private void addToNewWorksheet(TreeItem<TimeSeriesBinding<Double>> treeItem) {
        Platform.runLater(() -> {
            try {
                ZoneId zoneId;
                ZonedDateTime fromDateTime;
                ZonedDateTime toDateTime;
                TimeSeriesBinding binding = (TimeSeriesBinding)treeItem.getValue();
                if (this.getSelectedWorksheetController() != null && this.getSelectedWorksheetController().getWorksheet() != null) {
                    toDateTime = this.getSelectedWorksheetController().getWorksheet().getToDateTime();
                    fromDateTime = this.getSelectedWorksheetController().getWorksheet().getFromDateTime();
                    zoneId = this.getSelectedWorksheetController().getWorksheet().getTimeZone();
                } else {
                    toDateTime = ZonedDateTime.now();
                    fromDateTime = toDateTime.minus(24L, ChronoUnit.HOURS);
                    zoneId = ZoneId.systemDefault();
                }
                ArrayList chartList = new ArrayList();
                chartList.add(new Chart(binding.getLegend(), binding.getGraphType(), binding.getUnitName(), binding.getUnitPrefix()));
                Worksheet<Double> worksheet = new Worksheet<Double>(binding.getLegend(), chartList, zoneId, fromDateTime, toDateTime);
                if (this.editWorksheet(worksheet) && this.getSelectedWorksheetController() != null) {
                    ArrayList<TimeSeriesBinding<Double>> bindings = new ArrayList<TimeSeriesBinding<Double>>();
                    this.getAllBindingsFromBranch(treeItem, bindings);
                    this.getSelectedWorksheetController().addBindings(bindings, this.getSelectedWorksheetController().getWorksheet().getDefaultChart());
                }
            }
            catch (Exception e) {
                Dialogs.notifyException("Error adding bindings to new worksheet", e, (Node)this.root);
            }
        });
    }

    private void findNext() {
        if (this.isNullOrEmpty(this.searchField.getText())) {
            return;
        }
        TreeView<TimeSeriesBinding<Double>> selectedTreeView = this.getSelectedTreeView();
        if (selectedTreeView == null) {
            return;
        }
        if (this.searchResultSet == null) {
            this.searchResultSet = TreeViewUtils.findAllInTree(selectedTreeView.getRoot(), i -> {
                if (i.getValue() == null || ((TimeSeriesBinding)i.getValue()).getLegend() == null) {
                    return false;
                }
                if (this.searchCaseSensitiveToggle.isSelected()) {
                    return ((TimeSeriesBinding)i.getValue()).getLegend().contains(this.searchField.getText());
                }
                return ((TimeSeriesBinding)i.getValue()).getLegend().toLowerCase().contains(this.searchField.getText().toLowerCase());
            });
        }
        if (!this.searchResultSet.isEmpty()) {
            this.searchField.setStyle("");
            ++this.currentSearchHit;
            if (this.currentSearchHit > this.searchResultSet.size() - 1) {
                this.currentSearchHit = 0;
            }
            selectedTreeView.getSelectionModel().select(this.searchResultSet.get(this.currentSearchHit));
            selectedTreeView.scrollTo(selectedTreeView.getRow(this.searchResultSet.get(this.currentSearchHit)));
        } else {
            this.searchField.setStyle("-fx-background-color: #ffcccc;");
        }
        logger.trace(() -> "Search for " + this.searchField.getText() + " yielded " + this.searchResultSet.size() + " match(es)");
    }

    private void invalidateSearchResults() {
        logger.trace("Invalidating search result");
        this.searchField.setStyle("");
        this.searchResultSet = null;
        this.currentSearchHit = -1;
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private void onWorksheetTabChanged(ListChangeListener.Change<? extends Tab> c) {
        while (c.next()) {
            if (c.wasAdded()) {
                this.workspace.addWorksheets(c.getAddedSubList().stream().map(t -> this.seriesControllers.get(t).getWorksheet()).collect(Collectors.toList()));
            }
            if (!c.wasRemoved()) continue;
            c.getRemoved().forEach(t -> {
                WorksheetController ctlr = this.seriesControllers.get(t);
                if (ctlr != null) {
                    this.workspace.removeWorksheets(ctlr.getWorksheet());
                    this.seriesControllers.remove(t);
                    ctlr.close();
                } else {
                    logger.warn("Could not find a controller assigned to tab " + t.getText());
                }
            });
        }
        logger.debug(() -> "Worksheets in current workspace: " + StreamSupport.stream(this.workspace.getWorksheets().spliterator(), false).map(Worksheet::getName).reduce((s, s2) -> s + " " + s2).orElse("null"));
    }

    private void onSourceTabChanged(ListChangeListener.Change<? extends TitledPane> c) {
        AtomicBoolean removed = new AtomicBoolean(false);
        while (c.next()) {
            c.getAddedSubList().forEach(t -> this.workspace.addSource(this.sourcesAdapters.get(t)));
            c.getRemoved().forEach(t -> {
                removed.set(true);
                try {
                    Source removedSource = this.sourcesAdapters.remove(t);
                    if (removedSource != null) {
                        this.workspace.removeSource(removedSource);
                        logger.debug("Closing Source " + removedSource.getName());
                        removedSource.close();
                    } else {
                        logger.trace("No Source to close attached to tab " + t.getText());
                    }
                }
                catch (Exception e) {
                    Dialogs.notifyException("On error occurred while closing Source", e);
                }
            });
        }
        if (removed.get()) {
            this.refreshAllWorksheets();
        }
        logger.debug(() -> "Sources in current workspace: " + StreamSupport.stream(this.workspace.getSources().spliterator(), false).map(Source::getName).reduce((s, s2) -> s + " " + s2).orElse("null"));
    }

    private Optional<Tab> worksheetTabFactory(ActionEvent event) {
        EditableTab newTab = new EditableTab("");
        this.loadWorksheet(new Worksheet<Double>(), newTab, true);
        return Optional.of(newTab);
    }

    private void handleDragDroppedOnWorksheetArea(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(TIME_SERIES_BINDING_FORMAT)) {
            TreeView<TimeSeriesBinding<Double>> treeView = this.getSelectedTreeView();
            if (treeView != null) {
                TreeItem item = (TreeItem)treeView.getSelectionModel().getSelectedItem();
                if (item != null) {
                    this.addToNewWorksheet((TreeItem<TimeSeriesBinding<Double>>)item);
                } else {
                    logger.warn("Cannot complete drag and drop operation: selected TreeItem is null");
                }
            } else {
                logger.warn("Cannot complete drag and drop operation: selected TreeView is null");
            }
            event.consume();
        }
    }

    private void onAvailableUpdate(GithubRelease githubRelease) {
        Notifications n = Notifications.create().title("New release available!").text("You are currently running binjr version " + AppEnvironment.getInstance().getVersion() + "\t\t.\nVersion " + githubRelease.getVersion() + " is now available.").hideAfter(Duration.seconds((double)20.0)).position(Pos.BOTTOM_RIGHT).owner((Object)this.root);
        n.action(new Action[]{new Action("Download", actionEvent -> {
            String newReleaseUrl = githubRelease.getHtmlUrl();
            if (newReleaseUrl != null && newReleaseUrl.trim().length() > 0) {
                try {
                    Dialogs.launchUrlInExternalBrowser(newReleaseUrl);
                }
                catch (IOException | URISyntaxException e) {
                    logger.error("Failed to launch url in browser " + newReleaseUrl, (Throwable)e);
                }
            }
            n.hideAfter(Duration.seconds((double)0.0));
        })});
        n.showInformation();
    }

    private void handleDragOverWorksheetView(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(TIME_SERIES_BINDING_FORMAT)) {
            event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
            event.consume();
        }
    }

    private void handleDragDroppedOnWorksheetView(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(TIME_SERIES_BINDING_FORMAT)) {
            TreeView<TimeSeriesBinding<Double>> treeView = this.getSelectedTreeView();
            if (treeView != null) {
                TreeItem item = (TreeItem)treeView.getSelectionModel().getSelectedItem();
                if (item != null) {
                    Stage targetStage = (Stage)((Node)event.getSource()).getScene().getWindow();
                    if (targetStage != null) {
                        targetStage.requestFocus();
                    }
                    if (TransferMode.COPY.equals((Object)event.getAcceptedTransferMode())) {
                        this.addToNewChartInCurrentWorksheet((TreeItem<TimeSeriesBinding<Double>>)item);
                    } else if (TransferMode.MOVE.equals((Object)event.getAcceptedTransferMode())) {
                        if (this.getSelectedWorksheetController().getWorksheet().getCharts().size() > 1) {
                            this.getChartListContextMenu(treeView).show((Node)event.getTarget(), event.getScreenX(), event.getSceneY());
                        } else {
                            this.addToCurrentWorksheet((TreeItem<TimeSeriesBinding<Double>>)((TreeItem)treeView.getSelectionModel().getSelectedItem()), this.getSelectedWorksheetController().getWorksheet().getDefaultChart());
                        }
                    } else {
                        logger.warn("Unsupported drag and drop transfer mode: " + event.getAcceptedTransferMode());
                    }
                } else {
                    logger.warn("Cannot complete drag and drop operation: selected TreeItem is null");
                }
            } else {
                logger.warn("Cannot complete drag and drop operation: selected TreeView is null");
            }
            event.consume();
        }
    }

    public WorksheetController getSelectedWorksheetController() {
        Tab selectedTab = this.worksheetTabPane.getSelectedTab();
        if (selectedTab == null) {
            return null;
        }
        return this.seriesControllers.get(selectedTab);
    }

    public void refreshAllWorksheets() {
        this.seriesControllers.values().forEach(WorksheetController::refresh);
    }

    public void handleDebugForceGC(ActionEvent actionEvent) {
        Binjr.runtimeDebuggingFeatures.debug(() -> "Force GC");
        System.gc();
        Binjr.runtimeDebuggingFeatures.debug(this::getJvmHeapStats);
    }

    public void handleDebugRunFinalization(ActionEvent actionEvent) {
        Binjr.runtimeDebuggingFeatures.debug(() -> "Force runFinalization");
        System.runFinalization();
    }

    public void handleDebugDumpHeapStats(ActionEvent actionEvent) {
        Binjr.runtimeDebuggingFeatures.debug(this::getJvmHeapStats);
    }

    public void handleDebugDumpThreadsStacks(ActionEvent actionEvent) {
        try {
            Binjr.runtimeDebuggingFeatures.debug(DiagnosticCommand.dumpThreadStacks());
        }
        catch (DiagnosticException e) {
            Dialogs.notifyException("Error running diagnostic command", e, (Node)this.root);
        }
    }

    public void handleDebugDumpVmSystemProperties(ActionEvent actionEvent) {
        try {
            Binjr.runtimeDebuggingFeatures.debug(DiagnosticCommand.dumpVmSystemProperties());
        }
        catch (DiagnosticException e) {
            Dialogs.notifyException("Error running diagnostic command", e, (Node)this.root);
        }
    }

    public void handleDebugDumpClassHistogram(ActionEvent actionEvent) {
        try {
            Binjr.runtimeDebuggingFeatures.debug(DiagnosticCommand.dumpClassHistogram());
        }
        catch (DiagnosticException e) {
            Dialogs.notifyException("Error running diagnostic command", e, (Node)this.root);
        }
    }

    private String getJvmHeapStats() {
        Runtime rt = Runtime.getRuntime();
        double maxMB = (double)rt.maxMemory() / 1024.0 / 1024.0;
        double committedMB = (double)rt.totalMemory() / 1024.0 / 1024.0;
        double usedMB = ((double)rt.totalMemory() - (double)rt.freeMemory()) / 1024.0 / 1024.0;
        double percentCommitted = ((double)rt.totalMemory() - (double)rt.freeMemory()) / (double)rt.totalMemory() * 100.0;
        double percentMax = ((double)rt.totalMemory() - (double)rt.freeMemory()) / (double)rt.maxMemory() * 100.0;
        return String.format("JVM Heap: Max=%.0fMB, Committed=%.0fMB, Used=%.0fMB (%.2f%% of committed, %.2f%% of max)", maxMB, committedMB, usedMB, percentCommitted, percentMax);
    }

    public void handleDebugDumpVmFlags(ActionEvent actionEvent) {
        try {
            Binjr.runtimeDebuggingFeatures.debug(DiagnosticCommand.dumpVmFlags());
        }
        catch (DiagnosticException e) {
            Dialogs.notifyException("Error running diagnostic command", e, (Node)this.root);
        }
    }

    public void handleDebugDumpVmCommandLine(ActionEvent actionEvent) {
        try {
            Binjr.runtimeDebuggingFeatures.debug(DiagnosticCommand.dumpVmCommandLine());
        }
        catch (DiagnosticException e) {
            Dialogs.notifyException("Error running diagnostic command", e, (Node)this.root);
        }
    }

    public void toggleDebugMode(ActionEvent actionEvent) {
        AppEnvironment.getInstance().setDebugMode(!AppEnvironment.getInstance().isDebugMode());
        if (AppEnvironment.getInstance().isDebugMode()) {
            logger.warn("Entering debug mode");
        }
    }

    public void toggleConsoleVisibility(ActionEvent actionEvent) {
        AppEnvironment.getInstance().setConsoleVisible(!AppEnvironment.getInstance().isConsoleVisible());
    }
}

