/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import eu.fthevenet.util.function.CheckedLambdas;
import eu.fthevenet.util.logging.TextFlowAppender;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class OutputConsoleController
implements Initializable {
    private static final Logger logger = LogManager.getLogger(OutputConsoleController.class);
    @FXML
    private TextFlow textOutput;
    @FXML
    private ScrollPane scrollPane;
    @FXML
    private ChoiceBox<Level> logLevelChoice;
    @FXML
    private ToggleButton alwaysOnTopToggle;

    public void initialize(URL location, ResourceBundle resources) {
        this.textOutput.getChildren().addListener(change -> {
            this.textOutput.layout();
            this.scrollPane.layout();
            this.scrollPane.setVvalue(1.0);
        });
        this.initTextFlowAppender();
        Platform.runLater(() -> {
            this.logLevelChoice.getItems().setAll((Object[])Level.values());
            this.logLevelChoice.getSelectionModel().select((Object)AppEnvironment.getInstance().getLogLevel());
            AppEnvironment.getInstance().logLevelProperty().addListener((observable, oldValue, newValue) -> this.logLevelChoice.getSelectionModel().select(newValue));
            this.logLevelChoice.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> AppEnvironment.getInstance().setLogLevel((Level)newValue));
        });
    }

    private synchronized void initTextFlowAppender() {
        LoggerContext lc = (LoggerContext)LogManager.getContext((boolean)false);
        TextFlowAppender appender = TextFlowAppender.createAppender("InternalConsole", (Layout<? extends Serializable>)PatternLayout.newBuilder().withPattern("[%d{YYYY-MM-dd HH:mm:ss.SSS}] [%-5level] [%t] [%logger{36}] %msg%n").build(), null);
        TextFlowAppender.setTextFlow(this.textOutput);
        appender.start();
        lc.getConfiguration().addAppender((Appender)appender);
        lc.getRootLogger().addAppender(lc.getConfiguration().getAppender(appender.getName()));
        lc.updateLoggers();
    }

    public void handleClearConsole(ActionEvent actionEvent) {
        this.textOutput.getChildren().clear();
    }

    public void handleSaveConsoleOutput(ActionEvent actionEvent) {
        block16: {
            try {
                FileChooser fileChooser = new FileChooser();
                fileChooser.setTitle("Save console ouptut");
                fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Text file", new String[]{"*.txt"}));
                fileChooser.setInitialDirectory(GlobalPreferences.getInstance().getMostRecentSaveFolder().toFile());
                fileChooser.setInitialFileName("binjr_console_output.txt");
                File selectedFile = fileChooser.showSaveDialog((Window)Dialogs.getStage((Node)this.scrollPane));
                if (selectedFile == null) break block16;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(selectedFile));){
                    this.textOutput.getChildren().stream().map(node -> ((Text)node).getText()).forEach(CheckedLambdas.wrap(writer::write));
                }
                catch (IOException e) {
                    Dialogs.notifyException("Error writing log message to file", e, (Node)this.scrollPane);
                }
                GlobalPreferences.getInstance().setMostRecentSaveFolder(selectedFile.toPath());
            }
            catch (Exception e) {
                Dialogs.notifyException("Failed to save console output to file", e, (Node)this.scrollPane);
            }
        }
    }

    public void handleCopyConsoleOutput(ActionEvent actionEvent) {
        try {
            ClipboardContent content = new ClipboardContent();
            content.putString(this.textOutput.getChildren().stream().map(node -> ((Text)node).getText()).collect(Collectors.joining()));
            Clipboard.getSystemClipboard().setContent((Map)content);
        }
        catch (Exception e) {
            Dialogs.notifyException("Failed to copy console output to clipboard", e, (Node)this.scrollPane);
        }
    }

    public ToggleButton getAlwaysOnTopToggle() {
        return this.alwaysOnTopToggle;
    }
}

