/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.data.adapters.DataAdapterFactory;
import eu.fthevenet.binjr.data.adapters.DataAdapterInfo;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.dialogs.UserInterfaceThemes;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import eu.fthevenet.binjr.preferences.NotificationDurationChoices;
import eu.fthevenet.binjr.preferences.UpdateManager;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.BackingStoreException;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.TextFlow;
import javafx.stage.DirectoryChooser;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.ToggleSwitch;

public class PreferenceDialogController
implements Initializable {
    private static final Logger logger = LogManager.getLogger(PreferenceDialogController.class);
    @FXML
    public TextField downSamplingThreshold;
    public TextField pluginLocTextfield;
    public Button browsePluginLocButton;
    public TableView<DataAdapterInfo> availableAdapterTable;
    public TableColumn enabledColumn;
    public ChoiceBox<NotificationDurationChoices> notifcationDurationChoiceBox;
    @FXML
    private ToggleSwitch loadExternalToggle;
    @FXML
    private ToggleSwitch enableDownSampling;
    @FXML
    private Label maxSampleLabel;
    @FXML
    private Accordion accordionPane;
    @FXML
    private ToggleSwitch loadAtStartupCheckbox;
    @FXML
    private ChoiceBox<UserInterfaceThemes> uiThemeChoiceBox;
    @FXML
    private TextFlow updateFlow;
    @FXML
    private ToggleSwitch updateCheckBox;
    @FXML
    private ToggleSwitch showOutline;
    @FXML
    private AnchorPane root;
    @FXML
    private Slider graphOpacitySlider = new Slider();
    @FXML
    private Label opacityText = new Label();

    public void initialize(URL location, ResourceBundle resources) {
        assert (this.downSamplingThreshold != null) : "fx:id\"RDPEpsilon\" was not injected!";
        assert (this.enableDownSampling != null) : "fx:id\"enableDownSampling\" was not injected!";
        assert (this.maxSampleLabel != null) : "fx:id\"maxSampleLabel\" was not injected!";
        assert (this.accordionPane != null) : "fx:id\"accordionPane\" was not injected!";
        assert (this.loadAtStartupCheckbox != null) : "fx:id\"loadAtStartupCheckbox\" was not injected!";
        assert (this.uiThemeChoiceBox != null) : "fx:id\"uiThemeChoiceBox\" was not injected!";
        assert (this.updateFlow != null) : "fx:id\"updateFlow\" was not injected!";
        assert (this.updateCheckBox != null) : "fx:id\"updateCheckBox\" was not injected!";
        assert (this.showOutline != null) : "fx:id\"showOutline\" was not injected!";
        assert (this.graphOpacitySlider != null) : "fx:id\"graphOpacitySlider\" was not injected!";
        GlobalPreferences prefs = GlobalPreferences.getInstance();
        this.graphOpacitySlider.valueProperty().bindBidirectional((Property)prefs.defaultGraphOpacityProperty());
        this.opacityText.textProperty().bind((ObservableValue)Bindings.format((String)"%.0f%%", (Object[])new Object[]{this.graphOpacitySlider.valueProperty().multiply(100)}));
        this.enableDownSampling.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.downSamplingThreshold.setDisable(newValue == false);
            this.maxSampleLabel.setDisable(newValue == false);
        });
        this.enableDownSampling.selectedProperty().bindBidirectional((Property)prefs.downSamplingEnabledProperty());
        TextFormatter pathFormatter = new TextFormatter((StringConverter)new StringConverter<Path>(){

            public String toString(Path object) {
                return object.toString();
            }

            public Path fromString(String string) {
                return Paths.get(string, new String[0]);
            }
        });
        pathFormatter.valueProperty().bindBidirectional(prefs.pluginsLocationProperty());
        this.pluginLocTextfield.setTextFormatter(pathFormatter);
        prefs.pluginsLocationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null && !Files.exists(newValue, new LinkOption[0])) {
                Dialogs.notifyError("Invalid Plugins Folder Location", "The selected path for the plugins folder location does not exists", Pos.BOTTOM_RIGHT, (Node)this.root);
                Platform.runLater(() -> prefs.setPluginsLocation((Path)oldValue));
            } else {
                Dialogs.notifyInfo("Plugins Folder Location Changed", "Changes to the plugins folder location will take effect the next time binjr is started", Pos.BOTTOM_RIGHT, (Node)this.root);
            }
        });
        this.loadExternalToggle.selectedProperty().bindBidirectional((Property)prefs.loadPluginsFromExternalLocationProperty());
        this.browsePluginLocButton.disableProperty().bind((ObservableValue)prefs.loadPluginsFromExternalLocationProperty().not());
        this.pluginLocTextfield.disableProperty().bind((ObservableValue)prefs.loadPluginsFromExternalLocationProperty().not());
        this.enabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)this.enabledColumn));
        this.availableAdapterTable.getItems().setAll(DataAdapterFactory.getInstance().getAllAdapters());
        this.loadAtStartupCheckbox.selectedProperty().bindBidirectional((Property)prefs.loadLastWorkspaceOnStartupProperty());
        TextFormatter formatter = new TextFormatter((StringConverter)new NumberStringConverter(Locale.getDefault(Locale.Category.FORMAT)));
        this.downSamplingThreshold.setTextFormatter(formatter);
        formatter.valueProperty().bindBidirectional((Property)prefs.downSamplingThresholdProperty());
        this.uiThemeChoiceBox.getItems().setAll((Object[])UserInterfaceThemes.values());
        this.uiThemeChoiceBox.getSelectionModel().select((Object)prefs.getUserInterfaceTheme());
        prefs.userInterfaceThemeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.uiThemeChoiceBox.getSelectionModel().select((Object)newValue);
            }
        });
        this.uiThemeChoiceBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                prefs.setUserInterfaceTheme((UserInterfaceThemes)((Object)newValue));
            }
        });
        this.notifcationDurationChoiceBox.getItems().setAll((Object[])NotificationDurationChoices.values());
        this.notifcationDurationChoiceBox.getSelectionModel().select((Object)NotificationDurationChoices.valueOf(prefs.getNotificationPopupDuration()));
        prefs.notificationPopupDurationProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.notifcationDurationChoiceBox.getSelectionModel().select((Object)NotificationDurationChoices.valueOf(newValue));
            }
        });
        this.notifcationDurationChoiceBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                prefs.setNotificationPopupDuration(newValue.getDuration());
            }
        });
        this.updateCheckBox.selectedProperty().bindBidirectional((Property)prefs.checkForUpdateOnStartUpProperty());
        this.showOutline.selectedProperty().bindBidirectional((Property)prefs.showAreaOutlineProperty());
    }

    public void handleCheckForUpdate(ActionEvent actionEvent) {
        Button btn = (Button)actionEvent.getSource();
        btn.setDisable(true);
        this.printToTextFlow("Checking for updates...", "#C2C2C2");
        UpdateManager.getInstance().asyncForcedCheckForUpdate(githubRelease -> {
            this.updateFlow.getChildren().clear();
            Hyperlink latestReleaseLink = new Hyperlink("Version " + githubRelease.getVersion().toString() + " is available.");
            latestReleaseLink.setOnAction(event -> {
                try {
                    Dialogs.launchUrlInExternalBrowser(githubRelease.getHtmlUrl());
                }
                catch (IOException | URISyntaxException e) {
                    logger.error((Object)e);
                }
            });
            this.updateFlow.getChildren().add((Object)latestReleaseLink);
            btn.setDisable(false);
        }, version -> {
            btn.setDisable(false);
            this.printToTextFlow("binjr is up to date (v" + version.toString() + ")");
        }, () -> {
            btn.setDisable(false);
            this.printToTextFlow("Could not check for update!", "#E81123");
        });
    }

    private void printToTextFlow(String text) {
        this.printToTextFlow(text, null);
    }

    private void printToTextFlow(String text, String color) {
        this.updateFlow.getChildren().clear();
        Label l = new Label(text);
        if (color != null) {
            l.setStyle("-fx-text-fill:" + color + ";");
        }
        l.setWrapText(true);
        this.updateFlow.getChildren().add((Object)l);
    }

    public void handleHideSettings(ActionEvent actionEvent) {
        this.hide(Duration.millis((double)0.0));
    }

    private void hide(Duration delay) {
        Parent n = this.root.getParent();
        TranslateTransition openNav = new TranslateTransition(new Duration(200.0), (Node)n);
        openNav.setDelay(delay);
        openNav.setToX(-250.0);
        openNav.play();
    }

    public void handleResetSettings(ActionEvent actionEvent) {
        try {
            if (Dialogs.confirmDialog((Node)this.root, "Restore all settings to their default value.", "Are you sure?", new ButtonType[0]) == ButtonType.YES) {
                GlobalPreferences.getInstance().reset();
            }
        }
        catch (BackingStoreException e) {
            Dialogs.notifyException("Could not restore settings to default", e, (Node)this.root);
        }
    }

    public void handleBrowsePluginsFolder(ActionEvent actionEvent) {
        DirectoryChooser fileChooser = new DirectoryChooser();
        fileChooser.setTitle("Select binjr plugins location");
        try {
            Path pluginPath = Paths.get(this.pluginLocTextfield.getText(), new String[0]).toRealPath(new LinkOption[0]);
            if (Files.isDirectory(pluginPath, new LinkOption[0])) {
                fileChooser.setInitialDirectory(pluginPath.toFile());
            }
        }
        catch (Exception e) {
            logger.debug("Could not initialize working dir for DirectoryChooser", (Throwable)e);
        }
        File newPluginLocation = fileChooser.showDialog((Window)Dialogs.getStage((Node)this.root));
        if (newPluginLocation != null) {
            this.pluginLocTextfield.setText(newPluginLocation.getPath());
        }
    }
}

