/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.controllers.ChartPropertiesController;
import eu.fthevenet.binjr.controllers.ChartViewPort;
import eu.fthevenet.binjr.controllers.ChartViewportsState;
import eu.fthevenet.binjr.controllers.MainViewController;
import eu.fthevenet.binjr.controllers.WorksheetNavigationHistory;
import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.async.AsyncTaskManager;
import eu.fthevenet.binjr.data.exceptions.NoAdapterFoundException;
import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.binjr.data.workspace.ChartLayout;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.binjr.data.workspace.UnitPrefixes;
import eu.fthevenet.binjr.data.workspace.Worksheet;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import eu.fthevenet.util.javafx.bindings.BindingManager;
import eu.fthevenet.util.javafx.charts.BinaryStableTicksAxis;
import eu.fthevenet.util.javafx.charts.MetricStableTicksAxis;
import eu.fthevenet.util.javafx.charts.StableTicksAxis;
import eu.fthevenet.util.javafx.charts.XYChartCrosshair;
import eu.fthevenet.util.javafx.charts.XYChartSelection;
import eu.fthevenet.util.javafx.charts.ZonedDateTimeAxis;
import eu.fthevenet.util.javafx.controls.ColorTableCell;
import eu.fthevenet.util.javafx.controls.DecimalFormatTableCellFactory;
import eu.fthevenet.util.javafx.controls.DelayedAction;
import eu.fthevenet.util.javafx.controls.TimeRangePicker;
import eu.fthevenet.util.logging.Profiler;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.WorkerStateEvent;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.Axis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.ScatterChart;
import javafx.scene.chart.StackedAreaChart;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Path;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.MaskerPane;

public class WorksheetController
implements Initializable,
AutoCloseable {
    private static final DataFormat SERIALIZED_MIME_TYPE = new DataFormat(new String[]{"application/x-java-serialized-object"});
    private static final Logger logger = LogManager.getLogger(WorksheetController.class);
    private final GlobalPreferences globalPrefs = GlobalPreferences.getInstance();
    private Worksheet<Double> worksheet;
    private static final double Y_AXIS_SEPARATION = 10.0;
    private final MainViewController parentController;
    private volatile boolean preventReload = false;
    AtomicBoolean closed = new AtomicBoolean(false);
    @FXML
    public AnchorPane root;
    @FXML
    public AnchorPane chartParent;
    protected List<ChartViewPort<Double>> viewPorts = new ArrayList<ChartViewPort<Double>>();
    @FXML
    private TextField yMinRange;
    @FXML
    private TextField yMaxRange;
    @FXML
    private Accordion seriesTableContainer;
    @FXML
    private Button backButton;
    @FXML
    private Button forwardButton;
    @FXML
    private Button refreshButton;
    @FXML
    private Button snapshotButton;
    @FXML
    private ToggleButton vCrosshair;
    @FXML
    private ToggleButton hCrosshair;
    @FXML
    private Button addChartButton;
    @FXML
    private MaskerPane worksheetMaskerPane;
    @FXML
    private ContextMenu seriesListMenu;
    @FXML
    private MenuButton selectChartLayout;
    @FXML
    private TimeRangePicker timeRangePicker;
    private XYChartCrosshair<ZonedDateTime, Double> crossHair;
    private final ToggleGroup editButtonsGroup = new ToggleGroup();
    private ChartViewportsState currentState;
    private String name;
    private final BindingManager bindingManager = new BindingManager();
    public static final double TOOL_BUTTON_SIZE = 20.0;

    public WorksheetController(MainViewController parentController, Worksheet<Double> worksheet, Collection<DataAdapter> sourcesAdapters) throws IOException, NoAdapterFoundException {
        this.parentController = parentController;
        this.worksheet = worksheet;
        for (Chart chart : worksheet.getCharts()) {
            for (TimeSeriesInfo s : chart.getSeries()) {
                UUID id = s.getBinding().getAdapterId();
                DataAdapter da = sourcesAdapters.stream().filter(a -> id != null && a != null && a.getId() != null && id.equals(a.getId())).findAny().orElseThrow(() -> new NoAdapterFoundException("Failed to find a valid adapter with id " + (id != null ? id.toString() : "null")));
                s.getBinding().setAdapter(da);
            }
        }
    }

    private ChartPropertiesController buildChartPropertiesController(Chart<Double> chart) throws IOException {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/views/ChartPropertiesView.fxml"));
        ChartPropertiesController<Double> propertiesController = new ChartPropertiesController<Double>(this.getWorksheet(), chart);
        loader.setController(propertiesController);
        Pane settingsPane = (Pane)loader.load();
        AnchorPane.setRightAnchor((Node)settingsPane, (Double)-210.0);
        AnchorPane.setBottomAnchor((Node)settingsPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)settingsPane, (Double)0.0);
        settingsPane.getStyleClass().add((Object)"toolPane");
        settingsPane.setPrefWidth(200.0);
        settingsPane.setMinWidth(200.0);
        this.chartParent.getChildren().add((Object)settingsPane);
        Platform.runLater(() -> ((Pane)settingsPane).toFront());
        return propertiesController;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Worksheet<Double> getWorksheet() {
        return this.worksheet;
    }

    public void initialize(URL location, ResourceBundle resources) {
        assert (this.root != null) : "fx:id\"root\" was not injected!";
        assert (this.chartParent != null) : "fx:id\"chartParent\" was not injected!";
        assert (this.seriesTableContainer != null) : "fx:id\"seriesTableContainer\" was not injected!";
        assert (this.backButton != null) : "fx:id\"backButton\" was not injected!";
        assert (this.forwardButton != null) : "fx:id\"forwardButton\" was not injected!";
        assert (this.refreshButton != null) : "fx:id\"refreshButton\" was not injected!";
        assert (this.vCrosshair != null) : "fx:id\"vCrosshair\" was not injected!";
        assert (this.hCrosshair != null) : "fx:id\"hCrosshair\" was not injected!";
        assert (this.snapshotButton != null) : "fx:id\"snapshotButton\" was not injected!";
        try {
            this.initChartViewPorts();
            this.initNavigationPane();
            this.initTableViewPane();
            Platform.runLater(() -> this.invalidateAll(false, false, false));
            this.bindingManager.attachListener((ObservableValue<?>)this.globalPrefs.downSamplingEnabledProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> this.refresh()));
            this.bindingManager.attachListener((ObservableValue<?>)this.globalPrefs.downSamplingThresholdProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> this.refresh()));
        }
        catch (Exception e) {
            Platform.runLater(() -> Dialogs.notifyException("Error loading worksheet controller", e, (Node)this.root));
        }
    }

    private ZonedDateTimeAxis buildTimeAxis() {
        ZonedDateTimeAxis axis = new ZonedDateTimeAxis(this.getWorksheet().getTimeZone());
        this.bindingManager.bind(axis.zoneIdProperty(), this.getWorksheet().timeZoneProperty());
        axis.setAnimated(false);
        axis.setSide(Side.BOTTOM);
        return axis;
    }

    private void initChartViewPorts() throws IOException {
        ZonedDateTimeAxis defaultXAxis = this.buildTimeAxis();
        for (Chart currentChart : this.getWorksheet().getCharts()) {
            AreaChart viewPort;
            ZonedDateTimeAxis xAxis;
            switch (this.worksheet.getChartLayout()) {
                case OVERLAID: {
                    xAxis = defaultXAxis;
                    break;
                }
                case STACKED: {
                    xAxis = this.buildTimeAxis();
                    break;
                }
                default: {
                    xAxis = this.buildTimeAxis();
                }
            }
            StableTicksAxis yAxis = currentChart.getUnitPrefixes() == UnitPrefixes.BINARY ? new BinaryStableTicksAxis() : new MetricStableTicksAxis();
            yAxis.autoRangingProperty().bindBidirectional((Property)currentChart.autoScaleYAxisProperty());
            yAxis.setAnimated(false);
            yAxis.setTickSpacing(30.0);
            this.bindingManager.bind(yAxis.labelProperty(), Bindings.createStringBinding(() -> String.format("%s - %s", currentChart.getName(), currentChart.getUnit()), (Observable[])new Observable[]{currentChart.nameProperty(), currentChart.unitProperty()}));
            switch (currentChart.getChartType()) {
                case AREA: {
                    viewPort = new AreaChart((Axis)xAxis, (Axis)yAxis);
                    viewPort.setCreateSymbols(false);
                    break;
                }
                case STACKED: {
                    viewPort = new StackedAreaChart((Axis)xAxis, (Axis)yAxis);
                    ((StackedAreaChart)viewPort).setCreateSymbols(false);
                    break;
                }
                case SCATTER: {
                    viewPort = new ScatterChart((Axis)xAxis, (Axis)yAxis);
                    break;
                }
                default: {
                    viewPort = new LineChart((Axis)xAxis, (Axis)yAxis);
                    ((LineChart)viewPort).setCreateSymbols(false);
                }
            }
            viewPort.setCache(true);
            viewPort.setCacheHint(CacheHint.SPEED);
            viewPort.setCacheShape(true);
            viewPort.setFocusTraversable(true);
            viewPort.setLegendVisible(false);
            viewPort.setAnimated(false);
            this.viewPorts.add(new ChartViewPort(currentChart, viewPort, this.buildChartPropertiesController(currentChart)));
        }
        this.bindingManager.bind(this.selectChartLayout.visibleProperty(), Bindings.createBooleanBinding(() -> this.worksheet.getCharts().size() > 1, (Observable[])new Observable[]{this.worksheet.getCharts()}));
        this.selectChartLayout.getItems().setAll((Collection)Arrays.stream(ChartLayout.values()).map(chartLayout -> {
            MenuItem item = new MenuItem(chartLayout.toString());
            item.setOnAction(event -> this.worksheet.setChartLayout((ChartLayout)((Object)chartLayout)));
            return item;
        }).collect(Collectors.toList()));
        switch (this.worksheet.getChartLayout()) {
            case OVERLAID: {
                this.setupOverlayChartLayout();
                break;
            }
            case STACKED: {
                this.setupStackedChartLayout();
            }
        }
    }

    private void setupOverlayChartLayout() {
        for (int i = 0; i < this.viewPorts.size(); ++i) {
            ChartViewPort<Double> v2 = this.viewPorts.get(i);
            XYChart<ZonedDateTime, Double> chart = v2.getChart();
            int nbAdditionalCharts = this.getWorksheet().getCharts().size() - 1;
            DoubleBinding n = Bindings.createDoubleBinding(() -> this.viewPorts.stream().filter(c -> !c.getChart().equals(chart)).map(c -> c.getChart().getYAxis().getWidth()).reduce(Double::sum).orElse(0.0) + 10.0 * (double)nbAdditionalCharts, (Observable[])((Observable[])this.viewPorts.stream().map(c -> c.getChart().getYAxis().widthProperty()).toArray(ReadOnlyDoubleProperty[]::new)));
            HBox hBox = new HBox(new Node[]{chart});
            hBox.setAlignment(Pos.CENTER_LEFT);
            this.bindingManager.bind(hBox.prefHeightProperty(), this.chartParent.heightProperty());
            this.bindingManager.bind(hBox.prefWidthProperty(), this.chartParent.widthProperty());
            this.bindingManager.bind(chart.minWidthProperty(), this.chartParent.widthProperty().subtract((ObservableNumberValue)n));
            this.bindingManager.bind(chart.prefWidthProperty(), this.chartParent.widthProperty().subtract((ObservableNumberValue)n));
            this.bindingManager.bind(chart.maxWidthProperty(), this.chartParent.widthProperty().subtract((ObservableNumberValue)n));
            if (i == 0) {
                chart.getYAxis().setSide(Side.LEFT);
            } else {
                chart.getYAxis().setSide(Side.RIGHT);
                chart.setVerticalZeroLineVisible(false);
                chart.setHorizontalZeroLineVisible(false);
                chart.setVerticalGridLinesVisible(false);
                chart.setHorizontalGridLinesVisible(false);
                this.bindingManager.bind(chart.translateXProperty(), this.viewPorts.get(0).getChart().getYAxis().widthProperty());
                this.bindingManager.bind(chart.getYAxis().translateXProperty(), Bindings.createDoubleBinding(() -> this.viewPorts.stream().filter(c -> this.viewPorts.indexOf(c) != 0 && this.viewPorts.indexOf(c) < this.viewPorts.indexOf(v2)).map(c -> c.getChart().getYAxis().getWidth()).reduce(Double::sum).orElse(0.0) + 10.0 * (double)(this.viewPorts.indexOf(v2) - 1), (Observable[])((Observable[])this.viewPorts.stream().map(c -> c.getChart().getYAxis().widthProperty()).toArray(ReadOnlyDoubleProperty[]::new))));
            }
            this.chartParent.getChildren().add((Object)hBox);
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;
        LinkedHashMap map = new LinkedHashMap();
        this.viewPorts.forEach(v -> map.put(v.getChart(), v.getPrefixFormatter()::format));
        this.crossHair = new XYChartCrosshair(map, (Pane)this.chartParent, dateTimeFormatter::format);
        this.crossHair.onSelectionDone(s -> {
            logger.debug(() -> "Applying zoom selection: " + s.toString());
            this.currentState.setSelection(this.convertSelection((Map<XYChart<ZonedDateTime, Double>, XYChartSelection<ZonedDateTime, Double>>)s), true);
        });
        this.hCrosshair.selectedProperty().bindBidirectional((Property)this.globalPrefs.horizontalMarkerOnProperty());
        this.vCrosshair.selectedProperty().bindBidirectional((Property)this.globalPrefs.verticalMarkerOnProperty());
        this.bindingManager.bind(this.crossHair.horizontalMarkerVisibleProperty(), Bindings.createBooleanBinding(() -> this.globalPrefs.isShiftPressed() != false || this.hCrosshair.isSelected(), (Observable[])new Observable[]{this.hCrosshair.selectedProperty(), this.globalPrefs.shiftPressedProperty()}));
        this.bindingManager.bind(this.crossHair.verticalMarkerVisibleProperty(), Bindings.createBooleanBinding(() -> this.globalPrefs.isCtrlPressed() != false || this.vCrosshair.isSelected(), (Observable[])new Observable[]{this.vCrosshair.selectedProperty(), this.globalPrefs.ctrlPressedProperty()}));
    }

    private void setupStackedChartLayout() {
        VBox vBox = new VBox();
        vBox.getStyleClass().add((Object)"chart-viewport-parent");
        vBox.setAlignment(Pos.TOP_LEFT);
        this.bindingManager.bind(vBox.prefHeightProperty(), this.chartParent.heightProperty());
        this.bindingManager.bind(vBox.prefWidthProperty(), this.chartParent.widthProperty());
        for (int i = 0; i < this.viewPorts.size(); ++i) {
            ChartViewPort<Double> v = this.viewPorts.get(i);
            XYChart<ZonedDateTime, Double> chart = v.getChart();
            int nbAdditionalCharts = this.getWorksheet().getCharts().size() - 1;
            DoubleBinding n = Bindings.createDoubleBinding(() -> this.viewPorts.stream().filter(c -> !c.getChart().equals(chart)).map(c -> c.getChart().getYAxis().getWidth()).reduce(Double::sum).orElse(0.0) + 10.0 * (double)nbAdditionalCharts, (Observable[])((Observable[])this.viewPorts.stream().map(c -> c.getChart().getYAxis().widthProperty()).toArray(ReadOnlyDoubleProperty[]::new)));
            vBox.getChildren().add(chart);
            chart.maxHeight(Double.MAX_VALUE);
            VBox.setVgrow(chart, (Priority)Priority.ALWAYS);
            chart.getYAxis().setSide(Side.LEFT);
            chart.getYAxis().setPrefWidth(60.0);
            chart.getYAxis().setMinWidth(60.0);
            chart.getYAxis().setMaxWidth(60.0);
        }
        this.chartParent.getChildren().add((Object)new ScrollPane((Node)vBox));
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;
        LinkedHashMap map = new LinkedHashMap();
        map.put(this.viewPorts.get(0).getChart(), this.viewPorts.get(0).getPrefixFormatter()::format);
        this.crossHair = new XYChartCrosshair(map, (Pane)this.chartParent, dateTimeFormatter::format);
        this.crossHair.onSelectionDone(s -> {
            logger.debug(() -> "Applying zoom selection: " + s.toString());
            this.currentState.setSelection(this.convertSelection((Map<XYChart<ZonedDateTime, Double>, XYChartSelection<ZonedDateTime, Double>>)s), true);
        });
        this.hCrosshair.selectedProperty().bindBidirectional((Property)this.globalPrefs.horizontalMarkerOnProperty());
        this.vCrosshair.selectedProperty().bindBidirectional((Property)this.globalPrefs.verticalMarkerOnProperty());
        this.bindingManager.bind(this.crossHair.horizontalMarkerVisibleProperty(), Bindings.createBooleanBinding(() -> this.globalPrefs.isShiftPressed() != false || this.hCrosshair.isSelected(), (Observable[])new Observable[]{this.hCrosshair.selectedProperty(), this.globalPrefs.shiftPressedProperty()}));
        this.bindingManager.bind(this.crossHair.verticalMarkerVisibleProperty(), Bindings.createBooleanBinding(() -> this.globalPrefs.isCtrlPressed() != false || this.vCrosshair.isSelected(), (Observable[])new Observable[]{this.vCrosshair.selectedProperty(), this.globalPrefs.ctrlPressedProperty()}));
        for (int i = 1; i < this.viewPorts.size(); ++i) {
            LinkedHashMap m = new LinkedHashMap();
            m.put(this.viewPorts.get(i).getChart(), this.viewPorts.get(i).getPrefixFormatter()::format);
            XYChartCrosshair ch = new XYChartCrosshair(m, (Pane)this.chartParent, dateTimeFormatter::format);
            ch.onSelectionDone(s -> {
                logger.debug(() -> "Applying zoom selection: " + s.toString());
                this.currentState.setSelection(this.convertSelection((Map<XYChart<ZonedDateTime, Double>, XYChartSelection<ZonedDateTime, Double>>)s), true);
            });
            this.bindingManager.bind(ch.horizontalMarkerVisibleProperty(), Bindings.createBooleanBinding(() -> this.globalPrefs.isShiftPressed() != false || this.hCrosshair.isSelected(), (Observable[])new Observable[]{this.hCrosshair.selectedProperty(), this.globalPrefs.shiftPressedProperty()}));
            this.bindingManager.bind(ch.verticalMarkerVisibleProperty(), Bindings.createBooleanBinding(() -> this.globalPrefs.isCtrlPressed() != false || this.vCrosshair.isSelected(), (Observable[])new Observable[]{this.vCrosshair.selectedProperty(), this.globalPrefs.ctrlPressedProperty()}));
        }
    }

    private void initNavigationPane() {
        this.backButton.setOnAction(this::handleHistoryBack);
        this.forwardButton.setOnAction(this::handleHistoryForward);
        this.refreshButton.setOnAction(this::handleRefresh);
        this.snapshotButton.setOnAction(this::handleTakeSnapshot);
        this.bindingManager.bind(this.backButton.disableProperty(), this.getWorksheet().getBackwardHistory().emptyProperty());
        this.bindingManager.bind(this.forwardButton.disableProperty(), this.getWorksheet().getForwardHistory().emptyProperty());
        this.addChartButton.setOnAction(this::handleAddNewChart);
        this.currentState = new ChartViewportsState(this, this.getWorksheet().getFromDateTime(), this.getWorksheet().getToDateTime());
        for (ChartViewPort<Double> viewPort : this.viewPorts) {
            this.currentState.get(viewPort.getDataStore()).ifPresent(state -> this.plotChart(viewPort, state.asSelection(), true));
        }
        this.timeRangePicker.zoneIdProperty().bindBidirectional(this.getWorksheet().timeZoneProperty());
        this.timeRangePicker.setSelectedRange(TimeRangePicker.TimeRange.of(this.currentState.getStartX(), this.currentState.getEndX()));
        this.timeRangePicker.selectedRangeProperty().addListener((observable, oldValue, newValue) -> this.currentState.setSelection(this.currentState.selectTimeRange(newValue.getBeginning(), newValue.getEnd()), true));
        this.currentState.startXProperty().addListener((observable, oldValue, newValue) -> this.timeRangePicker.updateRangeBeginning((ZonedDateTime)newValue));
        this.currentState.endXProperty().addListener((observable, oldValue, newValue) -> this.timeRangePicker.updateRangeEnd((ZonedDateTime)newValue));
    }

    private Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> convertSelection(Map<XYChart<ZonedDateTime, Double>, XYChartSelection<ZonedDateTime, Double>> selection) {
        HashMap<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> result = new HashMap<Chart<Double>, XYChartSelection<ZonedDateTime, Double>>();
        selection.forEach((xyChart, xyChartSelection) -> this.viewPorts.stream().filter(v -> v.getChart().equals(xyChart)).findFirst().ifPresent(viewPort -> result.put(viewPort.getDataStore(), (XYChartSelection<ZonedDateTime, Double>)xyChartSelection)));
        return result;
    }

    private void handleAddNewChart(ActionEvent actionEvent) {
        this.worksheet.getCharts().add(new Chart());
    }

    private void initTableViewPane() {
        for (ChartViewPort<Double> currentViewPort : this.viewPorts) {
            currentViewPort.getSeriesTable().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            CheckBox showAllCheckBox = new CheckBox();
            TableColumn visibleColumn = new TableColumn();
            visibleColumn.setGraphic((Node)showAllCheckBox);
            visibleColumn.setSortable(false);
            visibleColumn.setResizable(false);
            visibleColumn.setPrefWidth(32.0);
            InvalidationListener isVisibleListener = observable -> {
                boolean andAll = true;
                boolean orAll = false;
                for (TimeSeriesInfo t : currentViewPort.getDataStore().getSeries()) {
                    andAll &= t.isSelected();
                    orAll |= t.isSelected();
                }
                showAllCheckBox.setIndeterminate(Boolean.logicalXor(andAll, orAll));
                showAllCheckBox.setSelected(andAll);
            };
            ChangeListener refreshListener = (observable, oldValue, newValue) -> {
                if (this.worksheet.getChartLayout() == ChartLayout.OVERLAID) {
                    this.invalidateAll(false, false, false);
                } else {
                    this.invalidate(currentViewPort, false, false);
                }
            };
            currentViewPort.getDataStore().getSeries().forEach(doubleTimeSeriesInfo -> {
                this.bindingManager.attachListener((ObservableValue<?>)doubleTimeSeriesInfo.selectedProperty(), (ChangeListener<?>)refreshListener);
                this.bindingManager.attachListener((ObservableValue<?>)doubleTimeSeriesInfo.selectedProperty(), isVisibleListener);
                isVisibleListener.invalidated(null);
            });
            visibleColumn.setCellValueFactory(p -> ((TimeSeriesInfo)p.getValue()).selectedProperty());
            visibleColumn.setCellFactory(CheckBoxTableCell.forTableColumn((TableColumn)visibleColumn));
            showAllCheckBox.setOnAction(event -> {
                ChangeListener r = (observable, oldValue, newValue) -> {
                    if (this.worksheet.getChartLayout() == ChartLayout.OVERLAID) {
                        this.invalidateAll(false, false, false);
                    } else {
                        this.invalidate(currentViewPort, false, false);
                    }
                };
                boolean b = ((CheckBox)event.getSource()).isSelected();
                currentViewPort.getDataStore().getSeries().forEach(s -> this.bindingManager.detachAllChangeListeners((ObservableValue<?>)s.selectedProperty()));
                currentViewPort.getDataStore().getSeries().forEach(t -> t.setSelected(b));
                r.changed(null, null, null);
                currentViewPort.getDataStore().getSeries().forEach(s -> this.bindingManager.attachListener((ObservableValue<?>)s.selectedProperty(), (ChangeListener<?>)r));
            });
            DecimalFormatTableCellFactory alignRightCellFactory = new DecimalFormatTableCellFactory();
            alignRightCellFactory.setAlignment(TextAlignment.RIGHT);
            TableColumn colorColumn = new TableColumn();
            colorColumn.setSortable(false);
            colorColumn.setResizable(false);
            colorColumn.setPrefWidth(32.0);
            TableColumn nameColumn = new TableColumn("Name");
            nameColumn.setSortable(false);
            nameColumn.setPrefWidth(160.0);
            nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("displayName"));
            TableColumn minColumn = new TableColumn("Min.");
            minColumn.setSortable(false);
            minColumn.setPrefWidth(75.0);
            minColumn.setCellFactory(alignRightCellFactory);
            TableColumn maxColumn = new TableColumn("Max.");
            maxColumn.setSortable(false);
            maxColumn.setPrefWidth(75.0);
            maxColumn.setCellFactory(alignRightCellFactory);
            TableColumn avgColumn = new TableColumn("Avg.");
            avgColumn.setSortable(false);
            avgColumn.setPrefWidth(75.0);
            avgColumn.setCellFactory(alignRightCellFactory);
            TableColumn currentColumn = new TableColumn("Current");
            currentColumn.setSortable(false);
            currentColumn.setPrefWidth(75.0);
            currentColumn.setCellFactory(alignRightCellFactory);
            currentColumn.getStyleClass().add((Object)"column-bold-text");
            TableColumn pathColumn = new TableColumn("Path");
            pathColumn.setSortable(false);
            pathColumn.setPrefWidth(400.0);
            currentColumn.setVisible(this.crossHair.isVerticalMarkerVisible());
            this.bindingManager.attachListener((ObservableValue<?>)this.crossHair.verticalMarkerVisibleProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> currentColumn.setVisible(newValue.booleanValue())));
            pathColumn.setCellValueFactory(p -> new SimpleStringProperty(((TimeSeriesInfo)p.getValue()).getBinding().getTreeHierarchy()));
            colorColumn.setCellFactory(param -> new ColorTableCell(colorColumn));
            colorColumn.setCellValueFactory(p -> ((TimeSeriesInfo)p.getValue()).displayColorProperty());
            avgColumn.setCellValueFactory(p -> Bindings.createStringBinding(() -> ((TimeSeriesInfo)p.getValue()).getProcessor() == null ? "NaN" : currentViewPort.getPrefixFormatter().format((Double)((TimeSeriesInfo)p.getValue()).getProcessor().getAverageValue()), (Observable[])new Observable[]{((TimeSeriesInfo)p.getValue()).processorProperty()}));
            minColumn.setCellValueFactory(p -> Bindings.createStringBinding(() -> ((TimeSeriesInfo)p.getValue()).getProcessor() == null ? "NaN" : currentViewPort.getPrefixFormatter().format((Double)((TimeSeriesInfo)p.getValue()).getProcessor().getMinValue()), (Observable[])new Observable[]{((TimeSeriesInfo)p.getValue()).processorProperty()}));
            maxColumn.setCellValueFactory(p -> Bindings.createStringBinding(() -> ((TimeSeriesInfo)p.getValue()).getProcessor() == null ? "NaN" : currentViewPort.getPrefixFormatter().format((Double)((TimeSeriesInfo)p.getValue()).getProcessor().getMaxValue()), (Observable[])new Observable[]{((TimeSeriesInfo)p.getValue()).processorProperty()}));
            currentColumn.setCellValueFactory(p -> Bindings.createStringBinding(() -> {
                if (((TimeSeriesInfo)p.getValue()).getProcessor() == null) {
                    return "NaN";
                }
                return currentViewPort.getPrefixFormatter().format(((TimeSeriesInfo)p.getValue()).getProcessor().tryGetNearestValue(this.crossHair.getCurrentXValue()).orElse(Double.NaN));
            }, (Observable[])new Observable[]{this.crossHair.currentXValueProperty()}));
            currentViewPort.getSeriesTable().setRowFactory(this::seriesTableRowFactory);
            currentViewPort.getSeriesTable().setOnKeyReleased(event -> {
                if (event.getCode().equals((Object)KeyCode.DELETE)) {
                    this.removeSelectedBinding((TableView<TimeSeriesInfo<Double>>)((TableView)event.getSource()));
                }
            });
            currentViewPort.getSeriesTable().setItems(currentViewPort.getDataStore().getSeries());
            currentViewPort.getSeriesTable().getColumns().addAll((Object[])new TableColumn[]{visibleColumn, colorColumn, nameColumn, minColumn, maxColumn, avgColumn, currentColumn, pathColumn});
            TitledPane newPane2 = new TitledPane(currentViewPort.getDataStore().getName(), currentViewPort.getSeriesTable());
            newPane2.setOnDragOver(this::handleDragOverWorksheetView);
            newPane2.setOnDragDropped(this::handleDragDroppedOnWorksheetView);
            newPane2.setUserData(currentViewPort);
            GridPane titleRegion = new GridPane();
            titleRegion.setHgap(5.0);
            titleRegion.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, true));
            titleRegion.getColumnConstraints().add((Object)new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false));
            this.bindingManager.bind(titleRegion.minWidthProperty(), newPane2.widthProperty().subtract(30));
            this.bindingManager.bind(titleRegion.maxWidthProperty(), newPane2.widthProperty().subtract(30));
            Label label = new Label();
            this.bindingManager.bind(label.textProperty(), currentViewPort.getDataStore().nameProperty());
            this.bindingManager.bind(label.visibleProperty(), currentViewPort.getDataStore().showPropertiesProperty().not());
            HBox editFieldsGroup = new HBox();
            DoubleBinding db = Bindings.createDoubleBinding(() -> editFieldsGroup.isVisible() ? -1.0 : 0.0, (Observable[])new Observable[]{editFieldsGroup.visibleProperty()});
            this.bindingManager.bind(editFieldsGroup.prefHeightProperty(), db);
            this.bindingManager.bind(editFieldsGroup.maxHeightProperty(), db);
            this.bindingManager.bind(editFieldsGroup.minHeightProperty(), db);
            this.bindingManager.bind(editFieldsGroup.visibleProperty(), currentViewPort.getDataStore().showPropertiesProperty());
            editFieldsGroup.setSpacing(5.0);
            TextField chartNameField = new TextField();
            chartNameField.textProperty().bindBidirectional(currentViewPort.getDataStore().nameProperty());
            TextField unitNameField = new TextField();
            unitNameField.textProperty().bindBidirectional(currentViewPort.getDataStore().unitProperty());
            ChoiceBox unitPrefixChoiceBox = new ChoiceBox();
            unitPrefixChoiceBox.getItems().setAll((Object[])UnitPrefixes.values());
            unitPrefixChoiceBox.getSelectionModel().select((Object)currentViewPort.getDataStore().getUnitPrefixes());
            this.bindingManager.bind(currentViewPort.getDataStore().unitPrefixesProperty(), unitPrefixChoiceBox.getSelectionModel().selectedItemProperty());
            HBox.setHgrow((Node)chartNameField, (Priority)Priority.ALWAYS);
            titleRegion.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    chartNameField.selectAll();
                    chartNameField.requestFocus();
                    currentViewPort.getDataStore().setShowProperties(true);
                }
            });
            editFieldsGroup.getChildren().addAll((Object[])new Node[]{chartNameField, unitNameField, unitPrefixChoiceBox});
            HBox toolbar = new HBox();
            toolbar.getStyleClass().add((Object)"title-pane-tool-bar");
            toolbar.setAlignment(Pos.CENTER);
            Button closeButton = (Button)this.newToolBarButton(Button::new, "Close", "Remove this chart from the worksheet.", new String[]{"exit"}, new String[]{"cross-icon", "small-icon"});
            closeButton.setOnAction(event -> {
                if (Dialogs.confirmDialog((Node)this.root, "Are you sure you want to remove chart \"" + currentViewPort.getDataStore().getName() + "\"?", "", ButtonType.YES, ButtonType.NO) == ButtonType.YES) {
                    this.worksheet.getCharts().remove(currentViewPort.getDataStore());
                }
            });
            this.bindingManager.bind(closeButton.disableProperty(), Bindings.createBooleanBinding(() -> this.worksheet.getCharts().size() > 1, (Observable[])new Observable[]{this.worksheet.getCharts()}).not());
            ToggleButton editButton = (ToggleButton)this.newToolBarButton(ToggleButton::new, "Settings", "Edit the chart's settings", new String[]{"dialog-button"}, new String[]{"settings-icon", "small-icon"});
            editButton.selectedProperty().bindBidirectional((Property)currentViewPort.getDataStore().showPropertiesProperty());
            editButton.setOnAction(event -> newPane2.setExpanded(true));
            this.editButtonsGroup.getToggles().add((Object)editButton);
            Button moveUpButton = (Button)this.newToolBarButton(Button::new, "Up", "Move the chart up the list.", new String[]{"dialog-button"}, new String[]{"upArrow-icon", "small-icon"});
            this.bindingManager.bind(moveUpButton.disableProperty(), Bindings.createBooleanBinding(() -> this.seriesTableContainer.getPanes().indexOf((Object)newPane2) == 0, (Observable[])new Observable[]{this.seriesTableContainer.getPanes()}));
            this.bindingManager.bind(moveUpButton.visibleProperty(), currentViewPort.getDataStore().showPropertiesProperty());
            moveUpButton.setOnAction(event -> {
                int idx = this.worksheet.getCharts().indexOf(currentViewPort.getDataStore());
                this.preventReload = true;
                try {
                    this.worksheet.getCharts().remove(currentViewPort.getDataStore());
                }
                finally {
                    this.preventReload = false;
                }
                this.worksheet.getCharts().add(idx - 1, currentViewPort.getDataStore());
            });
            Button moveDownButton = (Button)this.newToolBarButton(Button::new, "Down", "Move the chart down the list.", new String[]{"dialog-button"}, new String[]{"downArrow-icon", "small-icon"});
            this.bindingManager.bind(moveDownButton.disableProperty(), Bindings.createBooleanBinding(() -> this.seriesTableContainer.getPanes().indexOf((Object)newPane2) >= this.seriesTableContainer.getPanes().size() - 1, (Observable[])new Observable[]{this.seriesTableContainer.getPanes()}));
            this.bindingManager.bind(moveDownButton.visibleProperty(), currentViewPort.getDataStore().showPropertiesProperty());
            moveDownButton.setOnAction(event -> {
                int idx = this.worksheet.getCharts().indexOf(currentViewPort.getDataStore());
                this.preventReload = true;
                try {
                    this.worksheet.getCharts().remove(currentViewPort.getDataStore());
                }
                finally {
                    this.preventReload = false;
                }
                this.worksheet.getCharts().add(idx + 1, currentViewPort.getDataStore());
            });
            toolbar.getChildren().addAll((Object[])new Node[]{moveUpButton, moveDownButton, editButton, closeButton});
            titleRegion.getChildren().addAll((Object[])new Node[]{label, editFieldsGroup, toolbar});
            HBox hBox = new HBox();
            hBox.setAlignment(Pos.CENTER);
            GridPane.setConstraints((Node)label, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
            GridPane.setConstraints((Node)toolbar, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.CENTER);
            newPane2.setGraphic((Node)titleRegion);
            newPane2.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            newPane2.setAnimated(false);
            this.seriesTableContainer.getPanes().add((Object)newPane2);
        }
        Platform.runLater(() -> ((TitledPane)this.seriesTableContainer.getPanes().get(this.getWorksheet().getSelectedChart().intValue())).setExpanded(true));
        this.bindingManager.attachListener((ObservableValue<?>)this.seriesTableContainer.expandedPaneProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldPane, newPane) -> {
            Boolean expandRequiered = true;
            for (TitledPane pane : this.seriesTableContainer.getPanes()) {
                if (!pane.isExpanded()) continue;
                expandRequiered = false;
            }
            this.getAttachedViewport((TitledPane)newPane).ifPresent(nv -> {
                this.getWorksheet().setSelectedChart(this.viewPorts.indexOf(nv));
                if (this.editButtonsGroup.getSelectedToggle() != null) {
                    nv.getDataStore().setShowProperties(true);
                }
            });
            if (expandRequiered.booleanValue() && oldPane != null) {
                this.getWorksheet().setSelectedChart(this.seriesTableContainer.getPanes().indexOf(oldPane));
                Platform.runLater(() -> this.seriesTableContainer.setExpandedPane(oldPane));
            }
        }));
    }

    private ButtonBase newToolBarButton(Supplier<ButtonBase> btnFactory, String text, String tooltipMsg, String[] styleClass, String[] iconStyleClass) {
        ButtonBase btn = btnFactory.get();
        btn.setText(text);
        btn.setPrefHeight(20.0);
        btn.setMaxHeight(20.0);
        btn.setMinHeight(20.0);
        btn.setPrefWidth(20.0);
        btn.setMaxWidth(20.0);
        btn.setMinWidth(20.0);
        btn.getStyleClass().addAll((Object[])styleClass);
        btn.setAlignment(Pos.CENTER);
        Region icon = new Region();
        icon.getStyleClass().addAll((Object[])iconStyleClass);
        btn.setGraphic((Node)icon);
        btn.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        btn.setTooltip(new Tooltip(tooltipMsg));
        return btn;
    }

    Optional<ChartViewPort<?>> getAttachedViewport(TitledPane pane) {
        if (pane != null && pane.getUserData() instanceof ChartViewPort) {
            return Optional.of((ChartViewPort)pane.getUserData());
        }
        return Optional.empty();
    }

    private void handleDragOverWorksheetView(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(MainViewController.TIME_SERIES_BINDING_FORMAT)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            event.consume();
        }
    }

    private void handleDragDroppedOnWorksheetView(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasContent(MainViewController.TIME_SERIES_BINDING_FORMAT)) {
            TreeView<TimeSeriesBinding<Double>> treeView = this.parentController.getSelectedTreeView();
            if (treeView != null) {
                TreeItem item = (TreeItem)treeView.getSelectionModel().getSelectedItem();
                if (item != null) {
                    Stage targetStage = (Stage)((Node)event.getSource()).getScene().getWindow();
                    if (targetStage != null) {
                        targetStage.requestFocus();
                    }
                    if (TransferMode.MOVE.equals((Object)event.getAcceptedTransferMode())) {
                        try {
                            TitledPane droppedPane = (TitledPane)event.getSource();
                            droppedPane.setExpanded(true);
                            ChartViewPort viewPort = (ChartViewPort)droppedPane.getUserData();
                            ArrayList<TimeSeriesBinding<Double>> bindings = new ArrayList<TimeSeriesBinding<Double>>();
                            this.parentController.getAllBindingsFromBranch(item, bindings);
                            this.addBindings(bindings, viewPort.getDataStore());
                        }
                        catch (Exception e) {
                            Dialogs.notifyException("Error adding bindings to existing worksheet", e, (Node)this.root);
                        }
                        logger.debug("dropped to " + event.toString());
                    } else {
                        logger.warn("Unsupported drag and drop transfer mode: " + event.getAcceptedTransferMode());
                    }
                } else {
                    logger.warn("Cannot complete drag and drop operation: selected TreeItem is null");
                }
            } else {
                logger.warn("Cannot complete drag and drop operation: selected TreeView is null");
            }
            event.consume();
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            logger.debug(() -> "Closing worksheetController " + this.toString());
            this.bindingManager.close();
            this.currentState.close();
            this.hCrosshair.selectedProperty().unbindBidirectional((Property)this.globalPrefs.horizontalMarkerOnProperty());
            this.vCrosshair.selectedProperty().unbindBidirectional((Property)this.globalPrefs.verticalMarkerOnProperty());
            this.currentState = null;
            this.worksheet = null;
            this.seriesTableContainer = null;
            this.crossHair = null;
            this.viewPorts = null;
        }
    }

    public void setReloadRequiredHandler(Consumer<WorksheetController> action) {
        ChangeListener controllerReloadListener = (observable, oldValue, newValue) -> {
            if (newValue != null) {
                logger.debug("Reloading worksheet controller because property changed from: " + oldValue + " to " + newValue);
                action.accept(this);
                this.close();
            }
        };
        this.bindingManager.attachListener((ObservableValue<?>)this.worksheet.chartLayoutProperty(), (ChangeListener<?>)controllerReloadListener);
        this.worksheet.getCharts().forEach(c -> {
            this.bindingManager.attachListener((ObservableValue<?>)c.unitPrefixesProperty(), (ChangeListener<?>)controllerReloadListener);
            this.bindingManager.attachListener((ObservableValue<?>)c.chartTypeProperty(), (ChangeListener<?>)controllerReloadListener);
        });
        ListChangeListener chartListListener = c -> {
            while (c.next()) {
                if (c.wasPermutated()) {
                    for (int i = c.getFrom(); i < c.getTo(); ++i) {
                    }
                    continue;
                }
                if (c.wasUpdated()) continue;
                if (!this.preventReload) {
                    if (c.wasAdded()) {
                        List added = c.getAddedSubList();
                        Chart chart = (Chart)added.get(added.size() - 1);
                        int chartIndex = this.worksheet.getCharts().indexOf((Object)chart);
                        this.worksheet.setSelectedChart(chartIndex);
                        chart.setShowProperties(true);
                    }
                    if (c.wasRemoved()) {
                        if (this.worksheet.getSelectedChart().intValue() == c.getFrom()) {
                            this.worksheet.setSelectedChart(Math.max(0, c.getFrom() - 1));
                        } else if (this.worksheet.getSelectedChart() > c.getFrom()) {
                            this.worksheet.setSelectedChart(Math.max(0, this.worksheet.getSelectedChart() - 1));
                        }
                    }
                    logger.debug(() -> "Reloading worksheet controller because list changed: " + c.toString() + " in controller " + this.toString());
                    action.accept(this);
                    continue;
                }
                logger.debug(() -> "Reload explicitly prevented on change " + c.toString());
            }
        };
        this.bindingManager.attachListener(this.worksheet.getCharts(), chartListListener);
    }

    protected void addBindings(Collection<TimeSeriesBinding<Double>> bindings, Chart<Double> targetChart) {
        InvalidationListener isVisibleListener = observable -> this.viewPorts.stream().filter(v -> v.getDataStore().equals(targetChart)).findFirst().ifPresent(v -> {
            boolean andAll = true;
            boolean orAll = false;
            for (TimeSeriesInfo t : targetChart.getSeries()) {
                andAll &= t.isSelected();
                orAll |= t.isSelected();
            }
            CheckBox showAllCheckBox = (CheckBox)((TableColumn)v.getSeriesTable().getColumns().get(0)).getGraphic();
            showAllCheckBox.setIndeterminate(Boolean.logicalXor(andAll, orAll));
            showAllCheckBox.setSelected(andAll);
        });
        for (TimeSeriesBinding<Double> b : bindings) {
            TimeSeriesInfo<Double> newSeries = TimeSeriesInfo.fromBinding(b);
            this.bindingManager.attachListener((ObservableValue<?>)newSeries.selectedProperty(), (ChangeListener<?>)((ChangeListener)(observable, oldValue, newValue) -> this.viewPorts.stream().filter(v -> v.getDataStore().equals(targetChart)).findFirst().ifPresent(v -> this.invalidate((ChartViewPort<Double>)v, false, false))));
            this.bindingManager.attachListener((ObservableValue<?>)newSeries.selectedProperty(), isVisibleListener);
            targetChart.addSeries(newSeries);
            isVisibleListener.invalidated(null);
        }
        this.invalidateAll(false, false, false);
    }

    protected void removeSelectedBinding(TableView<TimeSeriesInfo<Double>> seriesTable) {
        ArrayList selected = new ArrayList(seriesTable.getSelectionModel().getSelectedItems());
        seriesTable.getItems().removeAll(selected);
        seriesTable.getSelectionModel().clearSelection();
        this.invalidateAll(false, false, false);
    }

    protected void refresh() {
        this.invalidateAll(false, false, true);
    }

    @FXML
    protected void handleHistoryBack(ActionEvent actionEvent) {
        this.restoreSelectionFromHistory(this.getWorksheet().getBackwardHistory(), this.getWorksheet().getForwardHistory());
    }

    @FXML
    protected void handleHistoryForward(ActionEvent actionEvent) {
        this.restoreSelectionFromHistory(this.getWorksheet().getForwardHistory(), this.getWorksheet().getBackwardHistory());
    }

    @FXML
    protected void handleRefresh(ActionEvent actionEvent) {
        this.refresh();
    }

    @FXML
    protected void handleRemoveSeries(ActionEvent actionEvent) {
        this.removeSelectedBinding((TableView<TimeSeriesInfo<Double>>)((TableView)actionEvent.getSource()));
    }

    @FXML
    protected void handleTakeSnapshot(ActionEvent actionEvent) {
        this.saveSnapshot();
    }

    void invalidateAll(boolean saveToHistory, boolean dontPlotChart, boolean forceRefresh) {
        if (saveToHistory) {
            this.getWorksheet().getBackwardHistory().push(this.getWorksheet().getPreviousState());
            this.getWorksheet().getForwardHistory().clear();
        }
        this.getWorksheet().setPreviousState(this.currentState.asSelection());
        logger.debug(() -> this.getWorksheet().getBackwardHistory().dump());
        for (ChartViewPort<Double> viewPort : this.viewPorts) {
            this.invalidate(viewPort, dontPlotChart, forceRefresh);
        }
    }

    void invalidate(ChartViewPort<Double> viewPort, boolean dontPlot, boolean forceRefresh) {
        try (Profiler p = Profiler.start("Refreshing chart " + this.getWorksheet().getName() + "\\" + viewPort.getDataStore().getName() + " (dontPlot=" + dontPlot + ")", arg_0 -> ((Logger)logger).trace(arg_0));){
            this.currentState.get(viewPort.getDataStore()).ifPresent(y -> {
                XYChartSelection<ZonedDateTime, Double> currentSelection = y.asSelection();
                logger.debug(() -> "currentSelection=" + (currentSelection == null ? "null" : currentSelection.toString()));
                if (!dontPlot) {
                    this.plotChart(viewPort, currentSelection, forceRefresh);
                }
            });
        }
    }

    private void plotChart(ChartViewPort<Double> viewPort, XYChartSelection<ZonedDateTime, Double> currentSelection, boolean forceRefresh) {
        try (Profiler p = Profiler.start("Adding series to chart " + viewPort.getDataStore().getName(), arg_0 -> ((Logger)logger).trace(arg_0));){
            this.worksheetMaskerPane.setVisible(true);
            AsyncTaskManager.getInstance().submit(() -> {
                viewPort.getDataStore().fetchDataFromSources((ZonedDateTime)currentSelection.getStartX(), (ZonedDateTime)currentSelection.getEndX(), forceRefresh);
                return viewPort.getDataStore().getSeries().stream().filter(series -> {
                    if (series.getProcessor() == null) {
                        logger.warn("Series " + series.getDisplayName() + " does not contain any data to plot");
                        return false;
                    }
                    if (!series.isSelected()) {
                        logger.debug(() -> "Series " + series.getDisplayName() + " is not selected");
                        return false;
                    }
                    return true;
                }).map(ts -> this.makeXYChartSeries(viewPort.getDataStore(), (TimeSeriesInfo<Double>)ts)).collect(Collectors.toList());
            }, (EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                if (!this.closed.get()) {
                    this.worksheetMaskerPane.setVisible(false);
                    viewPort.getChart().getData().setAll((Collection)event.getSource().getValue());
                    new DelayedAction(() -> viewPort.getChart().resize(0.0, 0.0), Duration.millis((double)50.0)).submit();
                }
            }), (EventHandler<WorkerStateEvent>)((EventHandler)event -> {
                if (!this.closed.get()) {
                    this.worksheetMaskerPane.setVisible(false);
                    Dialogs.notifyException("Failed to retrieve data from source", event.getSource().getException(), (Node)this.root);
                }
            }));
        }
    }

    private void abortIfClosed() {
    }

    private XYChart.Series<ZonedDateTime, Double> makeXYChartSeries(Chart<Double> currentChart, TimeSeriesInfo<Double> series) {
        try (Profiler p = Profiler.start("Building  XYChart.Series data for" + series.getDisplayName(), arg_0 -> ((Logger)logger).trace(arg_0));){
            XYChart.Series newSeries = new XYChart.Series();
            newSeries.getData().setAll(series.getProcessor().getData());
            newSeries.nodeProperty().addListener((node, oldNode, newNode) -> {
                if (newNode != null) {
                    switch (currentChart.getChartType()) {
                        case AREA: 
                        case STACKED: {
                            ObservableList children = ((Group)newNode).getChildren();
                            if (children == null || children.size() < 1) break;
                            Path stroke = (Path)children.get(1);
                            Path fill = (Path)children.get(0);
                            logger.trace(() -> "Setting color of series " + series.getBinding().getLabel() + " to " + series.getDisplayColor());
                            stroke.visibleProperty().bind((ObservableValue)currentChart.showAreaOutlineProperty());
                            stroke.strokeWidthProperty().bind((ObservableValue)currentChart.strokeWidthProperty());
                            stroke.strokeProperty().bind(series.displayColorProperty());
                            fill.fillProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> series.getDisplayColor().deriveColor(0.0, 1.0, 1.0, currentChart.getGraphOpacity()), (Observable[])new Observable[]{series.displayColorProperty(), currentChart.graphOpacityProperty()}));
                            break;
                        }
                        case SCATTER: {
                            break;
                        }
                        case LINE: {
                            Path stroke = (Path)newNode;
                            logger.trace(() -> "Setting color of series " + series.getBinding().getLabel() + " to " + series.getDisplayColor());
                            stroke.strokeWidthProperty().bind((ObservableValue)currentChart.strokeWidthProperty());
                            stroke.strokeProperty().bind(series.displayColorProperty());
                            break;
                        }
                    }
                }
            });
            XYChart.Series series2 = newSeries;
            return series2;
        }
    }

    private void saveSnapshot() {
        WritableImage snapImg = this.root.snapshot(null, null);
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Save SnapShot");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Image Files", new String[]{"*.png"}));
        fileChooser.setInitialDirectory(this.globalPrefs.getMostRecentSaveFolder().toFile());
        fileChooser.setInitialFileName(String.format("binjr_snapshot_%s.png", this.getWorksheet().getName()));
        File selectedFile = fileChooser.showSaveDialog((Window)Dialogs.getStage((Node)this.root));
        if (selectedFile != null) {
            try {
                if (selectedFile.getParent() != null) {
                    this.globalPrefs.setMostRecentSaveFolder(selectedFile.toPath());
                }
                ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)snapImg, null), "png", selectedFile);
            }
            catch (IOException e) {
                Dialogs.notifyException("Failed to save snapshot to disk", e, (Node)this.root);
            }
        }
    }

    private void restoreSelectionFromHistory(WorksheetNavigationHistory history, WorksheetNavigationHistory toHistory) {
        if (!history.isEmpty()) {
            toHistory.push(this.currentState.asSelection());
            this.currentState.setSelection(history.pop(), false);
        } else {
            logger.debug(() -> "History is empty: nothing to go back to.");
        }
    }

    private TableRow<TimeSeriesInfo<Double>> seriesTableRowFactory(TableView<TimeSeriesInfo<Double>> tv) {
        TableRow row = new TableRow();
        row.setOnDragDetected(event -> {
            if (!row.isEmpty()) {
                Integer index = row.getIndex();
                Dragboard db = row.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
                db.setDragView((Image)row.snapshot(null, null));
                ClipboardContent cc = new ClipboardContent();
                cc.put((Object)SERIALIZED_MIME_TYPE, (Object)index);
                db.setContent((Map)cc);
                event.consume();
            }
        });
        row.setOnDragOver(event -> {
            Dragboard db = event.getDragboard();
            if (db.hasContent(SERIALIZED_MIME_TYPE) && row.getIndex() != ((Integer)db.getContent(SERIALIZED_MIME_TYPE)).intValue()) {
                event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                event.consume();
            }
        });
        row.setOnDragDropped(event -> {
            Dragboard db = event.getDragboard();
            if (db.hasContent(SERIALIZED_MIME_TYPE)) {
                int draggedIndex = (Integer)db.getContent(SERIALIZED_MIME_TYPE);
                TimeSeriesInfo draggedseries = (TimeSeriesInfo)tv.getItems().remove(draggedIndex);
                int dropIndex = row.isEmpty() ? tv.getItems().size() : row.getIndex();
                tv.getItems().add(dropIndex, (Object)draggedseries);
                event.setDropCompleted(true);
                tv.getSelectionModel().clearAndSelect(dropIndex);
                this.invalidateAll(false, false, false);
                event.consume();
            }
        });
        return row;
    }

    public void toggleShowPropertiesPane() {
        ChartViewPort<Double> currentViewport = this.viewPorts.get(this.worksheet.getSelectedChart());
        if (currentViewport != null) {
            currentViewport.getDataStore().setShowProperties(this.editButtonsGroup.getSelectedToggle() == null);
        }
    }

    public void setShowPropertiesPane(boolean value) {
        ChartViewPort<Double> currentViewport = this.viewPorts.get(this.worksheet.getSelectedChart());
        if (currentViewport != null) {
            currentViewport.getDataStore().setShowProperties(value);
        }
    }

    protected void finalize() throws Throwable {
        logger.trace(() -> "Finalizing worksheet controller: " + this.toString());
        super.finalize();
    }
}

