/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.controllers;

import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.util.javafx.charts.XYChartSelection;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorksheetNavigationHistory {
    private static final Logger logger = LogManager.getLogger(WorksheetNavigationHistory.class);
    private final Deque<Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>>> stack = new ArrayDeque<Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>>>();
    private final SimpleBooleanProperty empty = new SimpleBooleanProperty(true);

    void push(Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> state) {
        if (state == null) {
            logger.warn(() -> "Trying to push null state into backwardHistory");
            return;
        }
        this.empty.set(false);
        this.stack.push(state);
    }

    void clear() {
        this.stack.clear();
        this.empty.set(true);
    }

    Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> pop() {
        Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> r = this.stack.pop();
        this.empty.set(this.stack.isEmpty());
        return r;
    }

    boolean isEmpty() {
        return this.empty.get();
    }

    BooleanProperty emptyProperty() {
        return this.empty;
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("History:");
        AtomicInteger pos = new AtomicInteger(0);
        if (this.isEmpty()) {
            sb.append(" { empty }");
        } else {
            this.stack.forEach(h -> sb.append("\n").append(pos.incrementAndGet()).append(" ->").append(h.entrySet().stream().map(e -> ((Chart)e.getKey()).getName() + ": " + ((XYChartSelection)e.getValue()).toString()).collect(Collectors.joining(" "))));
        }
        return sb.toString();
    }
}

