/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.DataAdapterInfo;
import eu.fthevenet.binjr.dialogs.DataAdapterDialog;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.util.version.Version;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class BaseDataAdapterInfo
implements DataAdapterInfo {
    private final String name;
    private final String description;
    private final Version version;
    private final String copyright;
    private final String license;
    private final String jarLocation;
    private final String siteUrl;
    private final Class<? extends DataAdapter> adapterClass;
    private final Class<? extends DataAdapterDialog> adapterDialog;
    private BooleanProperty enabled = new SimpleBooleanProperty(true);

    protected BaseDataAdapterInfo(String name, String description, String copyright, String license, String siteUrl, Class<? extends DataAdapter> adapterClass, Class<? extends DataAdapterDialog> dialogClass) {
        this(name, description, null, copyright, license, siteUrl, adapterClass, dialogClass);
    }

    protected BaseDataAdapterInfo(String name, String description, Version version, String copyright, String license, String siteUrl, Class<? extends DataAdapter> adapterClass, Class<? extends DataAdapterDialog> dialogClass) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(description);
        Objects.requireNonNull(copyright);
        Objects.requireNonNull(license);
        Objects.requireNonNull(siteUrl);
        Objects.requireNonNull(adapterClass);
        Objects.requireNonNull(dialogClass);
        this.name = name;
        this.description = description;
        this.copyright = copyright;
        this.license = license;
        this.siteUrl = siteUrl;
        this.adapterClass = adapterClass;
        this.adapterDialog = dialogClass;
        this.version = version == null ? AppEnvironment.getInstance().getVersion(adapterClass) : version;
        this.jarLocation = adapterClass.getResource('/' + adapterClass.getName().replace('.', '/') + ".class").toExternalForm();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<? extends DataAdapter> getAdapterClass() {
        return this.adapterClass;
    }

    @Override
    public String getKey() {
        return this.adapterClass.getName();
    }

    @Override
    public Class<? extends DataAdapterDialog> getAdapterDialog() {
        return this.adapterDialog;
    }

    @Override
    public BooleanProperty enabledProperty() {
        return this.enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public String getJarLocation() {
        return this.jarLocation;
    }

    @Override
    public String getSiteUrl() {
        return this.siteUrl;
    }
}

