/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.adapters;

import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.codec.Decoder;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.data.exceptions.InvalidAdapterParameterException;
import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.util.function.CheckedFunction;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javafx.scene.control.TreeItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DataAdapter<T, A extends Decoder<T>>
implements AutoCloseable {
    private static final Logger logger = LogManager.getLogger(DataAdapter.class);
    private UUID id = UUID.randomUUID();
    protected volatile boolean closed = false;

    public abstract TreeItem<TimeSeriesBinding<T>> getBindingTree() throws DataAdapterException;

    public abstract InputStream fetchRawData(String var1, Instant var2, Instant var3, boolean var4) throws DataAdapterException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> fetchDecodedData(String path, Instant begin, Instant end, List<TimeSeriesInfo<T>> seriesInfo, boolean bypassCache) throws DataAdapterException {
        if (this.closed) {
            throw new IllegalStateException("An attempt was made to fetch data from a closed adapter");
        }
        try (InputStream in = this.fetchRawData(path, begin, end, bypassCache);){
            Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> map = this.getDecoder().decode(in, seriesInfo);
            return map;
        }
        catch (IOException e) {
            throw new DataAdapterException("Error recovering data from source", e);
        }
    }

    public abstract String getEncoding();

    public abstract ZoneId getTimeZoneId();

    public abstract A getDecoder();

    public abstract String getSourceName();

    public abstract Map<String, String> getParams();

    public abstract void loadParams(Map<String, String> var1) throws DataAdapterException;

    public void onStart() throws DataAdapterException {
    }

    public abstract boolean ping();

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    protected String validateParameterNullity(Map<String, String> params, String paramName) throws InvalidAdapterParameterException {
        return this.validateParameter(params, paramName, s -> {
            if (s == null) {
                throw new InvalidAdapterParameterException("Parameter " + paramName + " is missing for adapter " + this.getSourceName());
            }
            return s;
        });
    }

    protected <R> R validateParameter(Map<String, String> params, String paramName, CheckedFunction<String, R, InvalidAdapterParameterException> validator) throws InvalidAdapterParameterException {
        String paramValue = params.get(paramName);
        return validator.apply(paramValue);
    }

    @Override
    public void close() {
        logger.trace("Closing DataAdapter " + this.getId());
        this.closed = true;
    }

    public String toString() {
        return "DataAdapter{id=" + this.id + "sourceName" + this.getSourceName() + '}';
    }

    public boolean isClosed() {
        return this.closed;
    }
}

