/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.DataAdapterInfo;
import eu.fthevenet.binjr.data.exceptions.CannotInitializeDataAdapterException;
import eu.fthevenet.binjr.data.exceptions.NoAdapterFoundException;
import eu.fthevenet.binjr.dialogs.DataAdapterDialog;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javafx.scene.Node;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataAdapterFactory {
    private static final Logger logger = LogManager.getLogger(DataAdapterFactory.class);
    private final Map<String, DataAdapterInfo> registeredAdapters = new HashMap<String, DataAdapterInfo>();

    private DataAdapterFactory() {
        this.loadAdapters();
    }

    public static DataAdapterFactory getInstance() {
        return DataAdapterFactoryHolder.instance;
    }

    public Collection<DataAdapterInfo> getActiveAdapters() {
        return this.registeredAdapters.values().stream().filter(DataAdapterInfo::isEnabled).collect(Collectors.toList());
    }

    public Collection<DataAdapterInfo> getAllAdapters() {
        return this.registeredAdapters.values();
    }

    public DataAdapter<?, ?> newAdapter(DataAdapterInfo info) throws NoAdapterFoundException, CannotInitializeDataAdapterException {
        return this.newAdapter(info.getKey());
    }

    public DataAdapterDialog getDialog(String key, Node root) throws NoAdapterFoundException, CannotInitializeDataAdapterException {
        try {
            return this.retrieveAdapterInfo(key).getAdapterDialog().getDeclaredConstructor(Node.class).newInstance(root);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CannotInitializeDataAdapterException("Could not create instance of DataAdapterDialog for " + key, e);
        }
    }

    public DataAdapter<?, ?> newAdapter(String key) throws NoAdapterFoundException, CannotInitializeDataAdapterException {
        try {
            return this.retrieveAdapterInfo(key).getAdapterClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CannotInitializeDataAdapterException("Could not create instance of adapter " + key, e);
        }
    }

    private void loadAdapters() {
        final ArrayList urls = new ArrayList();
        if (GlobalPreferences.getInstance().isLoadPluginsFromExternalLocation()) {
            if (Files.exists(GlobalPreferences.getInstance().getPluginsLocation(), new LinkOption[0])) {
                logger.info(() -> "Looking for plugins in " + GlobalPreferences.getInstance().getPluginsLocation());
                final PathMatcher jarMatcher = FileSystems.getDefault().getPathMatcher("glob:**.jar");
                try {
                    Files.walkFileTree(GlobalPreferences.getInstance().getPluginsLocation(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            if (jarMatcher.matches(file)) {
                                logger.debug(() -> "Inspecting " + file.getFileName() + " for DataAdapter service implementations");
                                urls.add(file.toUri().toURL());
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    logger.error("Error while scanning for plugins: " + e.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Error stack", (Throwable)e);
                    }
                }
            } else {
                logger.warn("Plugins location " + GlobalPreferences.getInstance().getPluginsLocation() + " does not exist.");
            }
        }
        Iterator<DataAdapterInfo> adapterInfoIterator = ServiceLoader.load(DataAdapterInfo.class, new URLClassLoader(urls.toArray(new URL[0]))).iterator();
        while (adapterInfoIterator.hasNext()) {
            try {
                DataAdapterInfo adapterInfo = adapterInfoIterator.next();
                this.registeredAdapters.put(adapterInfo.getKey(), adapterInfo);
                logger.debug(() -> "Successfully registered DataAdapterInfo " + adapterInfo.toString() + " from external JAR.");
            }
            catch (ServiceConfigurationError sce) {
                logger.error("Failed to load DataAdapter", (Throwable)sce);
            }
            catch (Exception e) {
                logger.error("Unexpected error while loading DataAdapter", (Throwable)e);
            }
        }
    }

    private DataAdapterInfo retrieveAdapterInfo(String key) throws NoAdapterFoundException {
        DataAdapterInfo info = this.registeredAdapters.get(Objects.requireNonNull(key, "The parameter 'key' cannot be null!"));
        if (info == null) {
            throw new NoAdapterFoundException("Could not find a registered adapter for key " + key);
        }
        return info;
    }

    private static class DataAdapterFactoryHolder {
        private static final DataAdapterFactory instance = new DataAdapterFactory();

        private DataAdapterFactoryHolder() {
        }
    }
}

