/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.adapters;

import eu.fthevenet.binjr.data.adapters.SimpleCachingDataAdapter;
import eu.fthevenet.binjr.data.codec.Decoder;
import eu.fthevenet.binjr.data.exceptions.CannotInitializeDataAdapterException;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.data.exceptions.FetchingDataFromAdapterException;
import eu.fthevenet.binjr.data.exceptions.InvalidAdapterParameterException;
import eu.fthevenet.binjr.data.exceptions.SourceCommunicationException;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.util.logging.Profiler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.AbstractResponseHandler;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class HttpDataAdapterBase<T, A extends Decoder<T>>
extends SimpleCachingDataAdapter<T, A> {
    private static final Logger logger = LogManager.getLogger(HttpDataAdapterBase.class);
    protected static final String BASE_ADDRESS_PARAM_NAME = "baseUri";
    private final CloseableHttpClient httpClient;
    private URL baseAddress;

    public HttpDataAdapterBase() throws CannotInitializeDataAdapterException {
        this.httpClient = this.httpClientFactory();
    }

    public HttpDataAdapterBase(URL baseAddress) throws CannotInitializeDataAdapterException {
        this.baseAddress = baseAddress;
        this.httpClient = this.httpClientFactory();
    }

    @Override
    public byte[] onCacheMiss(String path, Instant begin, Instant end) throws DataAdapterException {
        return (byte[])this.doHttpGet(this.craftFetchUri(path, begin, end), (ResponseHandler)new AbstractResponseHandler<byte[]>(){

            public byte[] handleEntity(HttpEntity entity) throws IOException {
                return EntityUtils.toByteArray((HttpEntity)entity);
            }
        });
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(BASE_ADDRESS_PARAM_NAME, this.baseAddress.toString());
        return params;
    }

    @Override
    public void loadParams(Map<String, String> params) throws DataAdapterException {
        if (params == null) {
            throw new InvalidAdapterParameterException("Could not find parameter list for adapter " + this.getSourceName());
        }
        this.baseAddress = this.validateParameter(params, BASE_ADDRESS_PARAM_NAME, s -> {
            if (s == null) {
                throw new InvalidAdapterParameterException("Parameter baseUri is missing in adapter " + this.getSourceName());
            }
            try {
                this.baseAddress = new URL((String)s);
                return this.baseAddress;
            }
            catch (MalformedURLException e) {
                throw new InvalidAdapterParameterException("Value provided for parameter baseUri is not valid in adapter " + this.getSourceName(), e);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            logger.error("Error closing HttpDataAdapterBase", (Throwable)e);
        }
        super.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <R> R doHttpGet(URI requestUri, ResponseHandler<R> responseHandler) throws DataAdapterException {
        try (Profiler p = Profiler.start("Executing HTTP request: [" + requestUri.toString() + "]", arg_0 -> ((Logger)logger).trace(arg_0));){
            logger.debug(() -> "requestUri = " + requestUri);
            HttpGet httpget = new HttpGet(requestUri);
            httpget.setHeader("User-Agent", "binjr/" + AppEnvironment.getInstance().getVersion() + " (Authenticates like: Firefox/Safari/Internet Explorer)");
            Object result = this.httpClient.execute((HttpUriRequest)httpget, responseHandler);
            if (result == null) {
                throw new FetchingDataFromAdapterException("Response entity to \"" + requestUri.toString() + "\" is null.");
            }
            Object object = result;
            return (R)object;
        }
        catch (HttpResponseException e) {
            String msg;
            switch (e.getStatusCode()) {
                case 401: {
                    msg = "Authentication failed while trying to access \"" + requestUri.toString() + "\"";
                    throw new SourceCommunicationException(msg, e);
                }
                case 403: {
                    msg = "Access to the resource at \"" + requestUri.toString() + "\" is denied.";
                    throw new SourceCommunicationException(msg, e);
                }
                case 404: {
                    msg = "The resource at \"" + requestUri.toString() + "\" could not be found.";
                    throw new SourceCommunicationException(msg, e);
                }
                case 500: {
                    msg = "A server-side error has occurred while trying to access the resource at \"" + requestUri.toString() + "\": " + e.getMessage();
                    throw new SourceCommunicationException(msg, e);
                }
            }
            msg = "Error executing HTTP request \"" + requestUri.toString() + "\": " + e.getMessage();
            throw new SourceCommunicationException(msg, e);
        }
        catch (ConnectException e) {
            throw new SourceCommunicationException(e.getMessage(), e);
        }
        catch (UnknownHostException e) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("Host \"").append(this.baseAddress.getHost());
            if (this.baseAddress.getPort() > 0) {
                string = ":" + this.baseAddress.getPort();
                throw new SourceCommunicationException(stringBuilder.append(string).append("\" could not be found.").toString(), e);
            }
            string = "";
            throw new SourceCommunicationException(stringBuilder.append(string).append("\" could not be found.").toString(), e);
        }
        catch (IOException e) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("IO error while communicating with host \"").append(this.baseAddress.getHost());
            if (this.baseAddress.getPort() > 0) {
                string = ":" + this.baseAddress.getPort();
                throw new SourceCommunicationException(stringBuilder.append(string).append("\"").toString(), e);
            }
            string = "";
            throw new SourceCommunicationException(stringBuilder.append(string).append("\"").toString(), e);
        }
        catch (Exception e) {
            throw new SourceCommunicationException("Unexpected error in HTTP GET", e);
        }
    }

    protected static SSLContext createSslCustomContext() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException, NoSuchProviderException {
        KeyStore tks;
        logger.trace(() -> "Available Java Security providers: " + Arrays.toString(Security.getProviders()));
        switch (AppEnvironment.getInstance().getOsFamily()) {
            case WINDOWS: {
                tks = KeyStore.getInstance("Windows-ROOT", "SunMSCAPI");
                tks.load(null, null);
                break;
            }
            case OSX: {
                tks = KeyStore.getInstance("KeychainStore", "Apple");
                tks.load(null, null);
                break;
            }
            default: {
                tks = null;
            }
        }
        return SSLContexts.custom().loadTrustMaterial(tks, null).build();
    }

    protected CloseableHttpClient httpClientFactory() throws CannotInitializeDataAdapterException {
        try {
            SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(HttpDataAdapterBase.createSslCustomContext(), null, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            RegistryBuilder schemeProviderBuilder = RegistryBuilder.create();
            schemeProviderBuilder.register("Negotiate", (Object)new SPNegoSchemeFactory());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(null, -1, null), new Credentials(){

                public Principal getUserPrincipal() {
                    return null;
                }

                public String getPassword() {
                    return null;
                }
            });
            return HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)schemeProviderBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setSSLSocketFactory((LayeredConnectionSocketFactory)csf).build();
        }
        catch (Exception e) {
            throw new CannotInitializeDataAdapterException("Could not initialize adapter to source '" + this.getSourceName() + "': " + e.getMessage(), e);
        }
    }

    protected URI craftRequestUri(String path, List<NameValuePair> params) throws SourceCommunicationException {
        Objects.requireNonNull(path);
        try {
            ArrayList<String> res = new ArrayList<String>(Arrays.asList(this.getBaseAddress().getPath().split("/")));
            res.addAll(Arrays.asList(path.split("/")));
            String sanitizedPath = res.stream().filter(s -> !s.isEmpty()).reduce("", (p, e) -> p + "/" + e);
            URIBuilder builder = new URIBuilder(this.getBaseAddress().toURI().resolve(sanitizedPath));
            if (params != null) {
                builder.addParameters(params);
            }
            return builder.build();
        }
        catch (URISyntaxException e2) {
            throw new SourceCommunicationException("Error building URI for request", e2);
        }
    }

    protected URI craftRequestUri(String path, NameValuePair ... params) throws SourceCommunicationException {
        return this.craftRequestUri(path, params != null ? Arrays.asList(params) : null);
    }

    protected abstract URI craftFetchUri(String var1, Instant var2, Instant var3) throws DataAdapterException;

    public URL getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(URL baseAddress) {
        this.baseAddress = baseAddress;
    }
}

