/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.codec.Decoder;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.util.cache.LRUMapCapacityBound;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.time.Instant;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SimpleCachingDataAdapter<T, A extends Decoder<T>>
extends DataAdapter<T, A> {
    public static final int DEFAULT_CACHE_SIZE = 128;
    private static final Logger logger = LogManager.getLogger(SimpleCachingDataAdapter.class);
    private final Map<String, SoftReference<byte[]>> cache;

    public SimpleCachingDataAdapter() {
        this(128);
    }

    public SimpleCachingDataAdapter(int maxCacheEntries) {
        this.cache = new LRUMapCapacityBound<String, SoftReference<byte[]>>(maxCacheEntries);
    }

    @Override
    public InputStream fetchRawData(String path, Instant begin, Instant end, boolean bypassCache) throws DataAdapterException {
        byte[] payload = null;
        String cacheEntryKey = String.format("%s%d%d", path, begin.toEpochMilli(), end.toEpochMilli());
        if (!bypassCache) {
            SoftReference<byte[]> cacheHit = this.cache.get(cacheEntryKey);
            byte[] byArray = payload = cacheHit != null ? cacheHit.get() : null;
        }
        if (payload == null) {
            logger.trace(() -> String.format("%s for entry %s %s %s", bypassCache ? "Cache was explicitly bypassed" : "Cache miss", path, begin.toString(), end.toString()));
            payload = this.onCacheMiss(path, begin, end);
            this.cache.put(cacheEntryKey, new SoftReference<byte[]>(payload));
        } else {
            logger.trace(() -> String.format("Data successfully retrieved from cache for %s %s %s", path, begin.toString(), end.toString()));
        }
        return new ByteArrayInputStream(payload);
    }

    public abstract byte[] onCacheMiss(String var1, Instant var2, Instant var3) throws DataAdapterException;

    @Override
    public void close() {
        try {
            this.cache.clear();
        }
        catch (Exception e) {
            logger.error("Error closing SimpleCacheAdapter", (Throwable)e);
        }
        super.close();
    }
}

