/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.workspace.ChartType;
import eu.fthevenet.binjr.data.workspace.UnitPrefixes;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javafx.scene.paint.Color;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="Binding")
public class TimeSeriesBinding<T> {
    private static final Logger logger = LogManager.getLogger(TimeSeriesBinding.class);
    private static final ThreadLocal<MessageDigest> messageDigest = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.fatal("Failed to instantiate MD5 message digest");
            throw new IllegalStateException("Failed to create a new instance of Md5HashTargetResolver", e);
        }
    });
    private static final Color[] defaultChartColors = new Color[]{Color.LIGHTBLUE, Color.LIGHTCORAL, Color.LIGHTCYAN, Color.LIGHTGRAY, Color.LIGHTGREEN, Color.LEMONCHIFFON, Color.LAVENDER, Color.LIGHTPINK, Color.LIGHTSALMON, Color.LIGHTSEAGREEN, Color.LIGHTSKYBLUE, Color.LIGHTSLATEGRAY, Color.LIGHTSTEELBLUE, Color.LIGHTYELLOW, Color.MEDIUMBLUE, Color.MEDIUMORCHID, Color.MEDIUMPURPLE, Color.MEDIUMSEAGREEN, Color.MEDIUMSPRINGGREEN, Color.MEDIUMTURQUOISE, Color.MEDIUMVIOLETRED, Color.MINTCREAM};
    @XmlAttribute(name="sourceId")
    private final UUID adapterId;
    @XmlAttribute
    private final String label;
    @XmlAttribute
    private final String path;
    @XmlAttribute
    private final Color color;
    @XmlAttribute
    private final String legend;
    @XmlAttribute
    private final UnitPrefixes prefix;
    @XmlAttribute
    private final ChartType graphType;
    @XmlAttribute
    private final String unitName;
    @XmlAttribute
    private final String treeHierarchy;
    @XmlTransient
    private DataAdapter<T, ?> adapter;

    public TimeSeriesBinding() {
        this.label = "";
        this.path = "";
        this.color = null;
        this.legend = "";
        this.prefix = UnitPrefixes.BINARY;
        this.graphType = ChartType.STACKED;
        this.unitName = "";
        this.adapter = null;
        this.treeHierarchy = "";
        this.adapterId = null;
    }

    public TimeSeriesBinding(TimeSeriesBinding<T> binding) {
        this(binding.label, binding.path, binding.color, binding.legend, binding.prefix, binding.graphType, binding.unitName, binding.treeHierarchy, null, binding.adapterId);
    }

    public TimeSeriesBinding(String label, String path, Color color, String legend, UnitPrefixes prefix, ChartType graphType, String unitName, String treeHierarchy, DataAdapter<T, ?> adapter) {
        this(label, path, color, legend, prefix, graphType, unitName, treeHierarchy, adapter, null);
    }

    private TimeSeriesBinding(String label, String path, Color color, String legend, UnitPrefixes prefix, ChartType graphType, String unitName, String treeHierarchy, DataAdapter<T, ?> adapter, UUID adapterId) {
        this.label = label;
        this.path = path;
        this.legend = legend;
        this.prefix = prefix;
        this.graphType = graphType;
        this.unitName = unitName;
        this.treeHierarchy = treeHierarchy;
        this.adapter = adapter;
        UUID id = adapterId;
        if (id == null && adapter != null) {
            id = adapter.getId();
        }
        this.adapterId = id;
        this.color = color == null ? this.computeDefaultColor() : color;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPath() {
        return this.path;
    }

    @XmlTransient
    public DataAdapter<T, ?> getAdapter() {
        return this.adapter;
    }

    public void setAdapter(DataAdapter adapter) {
        this.adapter = adapter;
    }

    public Color getColor() {
        return this.color;
    }

    public String getLegend() {
        return this.legend;
    }

    public ChartType getGraphType() {
        return this.graphType;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public UnitPrefixes getUnitPrefix() {
        return this.prefix;
    }

    public UUID getAdapterId() {
        return this.adapterId;
    }

    public String getTreeHierarchy() {
        return this.treeHierarchy;
    }

    public String toString() {
        return this.getLegend();
    }

    private Color computeDefaultColor() {
        long targetNum = this.getHashValue(this.getTreeHierarchy()) % (long)defaultChartColors.length;
        if (targetNum < 0L) {
            targetNum *= -1L;
        }
        return defaultChartColors[(int)targetNum];
    }

    private long getHashValue(String value) {
        messageDigest.get().update(value.getBytes(Charset.forName("UTF-8")));
        long hashVal = new BigInteger(1, messageDigest.get().digest()).longValue();
        return hashVal;
    }
}

