/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.async;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncTaskManager {
    private static final Logger logger = LogManager.getLogger(AsyncTaskManager.class);
    private final ExecutorService threadPool;

    private AsyncTaskManager() {
        ThreadFactory threadFactory = new ThreadFactory(){
            final AtomicInteger threadNum = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("binjr-async-thread-" + this.threadNum.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
        this.threadPool = Executors.newCachedThreadPool(threadFactory);
    }

    public static AsyncTaskManager getInstance() {
        return AsyncTaskManagerHolder.instance;
    }

    public <V> Future<?> submit(Task<V> task) {
        logger.trace(() -> "Task " + task.toString() + " submitted");
        return this.threadPool.submit((Runnable)task);
    }

    public <V> Future<?> submit(final Callable<V> action, EventHandler<WorkerStateEvent> onSucceeded, EventHandler<WorkerStateEvent> onFailed) {
        Task t = new Task<V>(){

            protected V call() throws Exception {
                return action.call();
            }
        };
        t.setOnSucceeded(onSucceeded);
        t.setOnFailed(onFailed);
        logger.trace(() -> AsyncTaskManager.lambda$submit$1((Task)t));
        return this.threadPool.submit((Runnable)t);
    }

    private static /* synthetic */ Object lambda$submit$1(Task t) {
        return "Task " + t.toString() + " submitted";
    }

    private static class AsyncTaskManagerHolder {
        private static final AsyncTaskManager instance = new AsyncTaskManager();

        private AsyncTaskManagerHolder() {
        }
    }
}

