/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.codec;

import eu.fthevenet.binjr.data.codec.DataSample;
import eu.fthevenet.binjr.data.codec.Decoder;
import eu.fthevenet.binjr.data.exceptions.DecodingDataFromAdapterException;
import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessorFactory;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.util.function.CheckedFunction;
import eu.fthevenet.util.logging.Profiler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvDecoder<T extends Number>
implements Decoder<T> {
    private final String encoding;
    private final char delimiter;
    private final CheckedFunction<String, T, DecodingDataFromAdapterException> numberParser;
    private final CheckedFunction<String, ZonedDateTime, DecodingDataFromAdapterException> dateParser;
    private final TimeSeriesProcessorFactory<T> timeSeriesFactory;
    private static final Logger logger = LogManager.getLogger(CsvDecoder.class);

    public CsvDecoder(String encoding, char delimiter, TimeSeriesProcessorFactory<T> timeSeriesFactory, CheckedFunction<String, T, DecodingDataFromAdapterException> numberParser, CheckedFunction<String, ZonedDateTime, DecodingDataFromAdapterException> dateParser) {
        this.encoding = encoding;
        this.delimiter = delimiter;
        this.timeSeriesFactory = timeSeriesFactory;
        this.numberParser = numberParser;
        this.dateParser = dateParser;
    }

    public List<String> getDataColumnHeaders(InputStream in) throws IOException, DecodingDataFromAdapterException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.encoding));){
            CSVFormat csvFormat = CSVFormat.DEFAULT.withAllowMissingColumnNames(false).withDelimiter(this.delimiter);
            CSVParser records = csvFormat.parse((Reader)reader);
            List<String> list = this.parseColumnHeaders((CSVRecord)records.iterator().next());
            return list;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> decode(InputStream in, List<TimeSeriesInfo<T>> seriesInfo) throws IOException, DecodingDataFromAdapterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void decode(InputStream in, List<String> headers, Consumer<DataSample<T>> mapToResult) throws IOException, DecodingDataFromAdapterException {
        try (Profiler ignored = Profiler.start("Building time series from csv data", arg_0 -> ((Logger)logger).trace(arg_0));
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.encoding));){
            CSVFormat csvFormat = CSVFormat.DEFAULT.withAllowMissingColumnNames(false).withFirstRecordAsHeader().withSkipHeaderRecord().withDelimiter(this.delimiter);
            CSVParser records = csvFormat.parse((Reader)reader);
            for (CSVRecord csvRecord : records) {
                ZonedDateTime timeStamp = this.dateParser.apply(csvRecord.get(0));
                DataSample tRecord = new DataSample(timeStamp);
                for (String h : headers) {
                    tRecord.getCells().put(h, this.numberParser.apply(csvRecord.get(h)));
                }
                mapToResult.accept(tRecord);
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public CheckedFunction<String, T, DecodingDataFromAdapterException> getNumberParser() {
        return this.numberParser;
    }

    public CheckedFunction<String, ZonedDateTime, DecodingDataFromAdapterException> getDateParser() {
        return this.dateParser;
    }

    private List<String> parseColumnHeaders(CSVRecord record) throws IOException, DecodingDataFromAdapterException {
        try (Profiler ignored = Profiler.start("Getting hearders from csv data", arg_0 -> ((Logger)logger).trace(arg_0));){
            if (record == null) {
                throw new DecodingDataFromAdapterException("CSV stream does not contains column header");
            }
            ArrayList<String> headerNames = new ArrayList<String>();
            for (int i = 1; i < record.size(); ++i) {
                headerNames.add(record.get(i));
            }
            ArrayList<String> arrayList = headerNames;
            return arrayList;
        }
    }

    private TimeSeriesInfo<T> getBindingFromName(List<TimeSeriesInfo<T>> seriesInfo, String seriesName) {
        if (seriesInfo != null) {
            for (TimeSeriesInfo<T> b : seriesInfo) {
                if (!b.getBinding().getLabel().equalsIgnoreCase(seriesName)) continue;
                return b;
            }
        }
        return null;
    }

    private static /* synthetic */ Object lambda$decode$1(List seriesInfo, AtomicLong nbpoints) {
        return String.format("Built %d series with %d samples each (%d total samples)", seriesInfo.size(), nbpoints.get(), (long)seriesInfo.size() * nbpoints.get());
    }

    private /* synthetic */ TimeSeriesProcessor lambda$decode$0(TimeSeriesInfo k) {
        return this.timeSeriesFactory.create();
    }
}

