/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.dirtyable;

import eu.fthevenet.binjr.data.dirtyable.Dirtyable;
import eu.fthevenet.binjr.data.dirtyable.IsDirtyable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.NONE)
public class ChangeWatcher
implements Dirtyable {
    private static final Logger logger = LogManager.getLogger(ChangeWatcher.class);
    private final BooleanProperty dirty = new SimpleBooleanProperty(false);
    private final List<ObservableList<? extends Dirtyable>> watchedLists;
    private final ChangeListener<Boolean> dirtyableChangeListener = (observable, oldValue, newValue) -> {
        if (newValue.booleanValue()) {
            this.forceDirty();
        }
    };

    public ChangeWatcher(Object source) {
        this.watchedLists = new ArrayList<ObservableList<? extends Dirtyable>>();
        List<Field> toWatch = this.getFieldsListWithAnnotation(source.getClass(), IsDirtyable.class);
        block2: for (Field field : toWatch) {
            try {
                ParameterizedType pType;
                Type[] types;
                Object fieldValue = this.readField(field, source);
                if (fieldValue instanceof Property) {
                    ((Property)fieldValue).addListener((observable, oldValue, newValue) -> this.forceDirty());
                }
                if (!(fieldValue instanceof ObservableList) || (types = (pType = (ParameterizedType)field.getGenericType()).getActualTypeArguments()) == null) continue;
                for (Type type : types) {
                    if (type instanceof ParameterizedType) {
                        type = ((ParameterizedType)type).getRawType();
                    }
                    if (!Dirtyable.class.isAssignableFrom((Class)type)) continue;
                    ObservableList ol = (ObservableList)fieldValue;
                    this.watchedLists.add((ObservableList<? extends Dirtyable>)ol);
                    ListChangeListener listChangeListener = c -> {
                        while (c.next()) {
                            if (c.wasAdded()) {
                                if (c.getAddedSize() > 0) {
                                    this.forceDirty();
                                }
                                for (Dirtyable dirtyable : c.getAddedSubList()) {
                                    this.evaluateDirty(dirtyable.isDirty());
                                    dirtyable.dirtyProperty().addListener(this.dirtyableChangeListener);
                                }
                            }
                            if (!c.wasRemoved()) continue;
                            if (c.getRemovedSize() > 0) {
                                this.forceDirty();
                            }
                            for (Dirtyable dirtyable : c.getRemoved()) {
                                dirtyable.dirtyProperty().removeListener(this.dirtyableChangeListener);
                            }
                        }
                    };
                    ol.addListener(listChangeListener);
                    continue block2;
                }
            }
            catch (ClassCastException | IllegalAccessException e) {
                logger.error("Error reflecting dirtyable properties", (Throwable)e);
            }
        }
    }

    @Override
    public BooleanProperty dirtyProperty() {
        return this.dirty;
    }

    @Override
    public Boolean isDirty() {
        return this.dirty.getValue();
    }

    @Override
    public void cleanUp() {
        this.dirty.setValue(Boolean.valueOf(false));
        this.watchedLists.forEach(l -> l.forEach(Dirtyable::cleanUp));
    }

    private void evaluateDirty(Boolean isDirty) {
        this.dirty.setValue(Boolean.valueOf(this.dirty.getValue() | isDirty));
    }

    private void forceDirty() {
        this.dirty.setValue(Boolean.valueOf(true));
    }

    private Object readField(Field field, Object target) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field.get(target);
    }

    private List<Field> getFieldsListWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationCls) {
        if (annotationCls == null) {
            throw new IllegalArgumentException("The annotation class must not be null");
        }
        List<Field> allFields = this.getAllFieldsList(cls);
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        for (Field field : allFields) {
            if (field.getAnnotation(annotationCls) == null) continue;
            annotatedFields.add(field);
        }
        return annotatedFields;
    }

    private List<Field> getAllFieldsList(Class<?> cls) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields = currentClass.getDeclaredFields();
            allFields.addAll(Arrays.asList(declaredFields));
        }
        return allFields;
    }
}

