/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.timeseries;

import eu.fthevenet.util.concurrent.ReadWriteLockHelper;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.scene.chart.XYChart;

public abstract class TimeSeriesProcessor<T> {
    private final ReadWriteLockHelper monitor = new ReadWriteLockHelper();
    protected List<XYChart.Data<ZonedDateTime, T>> data = new ArrayList<XYChart.Data<ZonedDateTime, T>>();

    public final T getMinValue() {
        return (T)this.monitor.read().lock(this::computeMinValue);
    }

    public final T getAverageValue() {
        return (T)this.monitor.read().lock(this::computeAverageValue);
    }

    public final T getMaxValue() {
        return (T)this.monitor.read().lock(this::computeMaxValue);
    }

    public Optional<T> tryGetNearestValue(ZonedDateTime xValue) {
        return this.monitor.read().tryLock(this::unsafeGetNearestValue, xValue);
    }

    public T getNearestValue(ZonedDateTime xValue) {
        return (T)this.monitor.read().lock(this::unsafeGetNearestValue, xValue);
    }

    public Collection<XYChart.Data<ZonedDateTime, T>> getData() {
        return this.monitor.read().lock(() -> new ArrayList<XYChart.Data<ZonedDateTime, T>>(this.data));
    }

    public void setData(Collection<XYChart.Data<ZonedDateTime, T>> newData) {
        this.monitor.write().lock(() -> {
            this.data = new ArrayList<XYChart.Data<ZonedDateTime, T>>(newData);
            return this.data;
        });
    }

    public XYChart.Data<ZonedDateTime, T> getSample(int index) {
        return this.monitor.read().lock(() -> this.data.get(index));
    }

    public int size() {
        return this.monitor.read().lock(() -> this.data.size());
    }

    public void addSample(XYChart.Data<ZonedDateTime, T> sample) {
        this.monitor.write().lock(() -> this.data.add(sample));
    }

    protected abstract T computeMinValue();

    protected abstract T computeAverageValue();

    protected abstract T computeMaxValue();

    private T unsafeGetNearestValue(ZonedDateTime xValue) {
        Object value = null;
        if (xValue != null && this.data != null) {
            for (XYChart.Data<ZonedDateTime, T> sample : this.data) {
                value = sample.getYValue();
                if (!xValue.isBefore((ChronoZonedDateTime)sample.getXValue())) continue;
                return (T)value;
            }
        }
        return (T)value;
    }
}

