/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.timeseries.transform;

import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import eu.fthevenet.binjr.data.timeseries.transform.TimeSeriesTransform;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.chart.XYChart;

public class DecimationTransform<T>
extends TimeSeriesTransform<T> {
    private final int threshold;

    public DecimationTransform(int threshold) {
        super("DecimationTransform");
        this.threshold = threshold;
    }

    @Override
    public Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> apply(Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> m) {
        return m.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, o -> {
            if (this.threshold > 0 && ((TimeSeriesProcessor)o.getValue()).size() > this.threshold) {
                ((TimeSeriesProcessor)o.getValue()).setData(this.decimate((TimeSeriesProcessor)o.getValue(), this.threshold));
            }
            return (TimeSeriesProcessor)o.getValue();
        }));
    }

    private Collection<XYChart.Data<ZonedDateTime, T>> decimate(TimeSeriesProcessor<T> data, int threshold) {
        int dataLength = data.size();
        ArrayList<XYChart.Data<ZonedDateTime, T>> sampled = new ArrayList<XYChart.Data<ZonedDateTime, T>>(threshold);
        double every = (double)(dataLength - 2) / (double)(threshold - 2);
        sampled.add(data.getSample(0));
        for (int i = 1; i < threshold - 1; ++i) {
            sampled.add(data.getSample(Math.min(dataLength - 1, (int)Math.round((double)i * every))));
        }
        sampled.add(data.getSample(dataLength - 1));
        return sampled;
    }
}

