/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.timeseries.transform;

import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import eu.fthevenet.binjr.data.timeseries.transform.TimeSeriesTransform;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.chart.XYChart;

public class LargestTriangleThreeBucketsTransform
extends TimeSeriesTransform<Double> {
    private final int threshold;

    public LargestTriangleThreeBucketsTransform(int threshold) {
        super("LargestTriangleThreeBucketsTransform");
        this.threshold = threshold;
    }

    @Override
    public Map<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>> apply(Map<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>> m) {
        return m.entrySet().parallelStream().collect(Collectors.toMap(Map.Entry::getKey, o -> {
            if (this.threshold > 0 && ((TimeSeriesProcessor)o.getValue()).size() > this.threshold) {
                ((TimeSeriesProcessor)o.getValue()).setData(this.applyLTTBReduction((TimeSeriesProcessor)o.getValue(), this.threshold));
            }
            return (TimeSeriesProcessor)o.getValue();
        }));
    }

    private Collection<XYChart.Data<ZonedDateTime, Double>> applyLTTBReduction(TimeSeriesProcessor<Double> data, int threshold) {
        int dataLength = data.size();
        ArrayList<XYChart.Data<ZonedDateTime, Double>> sampled = new ArrayList<XYChart.Data<ZonedDateTime, Double>>(threshold);
        double every = (double)(dataLength - 2) / (double)(threshold - 2);
        int a = 0;
        int nextA = 0;
        XYChart.Data<ZonedDateTime, Double> maxAreaPoint = data.getSample(a);
        sampled.add(data.getSample(a));
        for (int i = 0; i < threshold - 2; ++i) {
            int avgRangeStart;
            double avgX = 0.0;
            double avgY = 0.0;
            int avgRangeEnd = (int)(Math.floor((double)(i + 2) * every) + 1.0);
            avgRangeEnd = avgRangeEnd < dataLength ? avgRangeEnd : dataLength;
            int avgRangeLength = avgRangeEnd - avgRangeStart;
            for (avgRangeStart = (int)(Math.floor((double)(i + 1) * every) + 1.0); avgRangeStart < avgRangeEnd; ++avgRangeStart) {
                avgX += (double)((ZonedDateTime)data.getSample(avgRangeStart).getXValue()).toEpochSecond();
                avgY += ((Double)data.getSample(avgRangeStart).getYValue()).doubleValue();
            }
            avgX /= (double)avgRangeLength;
            avgY /= (double)avgRangeLength;
            int rangeTo = (int)(Math.floor((double)(i + 1) * every) + 1.0);
            double pointAx = ((ZonedDateTime)data.getSample(a).getXValue()).toEpochSecond();
            double pointAy = (Double)data.getSample(a).getYValue();
            double maxArea = -1.0;
            for (int rangeOffs = (int)(Math.floor((double)i * every) + 1.0); rangeOffs < rangeTo; ++rangeOffs) {
                double area = Math.abs((pointAx - avgX) * ((Double)data.getSample(rangeOffs).getYValue() - pointAy) - (pointAx - (double)((ZonedDateTime)data.getSample(rangeOffs).getXValue()).toEpochSecond()) * (avgY - pointAy)) * 0.5;
                if (!(area > maxArea)) continue;
                maxArea = area;
                maxAreaPoint = data.getSample(rangeOffs);
                nextA = rangeOffs;
            }
            sampled.add(maxAreaPoint);
            a = nextA;
        }
        sampled.add(data.getSample(dataLength - 1));
        return sampled;
    }
}

