/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.timeseries.transform;

import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.util.logging.Profiler;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TimeSeriesTransform<T> {
    private static final Logger logger = LogManager.getLogger(TimeSeriesTransform.class);
    private final String name;

    public TimeSeriesTransform(String name) {
        this.name = name;
    }

    protected abstract Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> apply(Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> var1);

    public Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> transform(Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> series, boolean enabled) {
        String names = series.keySet().stream().map(tTimeSeriesInfo -> tTimeSeriesInfo.getBinding().getLabel()).reduce((s, s2) -> s + " " + s2).orElse("null");
        if (enabled) {
            try (Profiler ignored = Profiler.start("Applying transform" + this.getName() + " to series " + names, arg_0 -> ((Logger)logger).trace(arg_0));){
                Map<TimeSeriesInfo<T>, TimeSeriesProcessor<T>> map = this.apply(series);
                return map;
            }
        }
        logger.debug(() -> "Transform " + this.getName() + " on series " + names + " is disabled.");
        return series;
    }

    public String getName() {
        return this.name;
    }
}

