/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.workspace;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.dirtyable.ChangeWatcher;
import eu.fthevenet.binjr.data.dirtyable.Dirtyable;
import eu.fthevenet.binjr.data.dirtyable.IsDirtyable;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.data.timeseries.transform.DecimationTransform;
import eu.fthevenet.binjr.data.workspace.ChartType;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.binjr.data.workspace.UnitPrefixes;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="Chart")
public class Chart<T>
implements Dirtyable,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(Chart.class);
    private static final AtomicInteger globalCounter = new AtomicInteger(0);
    @IsDirtyable
    private ObservableList<TimeSeriesInfo<T>> series;
    @IsDirtyable
    private Property<String> name;
    @IsDirtyable
    private Property<String> unit;
    @IsDirtyable
    private Property<UnitPrefixes> unitPrefixes;
    @IsDirtyable
    private Property<ChartType> chartType;
    @IsDirtyable
    private DoubleProperty graphOpacity;
    @IsDirtyable
    private BooleanProperty showAreaOutline;
    @IsDirtyable
    private DoubleProperty strokeWidth;
    @IsDirtyable
    private BooleanProperty autoScaleYAxis;
    @IsDirtyable
    private DoubleProperty yAxisMinValue;
    @IsDirtyable
    private DoubleProperty yAxisMaxValue;
    private BooleanProperty showProperties;
    private final ChangeWatcher status;

    public Chart() {
        this("New Chart (" + globalCounter.getAndIncrement() + ")", ChartType.STACKED, (List<TimeSeriesInfo<T>>)FXCollections.observableList(new LinkedList()), "-", UnitPrefixes.METRIC, GlobalPreferences.getInstance().getDefaultGraphOpacity(), GlobalPreferences.getInstance().isShowAreaOutline(), 1.0, true, 0.0, 100.0);
    }

    public Chart(String name, ChartType chartType, String unitName, UnitPrefixes prefix) {
        this(name, chartType, (List<TimeSeriesInfo<T>>)FXCollections.observableList(new LinkedList()), unitName, prefix, GlobalPreferences.getInstance().getDefaultGraphOpacity(), GlobalPreferences.getInstance().isShowAreaOutline(), 1.0, true, 0.0, 100.0);
    }

    public Chart(Chart<T> initChart) {
        this(initChart.getName(), initChart.getChartType(), (List)initChart.getSeries().stream().map(TimeSeriesInfo::new).collect(Collectors.toCollection(() -> FXCollections.observableList(new LinkedList()))), initChart.getUnit(), initChart.getUnitPrefixes(), initChart.getGraphOpacity(), initChart.isShowAreaOutline(), initChart.getStrokeWidth(), initChart.isAutoScaleYAxis(), initChart.getyAxisMinValue(), initChart.getyAxisMaxValue());
    }

    private Chart(String name, ChartType chartType, List<TimeSeriesInfo<T>> bindings, String unitName, UnitPrefixes base, double graphOpacity, boolean showAreaOutline, double strokeWidth, boolean autoScaleYAxis, double yAxisMinValue, double yAxisMaxValue) {
        this.name = new SimpleStringProperty(name);
        this.unit = new SimpleStringProperty(unitName);
        this.chartType = new SimpleObjectProperty((Object)chartType);
        this.series = FXCollections.observableList(new LinkedList<TimeSeriesInfo<T>>(bindings));
        this.unitPrefixes = new SimpleObjectProperty((Object)base);
        this.graphOpacity = new SimpleDoubleProperty(graphOpacity);
        this.showAreaOutline = new SimpleBooleanProperty(showAreaOutline);
        this.strokeWidth = new SimpleDoubleProperty(strokeWidth);
        this.autoScaleYAxis = new SimpleBooleanProperty(autoScaleYAxis);
        this.yAxisMinValue = new SimpleDoubleProperty(yAxisMinValue);
        this.yAxisMaxValue = new SimpleDoubleProperty(yAxisMaxValue);
        this.showProperties = new SimpleBooleanProperty(false);
        this.status = new ChangeWatcher(this);
    }

    public void fetchDataFromSources(ZonedDateTime startTime, ZonedDateTime endTime, boolean bypassCache) throws DataAdapterException {
        this.series.removeIf(seriesInfo -> {
            if (seriesInfo.getBinding().getAdapter().isClosed()) {
                logger.debug(() -> seriesInfo.getDisplayName() + " will be pruned because attached adapter " + seriesInfo.getBinding().getAdapter().getId() + " is closed.");
                return true;
            }
            return false;
        });
        DecimationTransform reducer = new DecimationTransform(GlobalPreferences.getInstance().getDownSamplingThreshold());
        Map<DataAdapter, List<TimeSeriesInfo>> bindingsByAdapters = this.getSeries().stream().collect(Collectors.groupingBy(o -> o.getBinding().getAdapter()));
        for (Map.Entry<DataAdapter, List<TimeSeriesInfo>> byAdapterEntry : bindingsByAdapters.entrySet()) {
            DataAdapter adapter = byAdapterEntry.getKey();
            Map<String, List<TimeSeriesInfo>> bindingsByPath = byAdapterEntry.getValue().stream().collect(Collectors.groupingBy(o -> o.getBinding().getPath()));
            for (Map.Entry<String, List<TimeSeriesInfo>> byPathEntry : bindingsByPath.entrySet()) {
                String path = byPathEntry.getKey();
                Map data = adapter.fetchDecodedData(path, startTime.toInstant(), endTime.toInstant(), byPathEntry.getValue(), bypassCache);
                data = reducer.transform(data, GlobalPreferences.getInstance().getDownSamplingEnabled());
                for (TimeSeriesInfo seriesInfo2 : data.keySet()) {
                    seriesInfo2.setProcessor(data.get(seriesInfo2));
                }
            }
        }
    }

    public void addSeries(TimeSeriesInfo<T> seriesInfo) {
        this.series.add(seriesInfo);
    }

    public void addSeries(Collection<TimeSeriesInfo<T>> seriesInfo) {
        this.series.addAll(seriesInfo);
    }

    public void removeSeries(Collection<TimeSeriesInfo> seriesInfo) {
        this.series.removeAll(seriesInfo);
    }

    public void clearSeries() {
        this.series.clear();
    }

    @XmlAttribute
    public String getName() {
        return (String)this.name.getValue();
    }

    public Property<String> nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.setValue((Object)name);
    }

    @XmlElementWrapper(name="SeriesList")
    @XmlElements(value={@XmlElement(name="Timeseries")})
    public ObservableList<TimeSeriesInfo<T>> getSeries() {
        return this.series;
    }

    @XmlAttribute
    public ChartType getChartType() {
        return (ChartType)((Object)this.chartType.getValue());
    }

    public Property<ChartType> chartTypeProperty() {
        return this.chartType;
    }

    public void setChartType(ChartType chartType) {
        this.chartType.setValue((Object)chartType);
    }

    @XmlAttribute
    public String getUnit() {
        return (String)this.unit.getValue();
    }

    public Property<String> unitProperty() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit.setValue((Object)unit);
    }

    @XmlAttribute
    public UnitPrefixes getUnitPrefixes() {
        return (UnitPrefixes)((Object)this.unitPrefixes.getValue());
    }

    public Property<UnitPrefixes> unitPrefixesProperty() {
        return this.unitPrefixes;
    }

    public void setUnitPrefixes(UnitPrefixes unitPrefixes) {
        this.unitPrefixes.setValue((Object)unitPrefixes);
    }

    @XmlAttribute
    public double getGraphOpacity() {
        return this.graphOpacity.get();
    }

    public DoubleProperty graphOpacityProperty() {
        return this.graphOpacity;
    }

    public void setGraphOpacity(double graphOpacity) {
        this.graphOpacity.set(graphOpacity);
    }

    @XmlAttribute
    public boolean isShowAreaOutline() {
        return this.showAreaOutline.get();
    }

    public BooleanProperty showAreaOutlineProperty() {
        return this.showAreaOutline;
    }

    public void setShowAreaOutline(boolean showAreaOutline) {
        this.showAreaOutline.set(showAreaOutline);
    }

    public DoubleProperty strokeWidthProperty() {
        return this.strokeWidth;
    }

    @XmlAttribute
    public double getStrokeWidth() {
        return this.strokeWidth.get();
    }

    public void setStrokeWidth(double value) {
        this.strokeWidth.setValue((Number)value);
    }

    public String toString() {
        return String.format("%s - %s", this.getName(), this.getChartType().toString());
    }

    @Override
    @XmlTransient
    public Boolean isDirty() {
        return this.status.isDirty();
    }

    @Override
    public BooleanProperty dirtyProperty() {
        return this.status.dirtyProperty();
    }

    @Override
    public void cleanUp() {
        this.status.cleanUp();
    }

    @Override
    public void close() {
        this.series.clear();
    }

    @XmlAttribute
    public boolean isAutoScaleYAxis() {
        return this.autoScaleYAxis.get();
    }

    public BooleanProperty autoScaleYAxisProperty() {
        return this.autoScaleYAxis;
    }

    public void setAutoScaleYAxis(boolean autoScaleYAxis) {
        this.autoScaleYAxis.set(autoScaleYAxis);
    }

    @XmlAttribute
    public double getyAxisMinValue() {
        return this.yAxisMinValue.get();
    }

    public DoubleProperty yAxisMinValueProperty() {
        return this.yAxisMinValue;
    }

    public void setyAxisMinValue(double yAxisMinValue) {
        this.yAxisMinValue.set(yAxisMinValue);
    }

    @XmlAttribute
    public double getyAxisMaxValue() {
        return this.yAxisMaxValue.get();
    }

    public DoubleProperty yAxisMaxValueProperty() {
        return this.yAxisMaxValue;
    }

    public void setyAxisMaxValue(double yAxisMaxValue) {
        this.yAxisMaxValue.set(yAxisMaxValue);
    }

    @XmlTransient
    public boolean isShowProperties() {
        return this.showProperties.get();
    }

    public BooleanProperty showPropertiesProperty() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties.set(showProperties);
    }
}

