/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.workspace;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.dirtyable.ChangeWatcher;
import eu.fthevenet.binjr.data.dirtyable.Dirtyable;
import eu.fthevenet.binjr.data.dirtyable.IsDirtyable;
import eu.fthevenet.binjr.data.workspace.ParameterMapAdapter;
import eu.fthevenet.util.javafx.bindings.BindingManager;
import java.io.Closeable;
import java.util.Map;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="Source")
public class Source
implements Dirtyable,
Closeable {
    private UUID adapterId;
    @IsDirtyable
    private Property<String> name = new SimpleStringProperty();
    private String adapterClassName;
    private Map<String, String> adapterParams;
    private final ChangeWatcher status;
    private DataAdapter adapter;
    private final BindingManager bindingManager = new BindingManager();
    private Property<Boolean> editable = new SimpleBooleanProperty();

    public static Source of(DataAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("adapter cannot be null");
        }
        Source newSource = new Source();
        newSource.setAdapter(adapter);
        newSource.setName(adapter.getSourceName());
        newSource.setAdapterClassName(adapter.getClass().getName());
        newSource.setAdapterParams(adapter.getParams());
        newSource.setAdapterId(adapter.getId());
        return newSource;
    }

    public Source() {
        this.status = new ChangeWatcher(this);
    }

    @XmlAttribute(name="name")
    public String getName() {
        return (String)this.name.getValue();
    }

    public void setName(String name) {
        this.name.setValue((Object)name);
    }

    public Property<String> nameProperty() {
        return this.name;
    }

    @XmlAttribute(name="adapter")
    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    @XmlJavaTypeAdapter(value=ParameterMapAdapter.class)
    @XmlElement(name="AdapterParameters")
    public Map<String, String> getAdapterParams() {
        return this.adapterParams;
    }

    @XmlAttribute(name="id")
    public UUID getAdapterId() {
        return this.adapterId;
    }

    public void setAdapterId(UUID adapterId) {
        this.adapterId = adapterId;
    }

    @Override
    public Boolean isDirty() {
        return this.status.isDirty();
    }

    @Override
    public BooleanProperty dirtyProperty() {
        return this.status.dirtyProperty();
    }

    @Override
    public void cleanUp() {
        this.status.cleanUp();
    }

    private void setAdapterClassName(String adapterClassName) {
        this.adapterClassName = adapterClassName;
    }

    private void setAdapterParams(Map<String, String> adapterParams) {
        this.adapterParams = adapterParams;
    }

    @XmlTransient
    public DataAdapter getAdapter() {
        return this.adapter;
    }

    @XmlTransient
    public BindingManager getBindingManager() {
        return this.bindingManager;
    }

    @Override
    public void close() {
        this.bindingManager.close();
        this.adapter.close();
    }

    public void setAdapter(DataAdapter adapter) {
        this.adapter = adapter;
    }

    @XmlTransient
    public Boolean getEditable() {
        return (Boolean)this.editable.getValue();
    }

    public Property<Boolean> editableProperty() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable.setValue((Object)editable);
    }
}

