/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.workspace;

import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.dirtyable.ChangeWatcher;
import eu.fthevenet.binjr.data.dirtyable.Dirtyable;
import eu.fthevenet.binjr.data.dirtyable.IsDirtyable;
import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="Timeseries")
public class TimeSeriesInfo<T>
implements Dirtyable {
    @IsDirtyable
    private final StringProperty displayName;
    @IsDirtyable
    private final BooleanProperty selected;
    @IsDirtyable
    private final Property<Color> displayColor;
    @XmlElement(name="Binding", required=true, type=TimeSeriesBinding.class)
    private final TimeSeriesBinding<T> binding;
    private final ChangeWatcher status;
    private Property<TimeSeriesProcessor<T>> processor = new SimpleObjectProperty();

    private TimeSeriesInfo() {
        this("", true, null, null);
    }

    public TimeSeriesInfo(TimeSeriesInfo<T> seriesInfo) {
        this(seriesInfo.getDisplayName(), seriesInfo.isSelected(), seriesInfo.getDisplayColor(), seriesInfo.getBinding());
    }

    private TimeSeriesInfo(String displayName, Boolean selected, Color displayColor, TimeSeriesBinding<T> binding) {
        this.binding = binding;
        this.displayName = new SimpleStringProperty(displayName);
        this.selected = new SimpleBooleanProperty(selected.booleanValue());
        this.displayColor = new SimpleObjectProperty((Object)displayColor);
        this.status = new ChangeWatcher(this);
    }

    public static <T> TimeSeriesInfo<T> fromBinding(TimeSeriesBinding<T> binding) {
        if (binding == null) {
            throw new IllegalArgumentException("binding cannot be null");
        }
        return new TimeSeriesInfo<T>(binding.getLegend(), true, binding.getColor(), binding);
    }

    @XmlAttribute
    public String getDisplayName() {
        return (String)this.displayName.get();
    }

    public void setDisplayName(String displayName) {
        this.displayName.set((Object)displayName);
    }

    public StringProperty displayNameProperty() {
        return this.displayName;
    }

    @XmlAttribute
    public boolean isSelected() {
        return this.selected.get();
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public BooleanProperty selectedProperty() {
        return this.selected;
    }

    @XmlAttribute
    public Color getDisplayColor() {
        return (Color)this.displayColor.getValue();
    }

    public void setDisplayColor(Color displayColor) {
        this.displayColor.setValue((Object)displayColor);
    }

    public Property<Color> displayColorProperty() {
        return this.displayColor;
    }

    public TimeSeriesBinding<T> getBinding() {
        return this.binding;
    }

    @XmlTransient
    public TimeSeriesProcessor<T> getProcessor() {
        return (TimeSeriesProcessor)this.processor.getValue();
    }

    public void setProcessor(TimeSeriesProcessor<T> processor) {
        this.processor.setValue(processor);
    }

    public Property<TimeSeriesProcessor<T>> processorProperty() {
        return this.processor;
    }

    @Override
    @XmlTransient
    public Boolean isDirty() {
        return this.status.isDirty();
    }

    @Override
    public BooleanProperty dirtyProperty() {
        return this.status.dirtyProperty();
    }

    @Override
    public void cleanUp() {
        this.status.cleanUp();
    }
}

