/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.data.workspace;

import eu.fthevenet.binjr.controllers.WorksheetNavigationHistory;
import eu.fthevenet.binjr.data.dirtyable.ChangeWatcher;
import eu.fthevenet.binjr.data.dirtyable.Dirtyable;
import eu.fthevenet.binjr.data.dirtyable.IsDirtyable;
import eu.fthevenet.binjr.data.workspace.Chart;
import eu.fthevenet.binjr.data.workspace.ChartLayout;
import eu.fthevenet.util.javafx.charts.XYChartSelection;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@XmlRootElement(name="Worksheet")
public class Worksheet<T>
implements Dirtyable,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(Worksheet.class);
    private static final AtomicInteger globalCounter = new AtomicInteger(0);
    @IsDirtyable
    private ObservableList<Chart<T>> charts;
    @IsDirtyable
    private Property<String> name;
    @IsDirtyable
    private Property<ZoneId> timeZone;
    @IsDirtyable
    private Property<ZonedDateTime> fromDateTime;
    @IsDirtyable
    private Property<ZonedDateTime> toDateTime;
    @IsDirtyable
    private Property<ChartLayout> chartLayout;
    private Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> previousState;
    private final WorksheetNavigationHistory backwardHistory = new WorksheetNavigationHistory();
    private final WorksheetNavigationHistory forwardHistory = new WorksheetNavigationHistory();
    private Property<Integer> selectedChart;
    private final ChangeWatcher status;

    public Worksheet() {
        this("New Worksheet (" + globalCounter.getAndIncrement() + ")", (List<Chart<T>>)FXCollections.observableList(new LinkedList()), ZoneId.systemDefault(), ZonedDateTime.now().minus(24L, ChronoUnit.HOURS), ZonedDateTime.now());
    }

    public Worksheet(String name, ZonedDateTime fromDateTime, ZonedDateTime toDateTime, ZoneId timezone) {
        this(name, (List<Chart<T>>)FXCollections.observableList(new LinkedList()), timezone, fromDateTime, toDateTime);
    }

    public Worksheet(Worksheet<T> initWorksheet) {
        this(initWorksheet.getName(), (List)initWorksheet.getCharts().stream().map(Chart::new).collect(Collectors.toCollection(() -> FXCollections.observableList(new LinkedList()))), initWorksheet.getTimeZone(), initWorksheet.getFromDateTime(), initWorksheet.getToDateTime());
    }

    public Worksheet(String name, List<Chart<T>> charts, ZoneId timezone, ZonedDateTime fromDateTime, ZonedDateTime toDateTime) {
        this.name = new SimpleStringProperty(name);
        this.charts = FXCollections.observableList(new LinkedList<Chart<T>>(charts));
        if (this.charts.isEmpty()) {
            this.charts.add(new Chart());
        }
        this.timeZone = new SimpleObjectProperty((Object)timezone);
        this.fromDateTime = new SimpleObjectProperty((Object)fromDateTime);
        this.toDateTime = new SimpleObjectProperty((Object)toDateTime);
        this.selectedChart = new SimpleObjectProperty((Object)0);
        this.chartLayout = new SimpleObjectProperty((Object)ChartLayout.STACKED);
        this.status = new ChangeWatcher(this);
    }

    public Chart<T> getDefaultChart() {
        return (Chart)this.charts.get(0);
    }

    @XmlAttribute
    public String getName() {
        return (String)this.name.getValue();
    }

    public Property<String> nameProperty() {
        return this.name;
    }

    public void setName(String name) {
        this.name.setValue((Object)name);
    }

    @XmlAttribute
    public ZoneId getTimeZone() {
        return (ZoneId)this.timeZone.getValue();
    }

    public Property<ZoneId> timeZoneProperty() {
        return this.timeZone;
    }

    public void setTimeZone(ZoneId timeZone) {
        this.timeZone.setValue((Object)timeZone);
    }

    @XmlAttribute
    public ZonedDateTime getFromDateTime() {
        return (ZonedDateTime)this.fromDateTime.getValue();
    }

    public Property<ZonedDateTime> fromDateTimeProperty() {
        return this.fromDateTime;
    }

    public void setFromDateTime(ZonedDateTime fromDateTime) {
        this.fromDateTime.setValue((Object)fromDateTime);
    }

    @XmlAttribute
    public ZonedDateTime getToDateTime() {
        return (ZonedDateTime)this.toDateTime.getValue();
    }

    public Property<ZonedDateTime> toDateTimeProperty() {
        return this.toDateTime;
    }

    public void setToDateTime(ZonedDateTime toDateTime) {
        this.toDateTime.setValue((Object)toDateTime);
    }

    @XmlTransient
    public Integer getSelectedChart() {
        return (Integer)this.selectedChart.getValue();
    }

    public Property<Integer> selectedChartProperty() {
        return this.selectedChart;
    }

    public void setSelectedChart(Integer selectedChart) {
        this.selectedChart.setValue((Object)selectedChart);
    }

    @XmlElementWrapper(name="Charts")
    @XmlElements(value={@XmlElement(name="Chart")})
    public ObservableList<Chart<T>> getCharts() {
        return this.charts;
    }

    public void setCharts(ObservableList<Chart<T>> charts) {
        this.charts = charts;
    }

    public String toString() {
        return String.format("%s - %s", this.getName(), this.getTimeZone().toString());
    }

    @Override
    @XmlTransient
    public Boolean isDirty() {
        return this.status.isDirty();
    }

    @Override
    public BooleanProperty dirtyProperty() {
        return this.status.dirtyProperty();
    }

    @Override
    public void cleanUp() {
        this.status.cleanUp();
    }

    @Override
    public void close() {
        this.charts.forEach(Chart::close);
    }

    @XmlTransient
    public Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> getPreviousState() {
        return this.previousState;
    }

    public void setPreviousState(Map<Chart<Double>, XYChartSelection<ZonedDateTime, Double>> previousState) {
        this.previousState = previousState;
    }

    @XmlTransient
    public WorksheetNavigationHistory getBackwardHistory() {
        return this.backwardHistory;
    }

    @XmlTransient
    public WorksheetNavigationHistory getForwardHistory() {
        return this.forwardHistory;
    }

    @XmlAttribute
    public ChartLayout getChartLayout() {
        return (ChartLayout)((Object)this.chartLayout.getValue());
    }

    public Property<ChartLayout> chartLayoutProperty() {
        return this.chartLayout;
    }

    public void setChartLayout(ChartLayout chartLayout) {
        this.chartLayout.setValue((Object)chartLayout);
    }
}

