/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.dialogs;

import eu.fthevenet.binjr.controllers.OutputConsoleController;
import eu.fthevenet.binjr.dialogs.StageAppearanceManager;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsoleStage {
    private static final Logger logger = LogManager.getLogger(ConsoleStage.class);
    private final Stage stage;

    private ConsoleStage() {
        FXMLLoader loader = new FXMLLoader(OutputConsoleController.class.getResource("/views/OutputConsoleView.fxml"));
        Parent root = null;
        try {
            root = (Parent)loader.load();
        }
        catch (IOException e) {
            logger.error("Failed to show console windows", (Object)e.getMessage());
            logger.debug(() -> "Exception stack", (Throwable)e);
        }
        OutputConsoleController controller = (OutputConsoleController)loader.getController();
        Scene scene = new Scene(root);
        this.stage = new Stage();
        this.stage.setScene(scene);
        this.stage.setTitle("binjr console output");
        StageAppearanceManager.getInstance().register(this.stage);
        this.stage.initStyle(StageStyle.UTILITY);
        this.stage.show();
        this.stage.setOnCloseRequest(event -> {
            AppEnvironment.getInstance().setConsoleVisible(false);
            event.consume();
        });
        controller.getAlwaysOnTopToggle().selectedProperty().addListener((observable, oldValue, newValue) -> this.stage.setAlwaysOnTop(newValue.booleanValue()));
        controller.getAlwaysOnTopToggle().setSelected(true);
    }

    public static void show() {
        ConsoleStageHolder.instance.stage.show();
    }

    public static void hide() {
        ConsoleStageHolder.instance.stage.hide();
    }

    private static class ConsoleStageHolder {
        private static final ConsoleStage instance = new ConsoleStage();

        private ConsoleStageHolder() {
        }
    }
}

