/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.dialogs;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.exceptions.CannotInitializeDataAdapterException;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import java.io.File;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public abstract class DataAdapterDialog
extends Dialog<DataAdapter> {
    private static final Logger logger = LogManager.getLogger(DataAdapterDialog.class);
    private static final String BINJR_SOURCES = "binjr/sources";
    private final HBox uriHBox;
    private DataAdapter result = null;
    private AutoCompletionBinding<String> autoCompletionBinding;
    private final Set<String> suggestedUrls;
    protected final Button browseButton;
    protected final Label uriLabel;
    protected final TextField uriField;
    protected final TextField timezoneField;
    protected final DialogPane parent;
    protected final Button okButton;
    protected final GridPane paramsGridPane;

    public DataAdapterDialog(Node owner, Mode mode) {
        if (owner != null) {
            this.initOwner((Window)Dialogs.getStage(owner));
        }
        this.setTitle("Source");
        String mruKey = "mru_" + mode.toString();
        Preferences prefs = Preferences.userRoot().node(BINJR_SOURCES);
        this.suggestedUrls = new HashSet<String>(Arrays.asList(prefs.get(mruKey, "").split(" ")));
        FXMLLoader fXMLLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/views/DataAdapterView.fxml"));
        try {
            this.parent = (DialogPane)fXMLLoader.load();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to load /views/DataAdapterView.fxml", e);
        }
        this.setDialogPane(this.parent);
        this.browseButton = (Button)this.parent.lookup("#browseButton");
        this.uriLabel = (Label)this.parent.lookup("#uriLabel");
        this.uriField = (TextField)this.parent.lookup("#uriField");
        this.timezoneField = (TextField)this.parent.lookup("#timezoneField");
        this.paramsGridPane = (GridPane)this.parent.lookup("#paramsGridPane");
        this.uriHBox = (HBox)this.parent.lookup("#uriHBox");
        if (mode == Mode.URL) {
            this.browseButton.setPrefWidth(0.0);
            this.uriHBox.setSpacing(0.0);
            this.uriLabel.setText("Address:");
        } else {
            this.browseButton.setPrefWidth(-1.0);
            this.uriLabel.setText("Path:");
        }
        this.browseButton.setOnAction(event -> {
            File selectedFile = this.displayFileChooser((Node)event.getSource());
            if (selectedFile != null) {
                this.uriField.setText(selectedFile.getPath());
            }
        });
        this.okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
        Platform.runLater(() -> ((TextField)this.uriField).requestFocus());
        this.autoCompletionBinding = TextFields.bindAutoCompletion((TextField)this.uriField, this.suggestedUrls);
        this.okButton.addEventFilter(ActionEvent.ACTION, ae -> {
            try {
                ZoneId zoneId = ZoneId.of(this.timezoneField.getText());
                this.result = this.getDataAdapter();
                this.autoCompletionLearnWord(this.uriField);
            }
            catch (DateTimeException e) {
                Dialogs.notifyError("Invalid Timezone", e, Pos.CENTER, (Node)this.timezoneField);
                ae.consume();
            }
            catch (CannotInitializeDataAdapterException e) {
                Dialogs.notifyError("Error initializing adapter to source", e, Pos.CENTER, (Node)this.timezoneField);
                ae.consume();
            }
            catch (DataAdapterException e) {
                Dialogs.notifyError("Error with the adapter to source", e, Pos.CENTER, (Node)this.timezoneField);
                ae.consume();
            }
            catch (Exception e) {
                Dialogs.notifyError("Unexpected error while retrieving data adapter", e, Pos.CENTER, (Node)this.timezoneField);
                ae.consume();
            }
        });
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data;
            ButtonBar.ButtonData buttonData = data = dialogButton == null ? null : dialogButton.getButtonData();
            if (data == ButtonBar.ButtonData.OK_DONE) {
                this.suggestedUrls.stream().reduce((s, s2) -> s + " " + s2).ifPresent(s -> prefs.put(mruKey, (String)s));
                return this.result;
            }
            return null;
        });
        TextFields.bindAutoCompletion((TextField)this.timezoneField, ZoneId.getAvailableZoneIds());
        this.timezoneField.setText(ZoneId.systemDefault().toString());
    }

    protected abstract DataAdapter<?, ?> getDataAdapter() throws DataAdapterException;

    protected File displayFileChooser(Node owner) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open");
        fileChooser.setInitialDirectory(GlobalPreferences.getInstance().getMostRecentSaveFolder().toFile());
        return fileChooser.showOpenDialog((Window)Dialogs.getStage(owner));
    }

    private void autoCompletionLearnWord(TextField field) {
        this.suggestedUrls.add(field.getText());
        if (this.autoCompletionBinding != null) {
            this.autoCompletionBinding.dispose();
        }
        this.autoCompletionBinding = TextFields.bindAutoCompletion((TextField)field, this.suggestedUrls);
    }

    protected static enum Mode {
        PATH,
        URL;

    }
}

