/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.dialogs;

import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.action.Action;
import org.controlsfx.dialog.ExceptionDialog;

public class Dialogs {
    private static final Logger logger = LogManager.getLogger(Dialogs.class);

    public static void notifyException(Throwable e) {
        Dialogs.notifyException(e.getMessage(), e, null);
    }

    public static void notifyException(String header, Throwable e) {
        Dialogs.notifyException(header, e, null);
    }

    public static void notifyException(String title, Throwable e, Node owner) {
        logger.error(title + " - " + e.getMessage());
        if (logger.isDebugEnabled()) {
            logger.debug(title, e);
        }
        Dialogs.runOnFXThread(() -> Notifications.create().title(title).text(e.getMessage()).hideAfter(GlobalPreferences.getInstance().getNotificationPopupDuration()).position(Pos.BOTTOM_RIGHT).action(new Action[]{new Action("Details", ae -> Dialogs.displayException(title, e, owner))}).owner((Object)owner).showError());
    }

    public static void displayException(String header, Throwable e, Node owner) {
        Dialogs.runOnFXThread(() -> {
            ExceptionDialog dlg = new ExceptionDialog(e);
            dlg.initStyle(StageStyle.UTILITY);
            dlg.initOwner((Window)Dialogs.getStage(owner));
            dlg.getDialogPane().setHeaderText(header);
            dlg.showAndWait();
        });
    }

    public static void notifyError(String title, String message, Pos position, Node owner) {
        logger.error(title + " - " + message);
        Dialogs.runOnFXThread(() -> Notifications.create().title(title).text(message).hideAfter(GlobalPreferences.getInstance().getNotificationPopupDuration()).position(position).owner((Object)owner).showError());
    }

    public static void notifyError(String title, Exception e, Pos position, Node owner) {
        logger.debug(() -> title, (Throwable)e);
        Dialogs.notifyError(title, e.getMessage(), position, owner);
    }

    public static void notifyWarning(String title, String message, Pos position, Node owner) {
        logger.warn(title + " - " + message);
        Dialogs.runOnFXThread(() -> Notifications.create().title(title).text(message).hideAfter(GlobalPreferences.getInstance().getNotificationPopupDuration()).position(position).owner((Object)owner).showWarning());
    }

    public static void notifyInfo(String title, String message, Pos position, Node owner) {
        logger.info(title + " - " + message);
        Dialogs.runOnFXThread(() -> Notifications.create().title(title).text(message).hideAfter(GlobalPreferences.getInstance().getNotificationPopupDuration()).position(position).owner((Object)owner).showInformation());
    }

    public static Stage getStage(Node node) {
        if (node != null && node.getScene() != null) {
            return (Stage)node.getScene().getWindow();
        }
        return null;
    }

    public static void launchUrlInExternalBrowser(String url) throws IOException, URISyntaxException {
        switch (AppEnvironment.getInstance().getOsFamily()) {
            case WINDOWS: {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.BROWSE)) {
                        desktop.browse(new URI(url));
                        break;
                    }
                    logger.warn("Action Desktop.Action.BROWSE is not supported on this platform");
                    break;
                }
                logger.warn("java.awt.Desktop is not supported on this platform");
                break;
            }
            case LINUX: {
                if (Runtime.getRuntime().exec(new String[]{"which", "xdg-open"}).getInputStream().read() != -1) {
                    Runtime.getRuntime().exec(new String[]{"xdg-open", url});
                    break;
                }
                logger.warn("Failed to find location for xdg-open");
                break;
            }
            case OSX: {
                if (Runtime.getRuntime().exec(new String[]{"which", "open"}).getInputStream().read() != -1) {
                    Runtime.getRuntime().exec(new String[]{"open", url});
                    break;
                }
                logger.warn("Failed to find location for open");
                break;
            }
            default: {
                logger.error("Cannot launch a url in a browser on this system");
            }
        }
    }

    public static ButtonType confirmSaveDialog(Node node, String fileName) {
        String msg = "Workspace \"" + fileName + "\" contains unsaved modifications.";
        Region icon = new Region();
        icon.getStyleClass().addAll((Object[])new String[]{"dialog-icon", "fileSave-icon"});
        return Dialogs.confirmDialog(node, msg, "Save the changes?", (Node)icon, ButtonType.YES, ButtonType.NO, ButtonType.CANCEL);
    }

    public static ButtonType confirmDialog(Node node, String header, String content, ButtonType ... buttons) {
        return Dialogs.confirmDialog(node, header, content, null, buttons);
    }

    public static ButtonType confirmDialog(Node node, String header, String content, Node icon, ButtonType ... buttons) {
        Dialog dlg = new Dialog();
        dlg.initOwner((Window)Dialogs.getStage(node));
        Dialogs.setAlwaysOnTop(dlg);
        dlg.setTitle("binjr");
        dlg.getDialogPane().setHeaderText(header);
        dlg.getDialogPane().setContentText(content);
        if (icon == null) {
            icon = new Region();
            icon.getStyleClass().addAll((Object[])new String[]{"dialog-icon", "help-icon"});
        }
        dlg.getDialogPane().setGraphic(icon);
        if (buttons == null || buttons.length == 0) {
            buttons = new ButtonType[]{ButtonType.YES, ButtonType.NO};
        }
        dlg.getDialogPane().getButtonTypes().addAll((Object[])buttons);
        return dlg.showAndWait().orElse(ButtonType.CANCEL);
    }

    public static void runOnFXThread(Runnable r) {
        if (Platform.isFxApplicationThread()) {
            r.run();
        } else {
            Platform.runLater((Runnable)r);
        }
    }

    public static void setAlwaysOnTop(Dialog dialog) {
        if (dialog == null) {
            throw new IllegalArgumentException("Dialog cannot be null");
        }
        Stage dlgStage = Dialogs.getStage((Node)dialog.getDialogPane());
        if (dlgStage != null) {
            dlgStage.setAlwaysOnTop(true);
        } else {
            logger.debug("Failed to retrieve dialog's stage: cannot set dialog to be always on top");
        }
    }
}

