/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.dialogs;

import eu.fthevenet.binjr.data.workspace.ChartType;
import eu.fthevenet.binjr.data.workspace.UnitPrefixes;
import eu.fthevenet.binjr.data.workspace.Worksheet;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.util.javafx.controls.ZonedDateTimePicker;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.controlsfx.control.textfield.TextFields;

public class EditWorksheetDialog<T>
extends Dialog<Worksheet> {
    private static final Logger logger = LogManager.getLogger(EditWorksheetDialog.class);
    private static final String BINJR_SUGGEST = "binjr/suggest";
    private AutoCompletionBinding<String> autoCompletionBinding;
    private final Set<String> suggestedUnits;
    private static final String SUGGEST_WORKSHEET_UNITS = "suggest_worksheet_units";

    public EditWorksheetDialog(Worksheet<T> worksheet, Node owner) {
        Worksheet<T> resultWorksheet = new Worksheet<T>(worksheet);
        if (owner != null) {
            this.initOwner((Window)Dialogs.getStage(owner));
        }
        this.setTitle("Worksheet");
        Preferences prefs = Preferences.userRoot().node(BINJR_SUGGEST);
        this.suggestedUnits = new HashSet<String>(Arrays.asList(prefs.get(SUGGEST_WORKSHEET_UNITS, "").split(" ")));
        try {
            FXMLLoader fXMLLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("/views/EditWorkSheetDialog.fxml"));
            Parent parent = (Parent)fXMLLoader.load();
            this.setDialogPane((DialogPane)parent);
            TextField nameField = (TextField)parent.lookup("#nameField");
            TextField timezoneField = (TextField)parent.lookup("#timezoneField");
            TextField unitNameField = (TextField)parent.lookup("#unitNameField");
            ChoiceBox chartTypeChoice = (ChoiceBox)parent.lookup("#chartTypeChoice");
            ChoiceBox unitPrefixesChoice = (ChoiceBox)parent.lookup("#unitPrefixesChoice");
            ZonedDateTimePicker fromDatePicker = (ZonedDateTimePicker)parent.lookup("#fromDatePicker");
            ZonedDateTimePicker toDatePicker = (ZonedDateTimePicker)parent.lookup("#toDatePicker");
            unitNameField.textProperty().bindBidirectional(resultWorksheet.getDefaultChart().unitProperty());
            nameField.textProperty().bindBidirectional(resultWorksheet.nameProperty());
            TextFormatter formatter = new TextFormatter((StringConverter)new StringConverter<ZoneId>(){

                public String toString(ZoneId object) {
                    return object.toString();
                }

                public ZoneId fromString(String string) {
                    return ZoneId.of(string);
                }
            });
            formatter.valueProperty().bindBidirectional(resultWorksheet.timeZoneProperty());
            timezoneField.setTextFormatter(formatter);
            fromDatePicker.zoneIdProperty().bind(resultWorksheet.timeZoneProperty());
            toDatePicker.zoneIdProperty().bind(resultWorksheet.timeZoneProperty());
            fromDatePicker.dateTimeValueProperty().bindBidirectional(resultWorksheet.fromDateTimeProperty());
            toDatePicker.dateTimeValueProperty().bindBidirectional(resultWorksheet.toDateTimeProperty());
            chartTypeChoice.getItems().setAll((Collection)Arrays.stream(ChartType.values()).collect(Collectors.toSet()));
            chartTypeChoice.getSelectionModel().select((Object)resultWorksheet.getDefaultChart().getChartType());
            resultWorksheet.getDefaultChart().chartTypeProperty().bind((ObservableValue)chartTypeChoice.getSelectionModel().selectedItemProperty());
            unitPrefixesChoice.getItems().setAll((Object[])UnitPrefixes.values());
            unitPrefixesChoice.getSelectionModel().select((Object)resultWorksheet.getDefaultChart().getUnitPrefixes());
            resultWorksheet.getDefaultChart().unitPrefixesProperty().bind((ObservableValue)unitPrefixesChoice.getSelectionModel().selectedItemProperty());
            this.autoCompletionBinding = TextFields.bindAutoCompletion((TextField)unitNameField, this.suggestedUnits);
            Button okButton = (Button)this.getDialogPane().lookupButton(ButtonType.OK);
            okButton.addEventFilter(ActionEvent.ACTION, ae -> {
                try {
                    this.autoCompletionLearnWord(unitNameField);
                }
                catch (DateTimeException de) {
                    Dialogs.notifyError("Invalid Timezone", de.getLocalizedMessage(), Pos.CENTER, (Node)timezoneField);
                    ae.consume();
                }
            });
            this.setResultConverter(dialogButton -> {
                ButtonBar.ButtonData data;
                ButtonBar.ButtonData buttonData = data = dialogButton == null ? null : dialogButton.getButtonData();
                if (data == ButtonBar.ButtonData.OK_DONE) {
                    this.suggestedUnits.stream().reduce((s, s2) -> s + " " + s2).ifPresent(s -> prefs.put(SUGGEST_WORKSHEET_UNITS, (String)s));
                    return resultWorksheet;
                }
                return null;
            });
            TextFields.bindAutoCompletion((TextField)timezoneField, ZoneId.getAvailableZoneIds());
            timezoneField.setText(ZoneId.systemDefault().toString());
        }
        catch (IOException e) {
            logger.error("Failed to load /views/EditWorkSheetDialog.fxml", (Throwable)e);
        }
    }

    private void autoCompletionLearnWord(TextField field) {
        this.suggestedUnits.add(field.getText());
        if (this.autoCompletionBinding != null) {
            this.autoCompletionBinding.dispose();
        }
        this.autoCompletionBinding = TextFields.bindAutoCompletion((TextField)field, this.suggestedUnits);
    }
}

