/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.dialogs;

import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.dialogs.UserInterfaceThemes;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StageAppearanceManager {
    private static final Logger logger = LogManager.getLogger(StageAppearanceManager.class);
    private final Map<Stage, Set<AppearanceOptions>> registeredStages = new WeakHashMap<Stage, Set<AppearanceOptions>>();

    private StageAppearanceManager() {
        GlobalPreferences.getInstance().userInterfaceThemeProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                for (Map.Entry<Stage, Set<AppearanceOptions>> e : this.registeredStages.entrySet()) {
                    this.setAppearance(e.getKey(), (UserInterfaceThemes)((Object)newValue), e.getValue());
                }
            }
        });
    }

    public static StageAppearanceManager getInstance() {
        return Holder.instance;
    }

    public void unregister(Stage stage) {
        if (stage == null) {
            logger.warn(() -> "Trying to unregister a stage with null reference");
            return;
        }
        this.registeredStages.remove(stage);
        logger.trace(this::dumpRegisteredStages);
    }

    public void register(Stage stage) {
        this.register(stage, AppearanceOptions.SET_ALL);
    }

    public void register(Stage stage, AppearanceOptions ... options) {
        if (stage == null) {
            throw new IllegalArgumentException("Stage cannot be null");
        }
        EnumSet<AppearanceOptions> optionsEnumSet = EnumSet.copyOf(Arrays.asList(options));
        this.registeredStages.put(stage, optionsEnumSet);
        logger.trace(this::dumpRegisteredStages);
        Platform.runLater(() -> this.setAppearance(stage, GlobalPreferences.getInstance().getUserInterfaceTheme(), optionsEnumSet));
    }

    private String dumpRegisteredStages() {
        return this.registeredStages.size() + " registered stage(s): " + this.registeredStages.keySet().stream().map(s -> s.getTitle() + "(" + s.getWidth() + "x" + s.getHeight() + ")").collect(Collectors.joining(", "));
    }

    private void setAppearance(Stage stage, UserInterfaceThemes theme, Set<AppearanceOptions> options) {
        if (options.contains((Object)AppearanceOptions.SET_NONE)) {
            return;
        }
        if (options.contains((Object)AppearanceOptions.SET_ALL) || options.contains((Object)AppearanceOptions.SET_THEME)) {
            this.setUiTheme(stage.getScene(), theme);
        }
        if (options.contains((Object)AppearanceOptions.SET_ALL) || options.contains((Object)AppearanceOptions.SET_ICON)) {
            this.setIcon(stage);
        }
    }

    private void setIcon(Stage stage) {
        stage.getIcons().addAll((Object[])new Image[]{new Image(this.getClass().getResourceAsStream("/icons/binjr_16.png")), new Image(this.getClass().getResourceAsStream("/icons/binjr_32.png")), new Image(this.getClass().getResourceAsStream("/icons/binjr_48.png")), new Image(this.getClass().getResourceAsStream("/icons/binjr_128.png")), new Image(this.getClass().getResourceAsStream("/icons/binjr_256.png")), new Image(this.getClass().getResourceAsStream("/icons/binjr_512.png"))});
    }

    private void setUiTheme(Scene scene, UserInterfaceThemes theme) {
        Dialogs.runOnFXThread(() -> {
            scene.getStylesheets().clear();
            Application.setUserAgentStylesheet(null);
            scene.getStylesheets().addAll((Object[])new String[]{this.getClass().getResource("/css/Common.css").toExternalForm(), this.getClass().getResource("/css/Icons.css").toExternalForm(), this.getClass().getResource(theme.getCssPath()).toExternalForm()});
        });
    }

    private static class Holder {
        private static final StageAppearanceManager instance = new StageAppearanceManager();

        private Holder() {
        }
    }

    public static enum AppearanceOptions {
        SET_NONE,
        SET_ICON,
        SET_THEME,
        SET_ALL;


        public long getValue() {
            return 1 << this.ordinal();
        }
    }
}

