/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.preferences;

import eu.fthevenet.binjr.dialogs.ConsoleStage;
import eu.fthevenet.binjr.preferences.OsFamily;
import eu.fthevenet.binjr.preferences.SysInfoProperty;
import eu.fthevenet.util.version.Version;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Manifest;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class AppEnvironment {
    public static final String HTTP_GITHUB_REPO = "https://github.com/fthevenet/binjr";
    public static final String HTTP_WWW_BINJR_EU = "http://www.binjr.eu";
    public static final String HTTP_BINJR_WIKI = "https://github.com/fthevenet/binjr/wiki";
    public static final String COPYRIGHT_NOTICE = "Copyright (c) 2017-2018 Frederic Thevenet";
    public static final String LICENSE = "Apache-2.0";
    private final Level configuredRootLevel = LogManager.getRootLogger().getLevel();
    private final BooleanProperty debugMode = new SimpleBooleanProperty();
    private final BooleanProperty consoleVisible = new SimpleBooleanProperty();
    private final Property<Level> logLevel = new SimpleObjectProperty();
    private static final Logger logger = LogManager.getLogger(AppEnvironment.class);
    private final Manifest manifest = this.getManifest();
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();

    private AppEnvironment() {
        this.consoleVisible.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                ConsoleStage.show();
            } else {
                ConsoleStage.hide();
            }
        });
        this.logLevel.setValue((Object)LogManager.getRootLogger().getLevel());
        this.logLevel.addListener((observable, oldLevel, newLevel) -> {
            Configurator.setRootLevel((Level)newLevel);
            logger.info("Root logger level set to " + newLevel);
        });
        this.debugMode.addListener((observable, oldValue, newValue) -> {
            Level newLevel = this.configuredRootLevel;
            if (newValue.booleanValue() && newLevel.compareTo(Level.DEBUG) < 0) {
                newLevel = Level.DEBUG;
            }
            this.logLevel.setValue((Object)newLevel);
            this.consoleVisible.setValue(newValue);
        });
        this.debugMode.setValue(Boolean.valueOf(LogManager.getRootLogger().isDebugEnabled()));
    }

    public static AppEnvironment getInstance() {
        return EnvironmentHolder.instance;
    }

    public Version getVersion() {
        return this.getVersion(this.manifest);
    }

    public Version getVersion(Manifest manifest) {
        if (manifest != null) {
            String[] keys;
            for (String key : keys = new String[]{"Specification-Version", "Implementation-Version"}) {
                String value = manifest.getMainAttributes().getValue(key);
                if (value == null) continue;
                try {
                    return new Version(value);
                }
                catch (IllegalArgumentException e) {
                    logger.error("Could not decode version number: " + value + ": " + e.getMessage());
                    logger.debug(() -> "Full stack", (Throwable)e);
                }
            }
        }
        return Version.emptyVersion;
    }

    public Version getVersion(Class aClass) {
        return this.getVersion(this.getManifest(aClass));
    }

    public Manifest getManifest() {
        return this.getManifest(this.getClass());
    }

    public Manifest getManifest(Class<?> aClass) {
        String className = aClass.getSimpleName() + ".class";
        String classPath = aClass.getResource(className).toString();
        if (classPath.startsWith("jar")) {
            String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
            try {
                return new Manifest(new URL(manifestPath).openStream());
            }
            catch (IOException e) {
                logger.error("Error extracting manifest from jar: " + e.getMessage());
                logger.debug(() -> "Full stack", (Throwable)e);
            }
        }
        logger.warn("Could not extract MANIFEST from jar!");
        return null;
    }

    public String getAppDescription() {
        return "binjr v" + this.getVersion() + " (build #" + this.getBuildNumber() + ")";
    }

    public Long getBuildNumber() {
        String value;
        if (this.manifest != null && (value = this.manifest.getMainAttributes().getValue("Build-Number")) != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                logger.error("Could not decode build number: " + value + ": " + e.getMessage());
                logger.debug(() -> "Full stack", (Throwable)e);
            }
        }
        return 0L;
    }

    public List<SysInfoProperty> getSysInfoProperties() {
        Runtime rt = Runtime.getRuntime();
        double usedMB = ((double)rt.totalMemory() - (double)rt.freeMemory()) / 1024.0 / 1024.0;
        double percentUsage = ((double)rt.totalMemory() - (double)rt.freeMemory()) / (double)rt.totalMemory() * 100.0;
        ArrayList<SysInfoProperty> sysInfo = new ArrayList<SysInfoProperty>();
        sysInfo.add(new SysInfoProperty("Version", this.getVersion().toString() + " (build #" + this.getBuildNumber().toString() + ")"));
        sysInfo.add(new SysInfoProperty("Java Version", System.getProperty("java.version")));
        sysInfo.add(new SysInfoProperty("Java Vendor", System.getProperty("java.vendor")));
        sysInfo.add(new SysInfoProperty("Java VM name", System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.version") + ")"));
        sysInfo.add(new SysInfoProperty("Java Home", System.getProperty("java.home")));
        sysInfo.add(new SysInfoProperty("Operating System", System.getProperty("os.name") + " (" + System.getProperty("os.version") + ")"));
        sysInfo.add(new SysInfoProperty("System Architecture", System.getProperty("os.arch")));
        sysInfo.add(new SysInfoProperty("JVM Heap Max size", String.format("%.0f MB", (double)rt.maxMemory() / 1024.0 / 1024.0)));
        sysInfo.add(new SysInfoProperty("JVM Heap Usage", String.format("%.2f%% (%.0f/%.0f MB)", percentUsage, usedMB, (double)rt.totalMemory() / 1024.0 / 1024.0)));
        return sysInfo;
    }

    public OsFamily getOsFamily() {
        if (OS_NAME.startsWith("windows")) {
            return OsFamily.WINDOWS;
        }
        if (OS_NAME.startsWith("mac")) {
            return OsFamily.OSX;
        }
        if (OS_NAME.startsWith("linux")) {
            return OsFamily.LINUX;
        }
        return OsFamily.UNSUPPORTED;
    }

    public void setDebugMode(boolean value) {
        this.debugMode.setValue(Boolean.valueOf(value));
    }

    public boolean isDebugMode() {
        return this.debugMode.get();
    }

    public BooleanProperty debugModeProperty() {
        return this.debugMode;
    }

    public boolean isConsoleVisible() {
        return this.consoleVisible.get();
    }

    public BooleanProperty consoleVisibleProperty() {
        return this.consoleVisible;
    }

    public void setConsoleVisible(boolean consoleVisible) {
        this.consoleVisible.set(consoleVisible);
    }

    public Level getLogLevel() {
        return (Level)this.logLevel.getValue();
    }

    public Property<Level> logLevelProperty() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel.setValue((Object)logLevel);
    }

    private static class EnvironmentHolder {
        private static final AppEnvironment instance = new AppEnvironment();

        private EnvironmentHolder() {
        }
    }
}

