/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.preferences;

import eu.fthevenet.binjr.dialogs.UserInterfaceThemes;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.util.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalPreferences {
    private static final Logger logger = LogManager.getLogger(GlobalPreferences.class);
    private static final String BINJR_GLOBAL = "binjr/global";
    private static final String DOWN_SAMPLING_THRESHOLD = "downSamplingThreshold";
    private static final String DOWN_SAMPLING_ENABLED = "enableDownSampling";
    private static final String MOST_RECENT_SAVE_FOLDER = "mostRecentSaveFolder";
    private static final String MOST_RECENT_SAVED_WORKSPACE = "mostRecentSavedWorkspace";
    private static final String LOAD_LAST_WORKSPACE_ON_STARTUP = "loadLastWorkspaceOnStartup";
    private static final String CHECK_FOR_UPDATE_ON_START_UP = "checkForUpdateOnStartUp";
    private static final String UI_THEME_NAME = "userInterfaceTheme_v2";
    private static final String RECENT_FILES = "recentFiles";
    private static final String HORIZONTAL_MARKER_ON = "horizontalMarkerOn";
    private static final String VERTICAL_MARKER_ON = "verticalMarkerOn";
    private static final String SHOW_AREA_OUTLINE = "showAreaOutline";
    private static final String DEFAULT_GRAPH_OPACITY = "defaultGraphOpacity";
    private static final int MAX_RECENT_FILES = 20;
    private static final String PLUGINS_LOCATION = "pluginsLocation";
    private static final String DEFAULT_PLUGINS_LOCATION = System.getProperty("user.home");
    private static final String NOTIFICATION_POPUP_DURATION = "notificationPopupDuration";
    private static final String LOAD_PLUGINS_FROM_EXTERNAL_LOCATION = "loadPluginsFromExternalLocation";
    private static final Duration DEFAULT_NOTIFICATION_POPUP_DURATION = Duration.seconds((double)10.0);
    private final BooleanProperty loadLastWorkspaceOnStartup = new SimpleBooleanProperty();
    private final BooleanProperty downSamplingEnabled = new SimpleBooleanProperty();
    private final IntegerProperty downSamplingThreshold = new SimpleIntegerProperty();
    private final Property<Path> mostRecentSaveFolder = new SimpleObjectProperty();
    private final Property<Path> mostRecentSavedWorkspace = new SimpleObjectProperty();
    private final BooleanProperty checkForUpdateOnStartUp = new SimpleBooleanProperty();
    private final Property<UserInterfaceThemes> userInterfaceTheme = new SimpleObjectProperty();
    private final BooleanProperty horizontalMarkerOn = new SimpleBooleanProperty();
    private final BooleanProperty verticalMarkerOn = new SimpleBooleanProperty();
    private final BooleanProperty showAreaOutline = new SimpleBooleanProperty();
    private final DoubleProperty defaultGraphOpacity = new SimpleDoubleProperty();
    private final BooleanProperty shiftPressed = new SimpleBooleanProperty(false);
    private final BooleanProperty ctrlPressed = new SimpleBooleanProperty(false);
    private final Property<Path> pluginsLocation = new SimpleObjectProperty();
    private final Property<Duration> notificationPopupDuration = new SimpleObjectProperty();
    private final BooleanProperty loadPluginsFromExternalLocation = new SimpleBooleanProperty();
    private final Preferences prefs = Preferences.userRoot().node("binjr/global");
    private Deque<String> recentFiles;

    private GlobalPreferences() {
        this.load();
        this.mostRecentSaveFolder.addListener((observable, oldValue, newValue) -> this.prefs.put(MOST_RECENT_SAVE_FOLDER, newValue.toString()));
        this.downSamplingEnabled.addListener((observable, oldValue, newValue) -> this.prefs.putBoolean(DOWN_SAMPLING_ENABLED, (boolean)newValue));
        this.downSamplingThreshold.addListener((observable, oldValue, newValue) -> this.prefs.putInt(DOWN_SAMPLING_THRESHOLD, newValue.intValue()));
        this.mostRecentSavedWorkspace.addListener((observable, oldValue, newValue) -> this.prefs.put(MOST_RECENT_SAVED_WORKSPACE, newValue.toString()));
        this.loadLastWorkspaceOnStartup.addListener((observable, oldValue, newValue) -> this.prefs.putBoolean(LOAD_LAST_WORKSPACE_ON_STARTUP, (boolean)newValue));
        this.userInterfaceTheme.addListener((observable, oldValue, newValue) -> this.prefs.put(UI_THEME_NAME, newValue.name()));
        this.horizontalMarkerOn.addListener((observable, oldValue, newValue) -> this.prefs.putBoolean(HORIZONTAL_MARKER_ON, (boolean)newValue));
        this.verticalMarkerOn.addListener((observable, oldValue, newValue) -> this.prefs.putBoolean(VERTICAL_MARKER_ON, (boolean)newValue));
        this.showAreaOutline.addListener((observable, oldValue, newValue) -> this.prefs.putBoolean(SHOW_AREA_OUTLINE, (boolean)newValue));
        this.defaultGraphOpacity.addListener((observable, oldValue, newValue) -> this.prefs.putDouble(DEFAULT_GRAPH_OPACITY, newValue.doubleValue()));
        this.pluginsLocation.addListener((observable, oldValue, newValue) -> this.prefs.put(PLUGINS_LOCATION, newValue.toString()));
        this.notificationPopupDuration.addListener((observable, oldValue, newValue) -> this.prefs.putDouble(NOTIFICATION_POPUP_DURATION, newValue.toSeconds()));
        this.loadPluginsFromExternalLocation.addListener((observable, oldValue, newValue) -> this.prefs.putBoolean(LOAD_PLUGINS_FROM_EXTERNAL_LOCATION, (boolean)newValue));
    }

    private void load() {
        try {
            this.recentFiles = new ArrayDeque<String>(Arrays.stream(this.prefs.get(RECENT_FILES, "").split("\\|")).filter(s -> s != null && s.trim().length() > 0).collect(Collectors.toList()));
            this.showAreaOutline.setValue(Boolean.valueOf(this.prefs.getBoolean(SHOW_AREA_OUTLINE, false)));
            this.defaultGraphOpacity.setValue((Number)this.prefs.getDouble(DEFAULT_GRAPH_OPACITY, 0.8));
            this.verticalMarkerOn.setValue(Boolean.valueOf(this.prefs.getBoolean(VERTICAL_MARKER_ON, true)));
            this.horizontalMarkerOn.setValue(Boolean.valueOf(this.prefs.getBoolean(HORIZONTAL_MARKER_ON, false)));
            this.checkForUpdateOnStartUp.setValue(Boolean.valueOf(this.prefs.getBoolean(CHECK_FOR_UPDATE_ON_START_UP, true)));
            this.userInterfaceTheme.setValue((Object)UserInterfaceThemes.valueOf(this.prefs.get(UI_THEME_NAME, ""), UserInterfaceThemes.LIGHT));
            this.loadLastWorkspaceOnStartup.setValue(Boolean.valueOf(this.prefs.getBoolean(LOAD_LAST_WORKSPACE_ON_STARTUP, true)));
            this.mostRecentSavedWorkspace.setValue((Object)Paths.get(this.prefs.get(MOST_RECENT_SAVED_WORKSPACE, "Untitled"), new String[0]));
            this.downSamplingThreshold.setValue((Number)this.prefs.getInt(DOWN_SAMPLING_THRESHOLD, 5000));
            this.downSamplingEnabled.setValue(Boolean.valueOf(this.prefs.getBoolean(DOWN_SAMPLING_ENABLED, true)));
            this.mostRecentSaveFolder.setValue((Object)Paths.get(this.prefs.get(MOST_RECENT_SAVE_FOLDER, System.getProperty("user.home")), new String[0]));
            this.notificationPopupDuration.setValue((Object)Duration.seconds((double)this.prefs.getDouble(NOTIFICATION_POPUP_DURATION, DEFAULT_NOTIFICATION_POPUP_DURATION.toSeconds())));
            this.pluginsLocation.setValue((Object)Paths.get(this.prefs.get(PLUGINS_LOCATION, DEFAULT_PLUGINS_LOCATION), new String[0]));
            this.loadPluginsFromExternalLocation.setValue(Boolean.valueOf(this.prefs.getBoolean(LOAD_PLUGINS_FROM_EXTERNAL_LOCATION, false)));
        }
        catch (Exception e) {
            logger.error("Error while loading application preferences", (Throwable)e);
        }
    }

    public void reset() throws BackingStoreException {
        this.prefs.clear();
        this.load();
    }

    public static GlobalPreferences getInstance() {
        return GlobalPreferencesHolder.instance;
    }

    public Boolean getDownSamplingEnabled() {
        return this.downSamplingEnabled.getValue();
    }

    public BooleanProperty downSamplingEnabledProperty() {
        return this.downSamplingEnabled;
    }

    public void setDownSamplingEnabled(boolean downSamplingEnabled) {
        this.downSamplingEnabled.setValue(Boolean.valueOf(downSamplingEnabled));
    }

    public int getDownSamplingThreshold() {
        return this.downSamplingThreshold.getValue();
    }

    public IntegerProperty downSamplingThresholdProperty() {
        return this.downSamplingThreshold;
    }

    public void setDownSamplingThreshold(int downSamplingThreshold) {
        this.downSamplingThreshold.setValue((Number)downSamplingThreshold);
    }

    public Path getMostRecentSaveFolder() {
        Path validatedPath = Paths.get(System.getProperty("user.home"), new String[0]);
        try {
            if (this.mostRecentSaveFolder.getValue() != null && ((Path)this.mostRecentSaveFolder.getValue()).toRealPath(LinkOption.NOFOLLOW_LINKS) != null && ((Path)this.mostRecentSaveFolder.getValue()).toFile().isDirectory()) {
                validatedPath = (Path)this.mostRecentSaveFolder.getValue();
            } else {
                logger.error("MostRecentSaveFolder property does not point to a valid directory");
            }
        }
        catch (Exception e) {
            logger.error("MostRecentSaveFolder property does not point to a valid directory", (Throwable)e);
        }
        return validatedPath;
    }

    public Property<Path> mostRecentSaveFolderProperty() {
        return this.mostRecentSaveFolder;
    }

    public void setMostRecentSaveFolder(Path mostRecentSaveFolder) {
        if (mostRecentSaveFolder == null) {
            throw new IllegalArgumentException("mostRecentSaveFolder parameter cannot be null");
        }
        if (!mostRecentSaveFolder.toFile().isDirectory() && (mostRecentSaveFolder = mostRecentSaveFolder.getParent()) == null) {
            throw new IllegalArgumentException("mostRecentSaveFolder is not a directory");
        }
        this.mostRecentSaveFolder.setValue((Object)mostRecentSaveFolder);
    }

    public Optional<Path> getMostRecentSavedWorkspace() {
        return Paths.get("Untitled", new String[0]).equals(this.mostRecentSavedWorkspace.getValue()) ? Optional.empty() : Optional.of(this.mostRecentSavedWorkspace.getValue());
    }

    public Property<Path> mostRecentSavedWorkspaceProperty() {
        return this.mostRecentSavedWorkspace;
    }

    public void setMostRecentSavedWorkspace(Path mostRecentSavedWorkspace) {
        if (mostRecentSavedWorkspace == null) {
            throw new IllegalArgumentException("mostRecentSavedWorkspace parameter cannot be null");
        }
        this.mostRecentSavedWorkspace.setValue((Object)mostRecentSavedWorkspace);
    }

    public boolean isLoadLastWorkspaceOnStartup() {
        return this.loadLastWorkspaceOnStartup.get();
    }

    public BooleanProperty loadLastWorkspaceOnStartupProperty() {
        return this.loadLastWorkspaceOnStartup;
    }

    public void setLoadLastWorkspaceOnStartup(boolean loadLastWorkspaceOnStartup) {
        this.loadLastWorkspaceOnStartup.set(loadLastWorkspaceOnStartup);
    }

    public UserInterfaceThemes getUserInterfaceTheme() {
        return (UserInterfaceThemes)((Object)this.userInterfaceTheme.getValue());
    }

    public Property<UserInterfaceThemes> userInterfaceThemeProperty() {
        return this.userInterfaceTheme;
    }

    public void setUserInterfaceTheme(UserInterfaceThemes userInterfaceTheme) {
        this.userInterfaceTheme.setValue((Object)userInterfaceTheme);
    }

    public void removeFromRecentFiles(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter cannot be null");
        }
        if (this.recentFiles.contains(value)) {
            this.recentFiles.remove(value);
            this.prefs.put(RECENT_FILES, this.recentFiles.stream().collect(Collectors.joining("|")));
        }
    }

    public void putToRecentFiles(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value parameter cannot be null");
        }
        if (this.recentFiles.contains(value)) {
            this.recentFiles.remove(value);
        }
        this.recentFiles.addFirst(value);
        if (this.recentFiles.size() > 20) {
            this.recentFiles.removeLast();
        }
        this.prefs.put(RECENT_FILES, this.recentFiles.stream().collect(Collectors.joining("|")));
    }

    public Collection<String> getRecentFiles() {
        return this.recentFiles;
    }

    public boolean isCheckForUpdateOnStartUp() {
        return this.checkForUpdateOnStartUp.get();
    }

    public BooleanProperty checkForUpdateOnStartUpProperty() {
        return this.checkForUpdateOnStartUp;
    }

    public void setCheckForUpdateOnStartUp(boolean checkForUpdateOnStartUp) {
        this.checkForUpdateOnStartUp.set(checkForUpdateOnStartUp);
    }

    public boolean getHorizontalMarkerOn() {
        return this.horizontalMarkerOn.get();
    }

    public BooleanProperty horizontalMarkerOnProperty() {
        return this.horizontalMarkerOn;
    }

    public void setHorizontalMarkerOn(boolean horizontalMarkerOn) {
        this.horizontalMarkerOn.set(horizontalMarkerOn);
    }

    public boolean getVerticalMarkerOn() {
        return this.verticalMarkerOn.get();
    }

    public BooleanProperty verticalMarkerOnProperty() {
        return this.verticalMarkerOn;
    }

    public void setVerticalMarkerOn(boolean verticalMarkerOn) {
        this.verticalMarkerOn.set(verticalMarkerOn);
    }

    public boolean isShowAreaOutline() {
        return this.showAreaOutline.getValue();
    }

    public BooleanProperty showAreaOutlineProperty() {
        return this.showAreaOutline;
    }

    public void setShowAreaOutline(boolean showAreaOutline) {
        this.showAreaOutline.setValue(Boolean.valueOf(showAreaOutline));
    }

    public double getDefaultGraphOpacity() {
        return this.defaultGraphOpacity.get();
    }

    public DoubleProperty defaultGraphOpacityProperty() {
        return this.defaultGraphOpacity;
    }

    public void setDefaultGraphOpacity(double defaultGraphOpacity) {
        this.defaultGraphOpacity.set(defaultGraphOpacity);
    }

    public Boolean isShiftPressed() {
        return this.shiftPressed.get();
    }

    public void setShiftPressed(Boolean shiftPressed) {
        this.shiftPressed.set(shiftPressed.booleanValue());
    }

    public BooleanProperty shiftPressedProperty() {
        return this.shiftPressed;
    }

    public Boolean isCtrlPressed() {
        return this.ctrlPressed.getValue();
    }

    public void setCtrlPressed(Boolean ctrlPressed) {
        this.ctrlPressed.set(ctrlPressed.booleanValue());
    }

    public BooleanProperty ctrlPressedProperty() {
        return this.ctrlPressed;
    }

    public Path getPluginsLocation() {
        return (Path)this.pluginsLocation.getValue();
    }

    public void setPluginsLocation(Path pluginsLocation) {
        this.pluginsLocation.setValue((Object)pluginsLocation);
    }

    public Property<Path> pluginsLocationProperty() {
        return this.pluginsLocation;
    }

    public Duration getNotificationPopupDuration() {
        return (Duration)this.notificationPopupDuration.getValue();
    }

    public Property<Duration> notificationPopupDurationProperty() {
        return this.notificationPopupDuration;
    }

    public void setNotificationPopupDuration(Duration notificationPopupDuration) {
        this.notificationPopupDuration.setValue((Object)notificationPopupDuration);
    }

    public boolean isLoadPluginsFromExternalLocation() {
        return this.loadPluginsFromExternalLocation.get();
    }

    public BooleanProperty loadPluginsFromExternalLocationProperty() {
        return this.loadPluginsFromExternalLocation;
    }

    public void setLoadPluginsFromExternalLocation(boolean loadPluginsFromExternalLocation) {
        this.loadPluginsFromExternalLocation.set(loadPluginsFromExternalLocation);
    }

    private static class GlobalPreferencesHolder {
        private static final GlobalPreferences instance = new GlobalPreferences();

        private GlobalPreferencesHolder() {
        }
    }
}

