/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.preferences;

import eu.fthevenet.binjr.data.async.AsyncTaskManager;
import eu.fthevenet.binjr.preferences.AppEnvironment;
import eu.fthevenet.util.github.GithubApi;
import eu.fthevenet.util.github.GithubRelease;
import eu.fthevenet.util.version.Version;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.prefs.Preferences;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateManager {
    private static final Logger logger = LogManager.getLogger(UpdateManager.class);
    private static final String GITHUB_OWNER = "fthevenet";
    private static final String GITHUB_REPO = "binjr";
    private static final String LAST_CHECK_FOR_UPDATE = "lastCheckForUpdate";
    private static final String BINJR_UPDATE = "binjr/update";
    private Property<LocalDateTime> lastCheckForUpdate;

    private UpdateManager() {
        Preferences prefs = Preferences.userRoot().node(BINJR_UPDATE);
        this.lastCheckForUpdate = new SimpleObjectProperty((Object)LocalDateTime.parse(prefs.get(LAST_CHECK_FOR_UPDATE, "1900-01-01T00:00:00"), DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        this.lastCheckForUpdate.addListener((observable, oldValue, newValue) -> prefs.put(LAST_CHECK_FOR_UPDATE, newValue.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME)));
    }

    public static UpdateManager getInstance() {
        return UpdateManagerHolder.instance;
    }

    public void asyncCheckForUpdate(Consumer<GithubRelease> newReleaseAvailable, Consumer<Version> upToDate, Runnable onFailure) {
        this.asyncCheckForUpdate(newReleaseAvailable, upToDate, onFailure, false);
    }

    public void asyncForcedCheckForUpdate(Consumer<GithubRelease> newReleaseAvailable, Consumer<Version> upToDate, Runnable onFailure) {
        this.asyncCheckForUpdate(newReleaseAvailable, upToDate, onFailure, true);
    }

    public LocalDateTime getLastCheckForUpdate() {
        return (LocalDateTime)this.lastCheckForUpdate.getValue();
    }

    public Property<LocalDateTime> lastCheckForUpdateProperty() {
        return this.lastCheckForUpdate;
    }

    private void setLastCheckForUpdate(LocalDateTime lastCheckForUpdate) {
        this.lastCheckForUpdate.setValue((Object)lastCheckForUpdate);
    }

    private void asyncCheckForUpdate(Consumer<GithubRelease> newReleaseAvailable, Consumer<Version> upToDate, Runnable onFailure, boolean forceCheck) {
        if (forceCheck || LocalDateTime.now().minus(1L, ChronoUnit.HOURS).isAfter(this.getLastCheckForUpdate())) {
            this.setLastCheckForUpdate(LocalDateTime.now());
            Task<Optional<GithubRelease>> getLatestTask = new Task<Optional<GithubRelease>>(){

                protected Optional<GithubRelease> call() throws Exception {
                    logger.trace("getNewRelease running on " + Thread.currentThread().getName());
                    return GithubApi.getInstance().getLatestRelease(UpdateManager.GITHUB_OWNER, UpdateManager.GITHUB_REPO).filter(r -> r.getVersion().compareTo(AppEnvironment.getInstance().getVersion()) > 0);
                }
            };
            getLatestTask.setOnSucceeded(arg_0 -> UpdateManager.lambda$asyncCheckForUpdate$1((Task)getLatestTask, newReleaseAvailable, upToDate, arg_0));
            getLatestTask.setOnFailed(arg_0 -> UpdateManager.lambda$asyncCheckForUpdate$2((Task)getLatestTask, onFailure, arg_0));
            AsyncTaskManager.getInstance().submit(getLatestTask);
        } else {
            logger.trace(() -> "Available update check ignored as it already took place less than 1 hour ago.");
        }
    }

    private static /* synthetic */ void lambda$asyncCheckForUpdate$2(Task getLatestTask, Runnable onFailure, WorkerStateEvent workerStateEvent) {
        logger.error("Error while checking for update", getLatestTask.getException());
        if (onFailure != null) {
            onFailure.run();
        }
    }

    private static /* synthetic */ void lambda$asyncCheckForUpdate$1(Task getLatestTask, Consumer newReleaseAvailable, Consumer upToDate, WorkerStateEvent workerStateEvent) {
        logger.trace("UI update running on " + Thread.currentThread().getName());
        Optional latest = (Optional)getLatestTask.getValue();
        Version current = AppEnvironment.getInstance().getVersion();
        if (latest.isPresent()) {
            newReleaseAvailable.accept(latest.get());
        } else if (upToDate != null) {
            upToDate.accept(current);
        }
    }

    private static class UpdateManagerHolder {
        private static final UpdateManager instance = new UpdateManager();

        private UpdateManagerHolder() {
        }
    }
}

