/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.sources.csv.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.adapters.TimeSeriesBinding;
import eu.fthevenet.binjr.data.codec.CsvDecoder;
import eu.fthevenet.binjr.data.codec.DataSample;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.data.exceptions.FetchingDataFromAdapterException;
import eu.fthevenet.binjr.data.exceptions.InvalidAdapterParameterException;
import eu.fthevenet.binjr.data.timeseries.DoubleTimeSeriesProcessor;
import eu.fthevenet.binjr.data.timeseries.TimeSeriesProcessor;
import eu.fthevenet.binjr.data.workspace.ChartType;
import eu.fthevenet.binjr.data.workspace.TimeSeriesInfo;
import eu.fthevenet.binjr.data.workspace.UnitPrefixes;
import eu.fthevenet.util.logging.Profiler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javafx.scene.chart.XYChart;
import javafx.scene.control.TreeItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CsvFileAdapter
extends DataAdapter<Double, CsvDecoder<Double>> {
    private static final Logger logger = LogManager.getLogger(CsvFileAdapter.class);
    private String dateTimePattern;
    private Path csvPath;
    private ZoneId zoneId;
    private Character delimiter;
    private String encoding;
    private CsvDecoder<Double> decoder;
    private SortedMap<Long, DataSample<Double>> sortedDataStore;
    private List<String> headers;

    public CsvFileAdapter() throws DataAdapterException {
        this("", ZoneId.systemDefault(), "utf-8", "yyyy-MM-dd HH:mm:ss", ',');
    }

    public CsvFileAdapter(String csvPath, ZoneId zoneId) throws DataAdapterException {
        this(csvPath, zoneId, "utf-8", "yyyy-MM-dd HH:mm:ss", ',');
    }

    public CsvFileAdapter(String csvPath, ZoneId zoneId, String encoding, String dateTimePattern, char delimiter) throws DataAdapterException {
        this.csvPath = Paths.get(csvPath, new String[0]);
        this.zoneId = zoneId;
        this.encoding = encoding;
        this.dateTimePattern = dateTimePattern;
        this.delimiter = Character.valueOf(delimiter);
    }

    @Override
    public TreeItem<TimeSeriesBinding<Double>> getBindingTree() throws DataAdapterException {
        TreeItem tree = new TreeItem(new TimeSeriesBinding<Double>("", "/", null, this.getSourceName(), UnitPrefixes.METRIC, ChartType.STACKED, "-", "/" + this.getSourceName(), this));
        try (InputStream in = Files.newInputStream(this.csvPath, new OpenOption[0]);){
            this.headers = ((CsvDecoder)this.getDecoder()).getDataColumnHeaders(in);
            for (String header : this.headers) {
                TimeSeriesBinding<Double> b = new TimeSeriesBinding<Double>(header, header, null, header, UnitPrefixes.METRIC, ChartType.STACKED, "-", "/" + this.getSourceName() + "/" + header, this);
                tree.getChildren().add((Object)new TreeItem(b));
            }
        }
        catch (IOException e) {
            throw new FetchingDataFromAdapterException(e);
        }
        return tree;
    }

    @Override
    public Map<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>> fetchDecodedData(String path, Instant begin, Instant end, List<TimeSeriesInfo<Double>> seriesInfo, boolean bypassCache) throws DataAdapterException {
        if (this.isClosed()) {
            throw new IllegalStateException("An attempt was made to fetch data from a closed adapter");
        }
        HashMap<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>> series = new HashMap<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>>();
        HashMap<String, TimeSeriesInfo<Double>> rDict = new HashMap<String, TimeSeriesInfo<Double>>();
        for (TimeSeriesInfo<Double> timeSeriesInfo : seriesInfo) {
            rDict.put(timeSeriesInfo.getBinding().getLabel(), timeSeriesInfo);
            series.put(timeSeriesInfo, new DoubleTimeSeriesProcessor());
        }
        for (DataSample dataSample : this.getDataStore().subMap(begin.getEpochSecond(), end.getEpochSecond()).values()) {
            for (String n : dataSample.getCells().keySet()) {
                TimeSeriesInfo i = (TimeSeriesInfo)rDict.get(n);
                if (i == null) continue;
                ((TimeSeriesProcessor)series.get(i)).addSample(new XYChart.Data((Object)dataSample.getTimeStamp(), dataSample.getCells().get(n)));
            }
        }
        return series;
    }

    @Override
    public InputStream fetchRawData(String path, Instant begin, Instant end, boolean bypassCache) throws DataAdapterException {
        throw new UnsupportedOperationException("Recovery of raw data is not supported for this data source.");
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public ZoneId getTimeZoneId() {
        return this.zoneId;
    }

    @Override
    public CsvDecoder<Double> getDecoder() {
        if (this.decoder == null) {
            this.decoder = new CsvDecoder<Double>(this.getEncoding(), this.delimiter.charValue(), DoubleTimeSeriesProcessor::new, s -> {
                try {
                    Double val = Double.parseDouble(s);
                    return val.isNaN() ? 0.0 : val;
                }
                catch (NumberFormatException e) {
                    logger.debug(() -> "Cannot format value as a number", (Throwable)e);
                    return 0.0;
                }
            }, s -> ZonedDateTime.parse(s, DateTimeFormatter.ofPattern(this.dateTimePattern).withZone(this.getTimeZoneId())));
        }
        return this.decoder;
    }

    @Override
    public String getSourceName() {
        return "[CSV] " + (this.csvPath != null ? this.csvPath.getFileName() : "???") + " (" + (this.zoneId != null ? this.zoneId : "???") + ")";
    }

    @Override
    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("zoneId", this.zoneId.toString());
        params.put("encoding", this.encoding);
        params.put("delimiter", Character.toString(this.delimiter.charValue()));
        params.put("dateTimePattern", this.dateTimePattern);
        params.put("csvPath", this.csvPath.toString());
        return params;
    }

    @Override
    public void loadParams(Map<String, String> params) throws DataAdapterException {
        if (params == null) {
            throw new InvalidAdapterParameterException("Could not find parameter list for adapter " + this.getSourceName());
        }
        this.zoneId = this.validateParameter(params, "zoneId", s -> {
            if (s == null) {
                throw new InvalidAdapterParameterException("Parameter zoneId is missing in adpater " + this.getSourceName());
            }
            return ZoneId.of(s);
        });
        String path = this.validateParameterNullity(params, "csvPath");
        this.delimiter = this.validateParameter(params, "delimiter", s -> {
            if (s == null || s.isEmpty() || s.length() > 1) {
                throw new InvalidAdapterParameterException("Parameter 'delimiter' is missing for adapter " + this.getSourceName());
            }
            return Character.valueOf(s.charAt(0));
        });
        this.encoding = this.validateParameterNullity(params, "encoding");
        this.dateTimePattern = this.validateParameterNullity(params, "dateTimePattern");
        this.csvPath = Paths.get(path, new String[0]);
    }

    @Override
    public boolean ping() {
        return Files.exists(this.csvPath, new LinkOption[0]);
    }

    @Override
    public void close() {
        if (this.sortedDataStore != null) {
            this.sortedDataStore.clear();
        }
        super.close();
    }

    protected SortedMap<Long, DataSample<Double>> getDataStore() throws DataAdapterException {
        if (this.sortedDataStore == null) {
            try (InputStream in = Files.newInputStream(this.csvPath, new OpenOption[0]);){
                this.sortedDataStore = this.buildSortedDataStore(in);
            }
            catch (IOException e) {
                throw new DataAdapterException(e);
            }
        }
        return this.sortedDataStore;
    }

    private SortedMap<Long, DataSample<Double>> buildSortedDataStore(InputStream in) throws IOException, DataAdapterException {
        ConcurrentSkipListMap<Long, DataSample<Double>> dataStore = new ConcurrentSkipListMap<Long, DataSample<Double>>();
        try (Profiler ignored = Profiler.start("Building seekable datastore for csv file", arg_0 -> ((Logger)logger).trace(arg_0));){
            ((CsvDecoder)this.getDecoder()).decode(in, this.headers, sample -> dataStore.put(sample.getTimeStamp().toEpochSecond(), (DataSample<Double>)sample));
        }
        return dataStore;
    }
}

