/*
 * Decompiled with CFR 0.152.
 */
package eu.fthevenet.binjr.sources.csv.adapters;

import eu.fthevenet.binjr.data.adapters.DataAdapter;
import eu.fthevenet.binjr.data.exceptions.CannotInitializeDataAdapterException;
import eu.fthevenet.binjr.data.exceptions.DataAdapterException;
import eu.fthevenet.binjr.dialogs.DataAdapterDialog;
import eu.fthevenet.binjr.dialogs.Dialogs;
import eu.fthevenet.binjr.preferences.GlobalPreferences;
import eu.fthevenet.binjr.sources.csv.adapters.CsvFileAdapter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.ZoneId;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.stage.Window;

public class CsvFileAdapterDialog
extends DataAdapterDialog {
    private final TextField dateFormatPattern = new TextField("yyyy-MM-dd HH:mm:ss");
    private final TextField encodingField = new TextField("utf-8");
    private final TextField separatorField = new TextField(",");
    private int pos = 2;

    public CsvFileAdapterDialog(Node owner) {
        super(owner, DataAdapterDialog.Mode.PATH);
        this.parent.setHeaderText("Add a csv file");
        this.addParamField(this.dateFormatPattern, "Date Format:");
        this.addParamField(this.encodingField, "Encoding:");
        this.addParamField(this.separatorField, "Separator:");
    }

    private void addParamField(TextField field, String label) {
        GridPane.setConstraints((Node)field, (int)1, (int)this.pos, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS, (Insets)new Insets(4.0, 0.0, 4.0, 0.0));
        Label tabsLabel = new Label(label);
        GridPane.setConstraints((Node)tabsLabel, (int)0, (int)this.pos, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS, (Insets)new Insets(4.0, 0.0, 4.0, 0.0));
        this.paramsGridPane.getChildren().addAll((Object[])new Node[]{field, tabsLabel});
        ++this.pos;
    }

    @Override
    protected File displayFileChooser(Node owner) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open CSV file");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Comma-separated values files", new String[]{"*.csv"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All files", new String[]{"*.*"}));
        fileChooser.setInitialDirectory(GlobalPreferences.getInstance().getMostRecentSaveFolder().toFile());
        return fileChooser.showOpenDialog((Window)Dialogs.getStage(owner));
    }

    protected DataAdapter getDataAdapter() throws DataAdapterException {
        if (!Files.exists(Paths.get(this.uriField.getText(), new String[0]), new LinkOption[0])) {
            throw new CannotInitializeDataAdapterException("Cannot find " + this.uriField.getText());
        }
        return new CsvFileAdapter(this.uriField.getText(), ZoneId.of(this.timezoneField.getText()), this.encodingField.getText(), this.dateFormatPattern.getText(), this.separatorField.getText().charAt(0));
    }
}

